# Q400 MFD/EFIS by D-ECHO based on
# Q400 Engine Display
# Joshua Davidson (it0uchpods)

#	References:	http://www.smartcockpit.com/docs/Q400-Power_Plant.pdf
#			https://quizlet.com/2663067/q400-limitations-flash-cards/
#			http://www.smartcockpit.com/docs/Q400-Indicating_and_Recording_Systems.pdf

var ED_only = nil;
var ED_display = nil;

#	Properties also used by the MFDs are set up in eis-setup.nas
var powercmdL	=	props.globals.getNode("/fdm/jsbsim/fcs/throttle-cmd-norm[0]", 1);
var powercmdR	=	props.globals.getNode("/fdm/jsbsim/fcs/throttle-cmd-norm[1]", 1);
var reverserL	=	props.globals.getNode("/engines/engine[0]/reversed", 1);
var reverserR	=	props.globals.getNode("/engines/engine[1]/reversed", 1);
var condL	=	props.globals.getNode("/controls/engines/engine[0]/condition-lever-state", 1);
var condR	=	props.globals.getNode("/controls/engines/engine[1]/condition-lever-state", 1);
var oilpnL 	=	props.globals.initNode("/MFD/oil-pressure-needle[0]", 0.0, "DOUBLE");
var oilpnR 	=	props.globals.initNode("/MFD/oil-pressure-needle[1]", 0.0, "DOUBLE");
var oiltnL 	=	props.globals.initNode("/MFD/oil-temperature-needle[0]", 0.0, "DOUBLE");
var oiltnR 	=	props.globals.initNode("/MFD/oil-temperature-needle[1]", 0.0, "DOUBLE");
var bleed1  = props.globals.getNode("/controls/pneumatic/switches/bleed1", 1);
var bleed2  = props.globals.getNode("/controls/pneumatic/switches/bleed2", 1);
var oilCL = nil;
var oilCR = nil;
var fuelCL = nil;
var fuelCR = nil;
var oilPSIL = nil;
var oilPSIR = nil;
var rpmleft = nil;
var rpmright = nil;

#	Setup
var instrument_path = "Aircraft/QSeries/Models/Cockpit/Instruments/EIS/";


var canvas_ED_base = {
	init: func(canvas_group, file) {

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.ed.getDoubleValue() >= 10) {
			ED_only.page.show();
			ED_only.update();
		} else {
			ED_only.page.hide();
		}
	},
};

var canvas_ED_only = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ED_only,canvas_ED_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["TRQL.needle","TRQL.percent","TRQL.target","TRQR.needle","TRQR.percent","TRQR.target",
		"RPML.needle","RPMR.needle","RPML","RPMR","ITTL.needle","ITTL","ITTR.needle","ITTR",
		"oilpressL.needle","OilPressL","oilpressR.needle","OilPressR","OilTempL","oiltempL.needle","OilTempR","oiltempR.needle",
		"FFL","FFR","LeftQuantity","RightQuantity","FuelTempL","FuelTempR","SAT","thrustdtL","thrustdtR","powerpctL","powerpctR",
		"NHL.needle","NHL.percent","NHR.needle","NHR.percent","NLL.percent","NLR.percent",
		"OSGTest1","AFTest","OSGTestStatus1","AFTestStatus","Bleed1","Bleed2",
		"annun.iomsfail","annun.dubadconf"];
	},
	update: func() {
		var thrustmode = [
			eng.thrustmode[0].getValue(),
			eng.thrustmode[1].getValue(),
		];
		me["thrustdtL"].setText( thrustmode[0] );
		me["thrustdtR"].setText( thrustmode[1] );
		
		var powercmd0=powercmdL.getValue();
		var powercmd1=powercmdR.getValue();
		var rvs0=reverserL.getValue();
		var rvs1=reverserR.getValue();
		if (thrustmode[0]=="NTOP" and !rvs0) {
			var pwrpct0=powercmd0/0.72*100;
		} else if (thrustmode[0]=="MTOP" and !rvs0) {
			var pwrpct0=powercmd0/0.8*100;
		} else if (thrustmode[0]=="MCL" and !rvs0) {
			var pwrpct0=powercmd0/0.65*100;
		} else if (thrustmode[0]=="MCR" and !rvs0) {
			var pwrpct0=powercmd0/0.62*100;
		} else if (thrustmode[0]=="EMERG" and !rvs0) {
			var pwrpct0=powercmd0*100;
		} else{
			var pwrpct0=0;
		}
		
		if (thrustmode[1]=="NTOP" and !rvs1) {
			var pwrpct1=powercmd1/0.72*100;
		} else if (thrustmode[1]=="MTOP" and !rvs1) {
			var pwrpct1=powercmd1/0.8*100;
		} else if (thrustmode[1]=="MCL" and !rvs1) {
			var pwrpct1=powercmd1/0.65*100;
		} else if (thrustmode[1]=="MCR" and !rvs1) {
			var pwrpct1=powercmd1/0.62*100;
		} else if (thrustmode[1]=="EMERG" and !rvs1) {
			var pwrpct1=powercmd1*100;
		} else{
			var pwrpct1=0;
		}
		
		me["powerpctL"].setText(sprintf("%s", math.round(pwrpct0)));
		me["powerpctR"].setText(sprintf("%s", math.round(pwrpct1)));
		
	
		var TRQLpercent = eng.torque[0].getDoubleValue() / (-26110) * 100;
		var TRQRpercent = eng.torque[1].getDoubleValue() / (-26110) * 100;
	
		me["TRQL.needle"].setRotation(TRQLpercent*0.034);
		me["TRQL.target"].setRotation(powercmd0*3.4);
		me["TRQL.percent"].setText(sprintf("%s", math.round(TRQLpercent)));
		if (condL.getValue()<=1) {
			me["TRQL.target"].hide();
		} else{
			me["TRQL.target"].show();		
		}
		
		me["TRQR.needle"].setRotation(TRQRpercent*0.034);
		me["TRQR.target"].setRotation(powercmd1*3.4);
		me["TRQR.percent"].setText(sprintf("%s", math.round(TRQRpercent)));
		if (condR.getValue()<=1) {
			me["TRQR.target"].hide();
		} else{
			me["TRQR.target"].show();		
		}
		
		rpmleft  = eng.rpm[0].getDoubleValue();
		rpmright = eng.rpm[1].getDoubleValue();
		
		me["RPML.needle"].setRotation(rpmleft*0.00323);
		me["RPML"].setText(sprintf("%s", math.round(rpmleft)));
		
		me["RPMR.needle"].setRotation(rpmright*0.00323);
		me["RPMR"].setText(sprintf("%s", math.round(rpmright)));
		
		var ittLC = eng.itt[0].getDoubleValue();
		var ittRC = eng.itt[1].getDoubleValue();
		
		me["ITTL.needle"].setRotation(ittLC*0.002895);
		me["ITTL"].setText(sprintf("%s", math.round(ittLC)));
		
		me["ITTR.needle"].setRotation(ittRC*0.002895);
		me["ITTR"].setText(sprintf("%s", math.round(ittRC)));
		
		var nhL = eng.n2[0].getDoubleValue();
		var nhR = eng.n2[1].getDoubleValue();
		
		me["NHL.needle"].setRotation(nhL*D2R*1.63);
		me["NHL.percent"].setText(sprintf("%4.1f",nhL));
		me["NHR.needle"].setRotation(nhR*D2R*1.63);
		me["NHR.percent"].setText(sprintf("%4.1f",nhR));
		
		me["NLL.percent"].setText(sprintf("%3d", eng.n1[0].getDoubleValue() ));
		me["NLR.percent"].setText(sprintf("%3d", eng.n1[0].getDoubleValue() ));
		
		oilPSIL = eng.oil.pressure[0].getDoubleValue();
		oilPSIR = eng.oil.pressure[1].getDoubleValue();
		
		me["oilpressL.needle"].setRotation( oilpnL.getValue() * -D2R);
		me["OilPressL"].setText(sprintf("%s", math.round(oilPSIL)));
		
		me["oilpressR.needle"].setRotation( oilpnR.getValue() * -D2R);
		me["OilPressR"].setText(sprintf("%s", math.round(oilPSIR)));
		
		if (oilPSIL<44) {
			me["OilPressL"].setColor(1,0,0);
			me["oilpressL.needle"].setColor(1,0,0);
		} else if (oilPSIL<61 or oilPSIL>72) {
			me["OilPressL"].setColor(1,1,0);
			me["oilpressL.needle"].setColor(1,1,0);
		} else{
			me["OilPressL"].setColor(1,1,1);
			me["oilpressL.needle"].setColor(1,1,1)
		}
		if (oilPSIR<44) {
			me["OilPressR"].setColor(1,0,0);
			me["oilpressR.needle"].setColor(1,0,0);
		} else if (oilPSIR<61 or oilPSIR>72) {
			me["OilPressR"].setColor(1,1,0);
			me["oilpressR.needle"].setColor(1,1,0);
		} else{
			me["OilPressR"].setColor(1,1,1);
			me["oilpressR.needle"].setColor(1,1,1)
		}
		
		oilCL = eng.oil.temperature[0].getDoubleValue() or 0;
		oilCR = eng.oil.temperature[1].getDoubleValue() or 0;
		
		me["oiltempL.needle"].setRotation( oiltnL.getDoubleValue() * D2R );
		me["OilTempL"].setText(sprintf("%3d", math.round(oilCL)));
		
		me["oiltempR.needle"].setRotation( oiltnR.getDoubleValue() * D2R);
		me["OilTempR"].setText(sprintf("%3d", math.round(oilCR)));
		
		if (oilCL<55 or oilCL>125) {
			me["oiltempL.needle"].setColor(1,0,0);
			me["OilTempL"].setColor(1,0,0);
		} else if (oilCL<65 or oilCL>115) {
			me["oiltempL.needle"].setColor(1,1,0);
			me["OilTempL"].setColor(1,1,1);
		} else{
			me["oiltempL.needle"].setColor(1,1,1);
			me["OilTempL"].setColor(1,1,1);
		}
		if (oilCR<55 or oilCR>125) {
			me["oiltempR.needle"].setColor(1,0,0);
			me["OilTempR"].setColor(1,0,0);
		} else if (oilCR<65 or oilCR>115) {
			me["oiltempR.needle"].setColor(1,1,0);
			me["OilTempR"].setColor(1,1,1);
		} else{
			me["oiltempR.needle"].setColor(1,1,1);
			me["OilTempR"].setColor(1,1,1);
		}
		
		me["FFL"].setText(sprintf("%4d", math.round( eng.fuel_flow[0].getDoubleValue() )));
		me["FFR"].setText(sprintf("%4d", math.round( eng.fuel_flow[1].getDoubleValue() )));
		
		me["LeftQuantity"].setText(  sprintf( "%s", math.round( fuel.quantity[0].getDoubleValue() ) ) );
		me["RightQuantity"].setText( sprintf( "%s", math.round( fuel.quantity[1].getDoubleValue() ) ) );
		
		fuelCL = fuel.temperature[0].getDoubleValue() or 0;
		fuelCR = fuel.temperature[1].getDoubleValue() or 0;
		me["FuelTempL"].setText(sprintf("%2d", math.round(fuelCL)));
		me["FuelTempR"].setText(sprintf("%2d", math.round(fuelCR)));
		if (fuelCL>71) {
			me["FuelTempL"].setColor(1,0,0);
		} else if (fuelCL<0) {
			me["FuelTempL"].setColor(1,1,0);
		} else{
			me["FuelTempL"].setColor(1,1,1);
		}
		if (fuelCR>71) {
			me["FuelTempR"].setColor(1,0,0);
		} else if (fuelCR<0) {
			me["FuelTempR"].setColor(1,1,0);
		} else{
			me["FuelTempR"].setColor(1,1,1);
		}
		
		me["SAT"].setText( sprintf( "%+3d", math.round( sat.getDoubleValue() ) ) );
		
		me["OSGTest1"].hide();
		me["OSGTestStatus1"].hide();
		me["AFTest"].hide();
		me["AFTestStatus"].hide();
		me["annun.iomsfail"].hide();
		me["annun.dubadconf"].hide();
		
		if (bleed1.getValue()) {
			me["Bleed1"].show();
		} else {
			me["Bleed1"].hide();
		}
		
		if (bleed2.getValue()) {
			me["Bleed2"].show();
		} else {
			me["Bleed2"].hide();
		}
	},
};

var ED_base_loop = maketimer( 0.3, canvas_ED_base.update );
ED_base_loop.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	ED_display = canvas.new({
		"name": "ED",
		"size": [512, 721],
		"view": [512, 721],
		"mipmapping": 1
	});
	var ED_avail = canvas.new({
		"name": "ED AVAIL",
		"size": [512, 721],
		"view": [512, 721],
		"mipmapping": 1
	});
	ED_avail.addPlacement({"node": "du3.avail_screen"});
	canvas.parsesvg( ED_avail.createGroup(), instrument_path~"canvas/avail.svg",  {'font-mapper': font_mapper} );
	
	ED_display.addPlacement({"node": "du3.screen"});
	ED_display.addPlacement({"node": "du2.screen.ED"});
	ED_display.addPlacement({"node": "du4.screen.ED"});
	var groupED = ED_display.createGroup();

	ED_only = canvas_ED_only.new(groupED, instrument_path~"canvas/ed/ED.svg");

	ED_only.update();
	ED_base_loop.start();
});

