# Simulation of Alpha Electro Altimeter (ALT) by Benedikt Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

# References:
#	https://www.kanardia.eu/wp-content/uploads/2019/01/Altimeter-Manual.pdf
#	POH (see -jsb.xml)

var ALT_main = nil;
var ALT_display = nil;

var ALT = props.globals.getNode("instrumentation/altimeter/indicated-altitude-ft", 1);
var ALT_qnh = props.globals.getNode("instrumentation/altimeter/setting-hpa", 1);
var ALT_fl = props.globals.getNode("instrumentation/altimeter/mode-c-alt-ft", 1);

var volts = props.globals.getNode("systems/electrical/outputs/instruments", 1);

var instrument_dir = "Aircraft/Phoenix/Models/Instruments/ALT/";


var canvas_ALT_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {	
		if ( volts.getDoubleValue() > 10) {
			ALT_main.page.show();
			ALT_main.update();
		} else {
			ALT_main.page.hide();
		}
	},
};
	
	
var canvas_ALT_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ALT_main , canvas_ALT_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["qnh","flightlevel","alt"];
	},
	update: func() {
		
		#Altitude
		var altitude = ALT.getValue();
		var fl = ALT_fl.getValue();
		
		me["alt"].setText(sprintf("%5d", math.round(altitude, 10)));
		me["qnh"].setText(sprintf("%4d", math.round(ALT_qnh.getValue()))); 
		me["flightlevel"].setText(sprintf("%03d", math.round(fl/100))); 
	}
	
};

var base_updater = maketimer( 0.02, canvas_ALT_base.update );
base_updater.simulatedTime = 1;



setlistener("sim/signals/fdm-initialized", func {
	ALT_display = canvas.new({
		"name": "ALT",
		"size": [256, 128],
		"view": [256, 128],
		"mipmapping": 1
	});
	ALT_display.addPlacement({"node": "ALT.display"});
	var groupMain = ALT_display.createGroup();


	ALT_main = canvas_ALT_main.new(groupMain, instrument_dir~"ALT_main.svg");

	base_updater.start();
});
