#Initialise
var engine1 = engines.Jet.new(0, 0, 0.01, 5.21, 3, 4, 2, 4);
var engine2 = engines.Jet.new(1, 0, 0.01, 5.21, 3, 4, 2, 4);

engine1.init();
engine2.init();

props.globals.initNode("/sim/autostart/startedJET", 0, "BOOL");
props.globals.initNode("/sim/autostart/started", 0, "BOOL");

# Jets
var eng1fuelon = func { setprop("/controls/engines/engine[0]/cutoff", 0); }
var eng2fuelon = func { setprop("/controls/engines/engine[1]/cutoff", 0); }

var eng1fueloff = func { setprop("/controls/engines/engine[0]/cutoff", 1); }
var eng2fueloff = func { setprop("/controls/engines/engine[1]/cutoff", 1); }

# Pistons
var eng3fuelon = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon = func { setprop("/controls/engines/engine[3]/cutoff", 0); }

var eng3fueloff = func {
  setprop("/controls/engines/engine[2]/cutoff", 1);
  setprop("/controls/engines/engine[2]/throttle", 0);
}
var eng4fueloff = func {
  setprop("/controls/engines/engine[3]/cutoff", 1);
  setprop("/controls/engines/engine[3]/throttle", 0);
}

# Jets
var eng1starter = func { setprop("/controls/engines/engine[0]/starter", 1); }
var eng2starter = func { setprop("/controls/engines/engine[1]/starter", 1); }
var eng1stop    = func { setprop("/controls/engines/engine[0]/starter", 0); }
var eng2stop    = func { setprop("/controls/engines/engine[1]/starter", 0); }
# Pistons
var eng3starter = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter = func { setprop("/controls/engines/engine[3]/starter", 1); }
var eng3stop    = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4stop    = func { setprop("/controls/engines/engine[3]/starter", 0); }

var eng1start = func {
  gui.popupTip("*** Jet start left  ***");
  eng1fuelon();
  eng1starter();
  setprop("/controls/engines/engine[0]/condition", 1);
}

var eng2start = func {
  gui.popupTip("*** Jet start right  ***");
  eng2fuelon();
  eng2starter();
  setprop("/controls/engines/engine[1]/condition", 1);
}

var eng3start = func {
  gui.popupTip("*** Engine start left ***");
  eng3fueloff();
  eng3starter();
  settimer(eng3fuelon, 2);
  settimer(eng3stop, 4);
}

var eng4start = func {
  gui.popupTip("*** Engine start right ***");
  eng4fueloff();
  eng4starter();
  settimer(eng4fuelon, 2);
  settimer(eng4stop, 4);
}

var engstartJET = func {
  settimer(eng1start, 2);
  settimer(eng2start, 6);
}

var engstart = func {
  settimer(eng3start, 2);
  settimer(eng4start, 6);
}

var engstopJET = func {
  eng1fueloff();
  eng1stop();
  setprop("/controls/engines/engine[0]/throttle", 0);
  setprop("/controls/engines/engine[0]/condition", 0);
  eng2fueloff();
  eng2stop();
  setprop("/controls/engines/engine[1]/throttle", 0);
  setprop("/controls/engines/engine[1]/condition", 0);
}

var engstop = func {
  eng3fueloff();
  eng3stop();
  eng4fueloff();
  eng4stop();
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    setprop("/controls/electric/battery-switch", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Pistons Engines");
  } else {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    setprop("/controls/electric/battery-switch", 0);
    engstop();
  }
}

var autostartJET = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Start pistons engines before...");
  } else {
    var startstatusJET = getprop("/sim/autostart/startedJET");
    if ( startstatusJET == 0 ) {
      gui.popupTip("Autostarting JET...");
      setprop("/sim/model/autostartJET", 1);
      setprop("/sim/autostart/startedJET", 1);
      settimer(engstartJET, 0.4);
      gui.popupTip("Starting Jet Engines");
    } else {
      gui.popupTip("Shutting Down JET...");
      setprop("/sim/model/autostartJET", 0);
      setprop("/sim/autostart/startedJET", 0);
      engstopJET();
    }
  }
}
