#Initialise
var engine1 = engines.Jet.new(0, 0, 0.01, 5.21, 3, 4, 2, 4);
var engine2 = engines.Jet.new(1, 0, 0.01, 5.21, 3, 4, 2, 4);
var engine3 = engines.Jet.new(2, 0, 0.01, 5.21, 3, 4, 2, 4);
var engine4 = engines.Jet.new(3, 0, 0.01, 5.21, 3, 4, 2, 4);

engine1.init();
engine2.init();
engine3.init();
engine4.init();

props.globals.initNode("/sim/autostart/started", 0, "BOOL");

# Jet ------------------------------------
var eng1fuelon   = func { setprop("/controls/engines/engine[0]/cutoff", 0); }
var eng2fuelon   = func { setprop("/controls/engines/engine[1]/cutoff", 0); }
var eng3fuelon   = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon   = func { setprop("/controls/engines/engine[3]/cutoff", 0); }
# Piston
var eng5fuelon   = func { setprop("/controls/engines/engine[4]/cutoff", 0); }
var eng6fuelon   = func { setprop("/controls/engines/engine[5]/cutoff", 0); }
var eng7fuelon   = func { setprop("/controls/engines/engine[6]/cutoff", 0); }
var eng8fuelon   = func { setprop("/controls/engines/engine[7]/cutoff", 0); }
var eng9fuelon   = func { setprop("/controls/engines/engine[8]/cutoff", 0); }
var eng10fuelon  = func { setprop("/controls/engines/engine[9]/cutoff", 0); }

# Jet ------------------------------------
var eng1fueloff  = func { setprop("/controls/engines/engine[0]/cutoff", 1); }
var eng2fueloff  = func { setprop("/controls/engines/engine[1]/cutoff", 1); }
var eng3fueloff  = func { setprop("/controls/engines/engine[2]/cutoff", 1); }
var eng4fueloff  = func { setprop("/controls/engines/engine[3]/cutoff", 1); }
# Piston
var eng5fueloff  = func {
  setprop("/controls/engines/engine[4]/cutoff", 1);
  setprop("/controls/engines/engine[4]/throttle", 0);
}
var eng6fueloff  = func {
  setprop("/controls/engines/engine[5]/cutoff", 1);
  setprop("/controls/engines/engine[5]/throttle", 0);
}
var eng7fueloff  = func {
  setprop("/controls/engines/engine[6]/cutoff", 1);
  setprop("/controls/engines/engine[6]/throttle", 0);
}
var eng8fueloff  = func {
  setprop("/controls/engines/engine[7]/cutoff", 1);
  setprop("/controls/engines/engine[7]/throttle", 0);
}
var eng9fueloff  = func {
  setprop("/controls/engines/engine[8]/cutoff", 1);
  setprop("/controls/engines/engine[8]/throttle", 0);
}
var eng10fueloff = func {
  setprop("/controls/engines/engine[9]/cutoff", 1);
  setprop("/controls/engines/engine[9]/throttle", 0);
}

# Jet ------------------------------------
var eng1starter   = func { setprop("/controls/engines/engine[0]/starter", 1); }
var eng2starter   = func { setprop("/controls/engines/engine[1]/starter", 1); }
var eng3starter   = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter   = func { setprop("/controls/engines/engine[3]/starter", 1); }
# Piston
var eng5starter   = func { setprop("/controls/engines/engine[4]/starter", 1); }
var eng6starter   = func { setprop("/controls/engines/engine[5]/starter", 1); }
var eng7starter   = func { setprop("/controls/engines/engine[6]/starter", 1); }
var eng8starter   = func { setprop("/controls/engines/engine[7]/starter", 1); }
var eng9starter   = func { setprop("/controls/engines/engine[8]/starter", 1); }
var eng10starter  = func { setprop("/controls/engines/engine[9]/starter", 1); }

var eng5cranking  = func { setprop("/engines/engine[4]/cranking", 1); }
var eng6cranking  = func { setprop("/engines/engine[5]/cranking", 1); }
var eng7cranking  = func { setprop("/engines/engine[6]/cranking", 1); }
var eng8cranking  = func { setprop("/engines/engine[7]/cranking", 1); }
var eng9cranking  = func { setprop("/engines/engine[8]/cranking", 1); }
var eng10cranking = func { setprop("/engines/engine[9]/cranking", 1); }

# Jet ------------------------------------
var eng1staroff   = func { setprop("/controls/engines/engine[0]/starter", 0); }
var eng2staroff   = func { setprop("/controls/engines/engine[1]/starter", 0); }
var eng3staroff   = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4staroff   = func { setprop("/controls/engines/engine[3]/starter", 0); }
# Piston
var eng5staroff   = func { setprop("/controls/engines/engine[4]/starter", 0); }
var eng6staroff   = func { setprop("/controls/engines/engine[5]/starter", 0); }
var eng7staroff   = func { setprop("/controls/engines/engine[6]/starter", 0); }
var eng8staroff   = func { setprop("/controls/engines/engine[7]/starter", 0); }
var eng9staroff   = func { setprop("/controls/engines/engine[8]/starter", 0); }
var eng10staroff  = func { setprop("/controls/engines/engine[9]/starter", 0); }

var eng5crankoff  = func { setprop("/engines/engine[4]/cranking", 0); }
var eng6crankoff  = func { setprop("/engines/engine[5]/cranking", 0); }
var eng7crankoff  = func { setprop("/engines/engine[6]/cranking", 0); }
var eng8crankoff  = func { setprop("/engines/engine[7]/cranking", 0); }
var eng9crankoff  = func { setprop("/engines/engine[8]/cranking", 0); }
var eng10crankoff = func { setprop("/engines/engine[9]/cranking", 0); }

# Jet ------------------------------------
var eng1start = func {
  gui.popupTip("*** Jet Engine start left exterior ***");
  eng1fueloff();
  eng1starter();
  settimer(eng1fuelon, 2);
  setprop("/controls/engines/engine[0]/condition", 1);
}

var eng2start = func {
  gui.popupTip("*** Jet Engine start left interior ***");
  eng2fueloff();
  eng2starter();
  settimer(eng2fuelon, 2);
  setprop("/controls/engines/engine[1]/condition", 1);
}

var eng3start = func {
  gui.popupTip("*** Jet Engine start right interior ***");
  eng3fueloff();
  eng3starter();
  settimer(eng3fuelon, 2);
  setprop("/controls/engines/engine[2]/condition", 1);
}

var eng4start = func {
  gui.popupTip("*** Jet Engine start right exterior ***");
  eng4fueloff();
  eng4starter();
  settimer(eng4fuelon, 2);
  setprop("/controls/engines/engine[3]/condition", 1);
}

# Piston ------------------------------------
var eng5start = func {
  gui.popupTip("*** Piston Engine start left exterior ***");
  eng5fueloff();
  eng5starter();
  eng5cranking();
  settimer(eng5fuelon, 2);
  settimer(eng5staroff, 4);
  settimer(eng5crankoff, 4);
}

var eng6start = func {
  gui.popupTip("*** Piston Engine start left center ***");
  eng6fueloff();
  eng6starter();
  eng6cranking();
  settimer(eng6fuelon, 2);
  settimer(eng6staroff, 4);
  settimer(eng6crankoff, 4);
}

var eng7start = func {
  gui.popupTip("*** Piston Engine start left interior ***");
  eng7fueloff();
  eng7starter();
  eng7cranking();
  settimer(eng7fuelon, 2);
  settimer(eng7staroff, 4);
  settimer(eng7crankoff, 4);
}

var eng8start = func {
  gui.popupTip("*** Piston Engine start right interior ***");
  eng8fueloff();
  eng8starter();
  eng8cranking();
  settimer(eng8fuelon, 2);
  settimer(eng8staroff, 4);
  settimer(eng8crankoff, 4);
}

var eng9start = func {
  gui.popupTip("*** Piston Engine start right center ***");
  eng9fueloff();
  eng9starter();
  eng9cranking();
  settimer(eng9fuelon, 2);
  settimer(eng9staroff, 4);
  settimer(eng9crankoff, 4);
}

var eng10start = func {
  gui.popupTip("*** Piston Engine start right exterior ***");
  eng10fueloff();
  eng10starter();
  eng10cranking();
  settimer(eng10fuelon, 2);
  settimer(eng10staroff, 4);
  settimer(eng10crankoff, 4);
}

var engstart = func {
  # Piston engines
  settimer(eng5start,  2);
  settimer(eng10start, 4);
  settimer(eng6start,  6);
  settimer(eng9start,  8);
  settimer(eng7start, 10);
  settimer(eng8start, 12);
  # Jet engines
  settimer(eng1start, 14);
  settimer(eng4start, 16);
  settimer(eng2start, 18);
  settimer(eng3start, 20);
}

var engstop = func {
  # Piston engines
  settimer(eng5fueloff,  1);
  settimer(eng10fueloff, 1);
  settimer(eng6fueloff,  1);
  settimer(eng9fueloff,  1);
  settimer(eng7fueloff,  1);
  settimer(eng8fueloff,  1);
  # Jet engines
  eng1fueloff();
  setprop("/controls/engines/engine[0]/throttle", 0);
  setprop("/controls/engines/engine[0]/condition", 0);
  eng4fueloff();
  setprop("/controls/engines/engine[3]/throttle", 0);
  setprop("/controls/engines/engine[3]/condition", 0);
  eng2fueloff();
  setprop("/controls/engines/engine[1]/throttle", 0);
  setprop("/controls/engines/engine[1]/condition", 0);
  eng3fueloff();
  setprop("/controls/engines/engine[2]/throttle", 0);
  setprop("/controls/engines/engine[2]/condition", 0);
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    setprop("/controls/electric/battery-switch", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Engines");
  }
  if ( startstatus == 1 ) {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    engstop();
  }
}
