#	Failure Training

var property_base = props.globals.initNode("/systems/failure-training");
var min_time_p = property_base.initNode("min-time", 1.0, "DOUBLE");
var max_time_p = property_base.initNode("max-time", 5.0, "DOUBLE");
var max_failures_p = property_base.initNode("max-failures", 3, "INT");
var failure_messages_p = property_base.initNode("failure-messages", 0, "BOOL");

var min_time = min_time_p.getDoubleValue();
var max_time = max_time_p.getDoubleValue();
var max_failures = max_failures_p.getIntValue();
var failure_messages = failure_messages_p.getBoolValue();

setlistener( min_time_p, func { 
	min_time = min_time_p.getDoubleValue();
	if( min_time > max_time ){
		min_time_p.setDoubleValue( max_time );
	}
});

setlistener( max_time_p, func {
	max_time = max_time_p.getDoubleValue();
	if( min_time > max_time ){
		max_time_p.setDoubleValue( min_time );
	}
});

setlistener( max_failures_p, func {
	max_failures = max_failures_p.getIntValue();
	if( max_failures > size( failures ) ){
		max_failures = size( failures );
		max_failures_p.setIntValue( size( failures ) );
	}
});

setlistener( failure_messages_p, func {
	failure_messages = failure_messages_p.getBoolValue();
});

var failure = {
	new: func( name, property, normal_value, fail_value = nil ){
		var obj = {
			parents: [ failure ],
			name: name,
			property: props.globals.getNode( property, 1 ),
			normal_value: normal_value,
			fail_value: fail_value,
			active: 0,
		};
		return obj;
	},
	fail: func {
		if( me.fail_value != nil ){
			me.property.setValue( me.fail_value );
		} else {
			me.property.setValue( 1 - rand() * 0.8 ); # if fail_value is undefined, the value can be any value between 0.2 and (including) 1 to be failed
		}
		if( failure_messages ){
			screen.log.write( me.name, 1, 0.5, 0 );
		}
		me.active = 1;
	},
	reset: func {
		me.property.setValue( me.normal_value );
		me.active = 0;
	},
};

var failures = [
	failure.new( "SYSTEM ISOLATION FAILURE", "/systems/electrical/components/system-isolation-serviceable", 1, 0 ),
	failure.new( "DC/DC COMMUNICATION FAILURE", "/systems/electrical/components/dcdc-communication-serviceable", 1, 0 ),
	failure.new( "DC/DC FAILURE", "/systems/electrical/components/dcdc-serviceable", 1, 0 ),
	failure.new( "AUX BATTERY FAILURE", "/systems/electrical/components/aux-battery-serviceable", 1, 0 ),
	failure.new( "POWER LEVER COMMUNICATION FAILURE", "/engines/engine[0]/components/power-lever-communication-serviceable", 1, 0 ),
	failure.new( "ENGINE COOLANT PUMP FAILURE", "/systems/cooling/engine-coolant-pump-serviceable", 1, 0 ),
	failure.new( "PITOT LINE BROKEN", "/systems/pitot/failures/line-broken", 0, 1 ),
	failure.new( "PITOT TOTAL BLOCKAGE", "/systems/pitot/failures/blockage-total", 0 ),
	failure.new( "PITOT BLOCKAGE, DRAIN HOLE FREE", "/systems/pitot/failures/blockage-free-drain", 0 ),
	failure.new( "STATIC LINE BROKEN", "/systems/static/failures/line-broken", 0, 1 ),
	failure.new( "STATIC BLOCKAGE LEFT", "/systems/static/failures/blockage-left", 0 ),
	failure.new( "STATIC BLOCKAGE RIGHT", "/systems/static/failures/blockage-right", 0 ),
];

if( alphaelectro.variant ){
	append( failures, failure.new( "BATTERY COOLANT PUMP 1 FAILURE", "/systems/cooling/battery-coolant-pump-serviceable[0]", 1, 0 ) );
	append( failures, failure.new( "BATTERY COOLANT PUMP 2 FAILURE", "/systems/cooling/battery-coolant-pump-serviceable[1]", 1, 0 ) );
	append( failures, failure.new( "BATTERY FAN FAILURE", "/systems/cooling/battery-fan-serviceable", 1, 0 ) );
}

var training_running = 0;

var start = func {	# triggered by the GUI
	screen.log.write( "Failure Training Started", 0, 1, 0 );
	if( training_running )	stop();
	training_running = 1;
	main();
}

var stop = func {	# triggered by start() or the GUI
	screen.log.write( "Failure Training Stopped", 0, 1, 0 );
	training_running = 0;
	eval();
	foreach( var el; failures ){
		el.reset();
	}
}

var eval = func {	# triggered by stop()
	screen.log.write( "Failure Training Evaluation:", 0, 1, 0 );
	
	foreach( var el; failures ){
		if( el.active ){
			screen.log.write( el.name, 1, 0.5, 0 );
		}
	}
	
}

var n_failures = 0;

var main = func {
	if( n_failures < max_failures ){
		# spawn a new failure
		settimer( new_failure, min_time * 60 + ( max_time - min_time ) * rand() * 60 );
	}
}

var new_failure = func {
	# Look for a non-active failure
	var found = 0;
	var n = 0;
	while( !found ) {
		var i = int( rand() * size( failures ) );
		if( !failures[i].active ){
			found = 1;
			failures[i].fail();
		}
		if( n < 99 ){	
			n += 1;
		} else {
			screen.log.write("Failure Simulation: Exceeded maximum amount of new failure tries!", 1, 0, 0);
			screen.log.write("Failure Simulation: No new failure spawned!", 1, 0, 0);
			found = 1;
		}
	}
	
	main();	# Return to main function
}
