/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public abstract class AbstractLink
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private IModel<?> bodyModel;

    public AbstractLink(String id) {
        this(id, null);
    }

    public AbstractLink(String id, IModel<?> model) {
        super(id, model);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        IModel<?> tmpBodyModel = this.getBody();
        if (tmpBodyModel != null && tmpBodyModel.getObject() != null) {
            this.replaceComponentTagBody(markupStream, openTag, this.getDefaultModelObjectAsString(tmpBodyModel.getObject()));
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
    }

    protected void disableLink(ComponentTag tag) {
        if ("button".equalsIgnoreCase(tag.getName()) || "input".equalsIgnoreCase(tag.getName())) {
            tag.put("disabled", "disabled");
        } else {
            tag.remove("href");
            tag.remove("onclick");
        }
    }

    public IModel<?> getBody() {
        return this.bodyModel;
    }

    public AbstractLink setBody(IModel<?> bodyModel) {
        this.bodyModel = this.wrap(bodyModel);
        return this;
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        if (this.bodyModel != null) {
            this.bodyModel.detach();
        }
    }
}

