/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousPageStore
implements IPageStore {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousPageStore.class);
    private static final long OFFER_WAIT = 30L;
    private static final long POLL_WAIT = 1000L;
    private Thread pageSavingThread;
    private final IPageStore delegate;
    private final BlockingQueue<Entry> entries;
    private final ConcurrentMap<String, Entry> entryMap;

    public AsynchronousPageStore(IPageStore delegate, int capacity) {
        this.delegate = (IPageStore)Args.notNull((Object)delegate, (String)"delegate");
        this.entries = new LinkedBlockingQueue<Entry>(capacity);
        this.entryMap = new ConcurrentHashMap<String, Entry>();
        this.pageSavingThread = new Thread((Runnable)new PageSavingRunnable(), "Wicket-AsyncPageStore-PageSavingThread");
        this.pageSavingThread.setDaemon(true);
        this.pageSavingThread.start();
    }

    private Entry getEntry(String sessionId, int pageId) {
        return (Entry)this.entryMap.get(AsynchronousPageStore.getKey(sessionId, pageId));
    }

    private static String getKey(String sessionId, int pageId) {
        return pageId + ":::" + sessionId;
    }

    @Override
    public void destroy() {
        Thread thread = this.pageSavingThread;
        this.pageSavingThread = null;
        if (thread != null && thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.delegate.destroy();
    }

    @Override
    public IManageablePage getPage(String sessionId, int pageId) {
        Entry entry = this.getEntry(sessionId, pageId);
        if (entry != null) {
            log.debug("Returning the page of a non-stored entry with session id '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
            return entry.page;
        }
        IManageablePage page = this.delegate.getPage(sessionId, pageId);
        log.debug("Returning the page of a stored entry with session id '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
        return page;
    }

    @Override
    public void removePage(String sessionId, int pageId) {
        Entry entry;
        String key = AsynchronousPageStore.getKey(sessionId, pageId);
        if (key != null && (entry = (Entry)this.entryMap.remove(key)) != null) {
            this.entries.remove(entry);
        }
        this.delegate.removePage(sessionId, pageId);
    }

    @Override
    public void storePage(String sessionId, IManageablePage page) {
        block5: {
            if (this.pageSavingThread == null) {
                return;
            }
            Entry entry = new Entry(sessionId, page);
            String key = entry.getKey();
            this.entryMap.put(key, entry);
            try {
                if (this.entries.offer(entry, 30L, TimeUnit.MILLISECONDS)) {
                    log.debug("Offered for storing asynchronously page with id '{}' in session '{}'", (Object)page.getPageId(), (Object)sessionId);
                } else {
                    log.debug("Storing synchronously page with id '{}' in session '{}'", (Object)page.getPageId(), (Object)sessionId);
                    this.entryMap.remove(key);
                    this.delegate.storePage(sessionId, page);
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.pageSavingThread == null) break block5;
                this.entryMap.remove(key);
                this.delegate.storePage(sessionId, page);
            }
        }
    }

    @Override
    public void unbind(String sessionId) {
        this.entries.removeIf(entry -> {
            if (((Entry)entry).sessionId.equals(sessionId)) {
                this.entryMap.remove(((Entry)entry).getKey());
                return true;
            }
            return false;
        });
        this.delegate.unbind(sessionId);
    }

    @Override
    public Serializable prepareForSerialization(String sessionId, Serializable page) {
        return this.delegate.prepareForSerialization(sessionId, page);
    }

    @Override
    public Object restoreAfterSerialization(Serializable serializable) {
        return this.delegate.restoreAfterSerialization(serializable);
    }

    @Override
    public IManageablePage convertToPage(Object page) {
        return this.delegate.convertToPage(page);
    }

    @Override
    public boolean canBeAsynchronous() {
        return false;
    }

    private class PageSavingRunnable
    implements Runnable {
        private PageSavingRunnable() {
        }

        @Override
        public void run() {
            while (AsynchronousPageStore.this.pageSavingThread != null) {
                Entry entry = null;
                try {
                    entry = (Entry)AsynchronousPageStore.this.entries.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.debug("PageSavingRunnable:: Interrupted...");
                    Thread.currentThread().interrupt();
                }
                if (entry == null || AsynchronousPageStore.this.pageSavingThread == null) continue;
                try {
                    log.debug("PageSavingRunnable:: Saving asynchronously: {}...", (Object)entry);
                    AsynchronousPageStore.this.delegate.storePage(entry.sessionId, entry.page);
                }
                catch (Exception x) {
                    log.error("An error occurred while saving asynchronously '{}'", (Object)entry, (Object)x);
                }
                finally {
                    AsynchronousPageStore.this.entryMap.remove(entry.getKey());
                }
            }
        }
    }

    private static class Entry {
        private final String sessionId;
        private final IManageablePage page;

        public Entry(String sessionId, IManageablePage page) {
            this.sessionId = (String)Args.notNull((Object)sessionId, (String)"sessionId");
            this.page = (IManageablePage)Args.notNull((Object)page, (String)"page");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.page.getPageId();
            result = 31 * result + this.sessionId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.page.getPageId() != other.page.getPageId()) {
                return false;
            }
            return this.sessionId.equals(other.sessionId);
        }

        private String getKey() {
            return AsynchronousPageStore.getKey(this.sessionId, this.page.getPageId());
        }

        public String toString() {
            return "Entry [sessionId=" + this.sessionId + ", pageId=" + this.page.getPageId() + ", pageClass=" + Classes.name(this.page.getClass()) + "]";
        }
    }
}

