/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.upload.FileDescription;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public abstract class FilesSelectedBehavior
extends OnChangeAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavaScriptResourceReference(FilesSelectedBehavior.class, "FilesSelectedBehavior.js");

    @Override
    protected void onBind() {
        super.onBind();
        Component component = this.getComponent();
        if (!(component instanceof FileUploadField)) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a FileUploadField");
        }
    }

    @Override
    protected void onUpdate(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        ArrayList<FileDescription> fileDescriptions = new ArrayList<FileDescription>();
        IRequestParameters parameters = request.getRequestParameters();
        StringValue fileInfos = parameters.getParameterValue("fileInfos");
        JSONArray jsonArray = new JSONArray(fileInfos.toString());
        for (int i = 0; i < jsonArray.length(); ++i) {
            fileDescriptions.add(new FileDescription((JSONObject)jsonArray.get(i)));
        }
        this.onSelected(target, fileDescriptions);
    }

    protected abstract void onSelected(AjaxRequestTarget var1, List<FileDescription> var2);

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.getAjaxCallListeners().add(new IAjaxCallListener(){

            @Override
            public CharSequence getPrecondition(Component component) {
                return "return Wicket.FilesSelected.precondition(this);";
            }
        });
        attributes.getDynamicExtraParameters().add("return Wicket.FilesSelected.collectFilesDetails('" + this.getComponent().getMarkupId() + "');");
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(JavaScriptHeaderItem.forReference(JS));
    }

    public static FilesSelectedBehavior onSelected(final SerializableBiConsumer<AjaxRequestTarget, List<FileDescription>> select) {
        Args.notNull(select, (String)"select");
        return new FilesSelectedBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSelected(AjaxRequestTarget target, List<FileDescription> fileDescriptions) {
                select.accept((Object)target, fileDescriptions);
            }
        };
    }
}

