package org.apache.anakia;


/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.apache.anakia.test.Log;
import org.apache.anakia.test.TestUtil;


/**
 * This is a test case for Anakia. Right now, it simply will compare
 * two index.html files together. These are produced as a result of
 * first running Anakia and then running this test.
 *
 * @version $Id: AnakiaTestCase.java 525405 2007-04-04 05:16:37Z wglass $
 */
public class AnakiaTestCase extends TestCase
{
    public static final String TEST_DIR_KEY = "test.compare.dir";
    public static final String RESULTS_DIR_KEY = "test.results.dir";
    
    private String resultsDir;
    private String compareDir;
    
    /**
     * Creates a new instance.
     *
     */
    public AnakiaTestCase(String name)
    {
        super(name);
    }

    public static Test suite()
    {
        return new TestSuite(AnakiaTestCase.class);
    }
    
    /**
     * Find the directories.
     */
    public void setUp()
    {
        resultsDir = System.getProperty(RESULTS_DIR_KEY, "bin/test") + "/anakia";
        compareDir = System.getProperty(TEST_DIR_KEY, "test") + "/anakia/compare";
    }

    /**
     * Runs the test. This is empty on purpose because the
     * code to do the Anakia output is in the .xml file that runs
     * this test.
     */
    public void testAnakiaResults ()
            throws Exception
    {
        TestUtil.assureResultsDirectoryExists(resultsDir);

        // compare standard run
        if (!TestUtil.compareFiles(
                new File(compareDir, "index.html").toString(),
                new File(resultsDir, "index.html").toString()))
        {
        fail("Anakia results are incorrect");
        }
        else
        {
            Log.log ("Passed (standard)!");
        }
    }

    /**
     * Runs the test. This is empty on purpose because the
     * code to do the Anakia output is in the .xml file that runs
     * this test.
     */
    public void testAnakiaCustomContextResults ()
            throws Exception
    {
        TestUtil.assureResultsDirectoryExists(resultsDir);

        // compare with custom context
        if (!TestUtil.compareFiles(
                new File(compareDir, "index.context.html").toString(),
                new File(resultsDir, "index.context.html").toString()))
        {
        fail("Anakia results are incorrect");
        }
        else
        {
            Log.log ("Passed (custom context)!");
        }
    }


}
