/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.util.Misc;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class MultipartContent {
    private final List<MultipartPart> entries = new LinkedList<MultipartPart>();
    private final String boundary = Misc.randomString(16);

    public static MultipartContent multipart(@DelegatesTo(value=MultipartContent.class) Closure closure) {
        MultipartContent content = new MultipartContent();
        closure.setDelegate((Object)content);
        closure.call();
        return content;
    }

    public static MultipartContent multipart(Consumer<MultipartContent> config) {
        MultipartContent content = new MultipartContent();
        config.accept(content);
        return content;
    }

    public MultipartContent field(String fieldName, String value) {
        return this.part(fieldName, value);
    }

    public MultipartContent field(String fieldName, String contentType, String value) {
        return this.part(fieldName, contentType, value);
    }

    public MultipartContent part(String fieldName, String value) {
        return this.part(fieldName, null, ContentTypes.TEXT.getAt(0), value);
    }

    public MultipartContent part(String fieldName, String contentType, String value) {
        return this.part(fieldName, null, contentType, value);
    }

    public MultipartContent part(String fieldName, String fileName, String contentType, Object content) {
        this.entries.add(new MultipartPart(fieldName, fileName, contentType, content));
        return this;
    }

    Iterable<MultipartPart> parts() {
        return Collections.unmodifiableList(this.entries);
    }

    String boundary() {
        return this.boundary;
    }

    static class MultipartPart {
        private final String fieldName;
        private final String fileName;
        private final String contentType;
        private final Object content;

        private MultipartPart(String fieldName, String fileName, String contentType, Object content) {
            this.fieldName = fieldName;
            this.fileName = fileName;
            this.contentType = contentType != null ? contentType : ContentTypes.TEXT.getAt(0);
            this.content = content;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Object getContent() {
            return this.content;
        }
    }
}

