/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.core.TaeError;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.action.LowerLeftAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.LowerRightAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.WideLeftAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.WideRightAnnotationSideAction;
import org.apache.uima.caseditor.editor.fsview.TypeCombo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class FindAnnotateDialog
extends Dialog {
    private static final int FIND_BUTTON = 100;
    private static final int ANNOTATE_FIND_BUTTON = 101;
    private static final int ANNOTATE_BUTTON = 102;
    private static final int ANNOTATE_ALL_BUTTON = 103;
    private static int CLOSE_BUTTON = 104;
    private final IFindReplaceTarget findReplaceTarget;
    private final ICasDocument document;
    private final Type modeType;
    private Combo findField;
    private TypeCombo typeField;
    private Button wideLeftSideButton;
    private Button lowerLeftSideButton;
    private Button lowerRightSideButton;
    private Button wideRightSideButton;
    private Button forwardRadioButton;
    private AnnotationFS currentAnnotation;

    FindAnnotateDialog(Shell parentShell, ICasDocument document, IFindReplaceTarget findReplaceTarget, Type modeType) {
        super(parentShell);
        this.document = document;
        this.findReplaceTarget = findReplaceTarget;
        this.modeType = modeType;
    }

    public void create() {
        super.create();
        this.getShell().setText("Find/Annotate");
        this.findField.setText(this.findReplaceTarget.getSelectionText());
    }

    private Composite createInputPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText("Find:");
        GridData labelData = new GridData();
        labelData.horizontalAlignment = 16384;
        findLabel.setLayoutData((Object)labelData);
        this.findField = new Combo(panel, 2052);
        GridData findFieldData = new GridData();
        findFieldData.horizontalAlignment = 4;
        findFieldData.grabExcessHorizontalSpace = true;
        this.findField.setLayoutData((Object)findFieldData);
        Label typeLabel = new Label(panel, 16384);
        typeLabel.setText("Type:");
        GridData typeData = new GridData();
        typeData.horizontalAlignment = 16384;
        typeLabel.setLayoutData((Object)typeData);
        this.typeField = new TypeCombo(panel);
        this.typeField.setInput(this.document.getCAS().getTypeSystem().getType("uima.tcas.Annotation"), this.document.getCAS().getTypeSystem());
        this.typeField.select(this.modeType);
        GridData typeFieldData = new GridData();
        typeFieldData.horizontalAlignment = 4;
        typeFieldData.grabExcessHorizontalSpace = true;
        this.typeField.setLayoutData(typeFieldData);
        return panel;
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText("Direction");
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.forwardRadioButton = new Button((Composite)group, 16400);
        this.forwardRadioButton.setText("Forward");
        this.forwardRadioButton.setSelection(true);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText("Backward");
        return panel;
    }

    private void createAnnotationButtons(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText("Annotation");
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.wideLeftSideButton = new Button((Composite)group, 16392);
        this.wideLeftSideButton.setImage(CasEditorPlugin.getTaeImageDescriptor(Images.WIDE_LEFT_SIDE).createImage());
        this.wideLeftSideButton.setEnabled(false);
        this.wideLeftSideButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WideLeftAnnotationSideAction.wideLeftAnnotationSide(FindAnnotateDialog.this.document, FindAnnotateDialog.this.currentAnnotation);
            }
        });
        this.lowerLeftSideButton = new Button((Composite)group, 16392);
        this.lowerLeftSideButton.setImage(CasEditorPlugin.getTaeImageDescriptor(Images.LOWER_LEFT_SIDE).createImage());
        this.lowerLeftSideButton.setEnabled(false);
        this.lowerLeftSideButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LowerLeftAnnotationSideAction.lowerLeftAnnotationSide(FindAnnotateDialog.this.document, FindAnnotateDialog.this.currentAnnotation);
            }
        });
        this.lowerRightSideButton = new Button((Composite)group, 16392);
        this.lowerRightSideButton.setImage(CasEditorPlugin.getTaeImageDescriptor(Images.LOWER_RIGHT_SIDE).createImage());
        this.lowerRightSideButton.setEnabled(false);
        this.lowerRightSideButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LowerRightAnnotationSideAction.lowerRightAnnotationSide(FindAnnotateDialog.this.document, FindAnnotateDialog.this.currentAnnotation);
            }
        });
        this.wideRightSideButton = new Button((Composite)group, 16392);
        this.wideRightSideButton.setImage(CasEditorPlugin.getTaeImageDescriptor(Images.WIDE_RIGHT_SIDE).createImage());
        this.wideRightSideButton.setEnabled(false);
        this.wideRightSideButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WideRightAnnotationSideAction.wideRightAnnotationSide(FindAnnotateDialog.this.document, FindAnnotateDialog.this.currentAnnotation);
            }
        });
    }

    private void updateAnnotationButtons() {
        boolean areButtonsEnabled = this.currentAnnotation != null;
        this.wideLeftSideButton.setEnabled(areButtonsEnabled);
        this.lowerLeftSideButton.setEnabled(areButtonsEnabled);
        this.lowerRightSideButton.setEnabled(areButtonsEnabled);
        this.wideRightSideButton.setEnabled(areButtonsEnabled);
    }

    private Composite createButtonSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = -1;
        panel.setLayout((Layout)layout);
        this.createButton(panel, 100, "Fi&nd", true);
        this.createButton(panel, 101, "Annotate/Fin&d", false);
        this.createButton(panel, 102, "&Annotate", false);
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Label statusLabel = new Label(panel, 16384);
        GridData statusData = new GridData();
        statusData.horizontalAlignment = 4;
        statusData.grabExcessHorizontalSpace = true;
        statusLabel.setLayoutData((Object)statusData);
        Button closeButton = this.createButton(panel, CLOSE_BUTTON, "Close", false);
        GridData closeData = new GridData();
        closeData.horizontalAlignment = 131072;
        closeButton.setLayoutData((Object)closeData);
        return panel;
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite inputPanel = this.createInputPanel(panel);
        GridData inputPanelData = new GridData();
        inputPanelData.horizontalAlignment = 4;
        inputPanelData.grabExcessHorizontalSpace = true;
        inputPanelData.verticalAlignment = 128;
        inputPanelData.grabExcessVerticalSpace = false;
        inputPanel.setLayoutData((Object)inputPanelData);
        this.createDirectionGroup(panel);
        this.createAnnotationButtons(panel);
        Composite buttonFindAnnotatePanel = this.createButtonSection(panel);
        GridData buttonFindAnnotatePanelData = new GridData();
        buttonFindAnnotatePanelData.horizontalAlignment = 131072;
        buttonFindAnnotatePanelData.grabExcessHorizontalSpace = true;
        buttonFindAnnotatePanel.setLayoutData((Object)buttonFindAnnotatePanelData);
        Composite statusAndClosePanel = this.createStatusAndCloseButton(panel);
        GridData statusAndClosePanelData = new GridData();
        statusAndClosePanelData.horizontalAlignment = 4;
        statusAndClosePanelData.grabExcessVerticalSpace = true;
        statusAndClosePanel.setLayoutData((Object)statusAndClosePanelData);
        FindAnnotateDialog.applyDialogFont((Control)panel);
        return panel;
    }

    private void findAndSelectNext() {
        boolean isForwardSearch = this.forwardRadioButton.getSelection();
        int textOffset = -1;
        textOffset = isForwardSearch ? this.findReplaceTarget.getSelection().x + this.findReplaceTarget.getSelection().y : this.findReplaceTarget.getSelection().x - 1;
        int result = this.findReplaceTarget.findAndSelect(textOffset, this.findField.getText(), isForwardSearch, false, false);
        if (result == -1) {
            this.findReplaceTarget.findAndSelect(-1, this.findField.getText(), isForwardSearch, false, false);
        }
    }

    private AnnotationFS annotateSelection() {
        Point selection = this.findReplaceTarget.getSelection();
        AnnotationFS newAnnotation = this.document.getCAS().createAnnotation(this.typeField.getType(), selection.x, selection.x + selection.y);
        this.document.getCAS().addFsToIndexes((FeatureStructure)newAnnotation);
        this.document.addFeatureStructure((FeatureStructure)newAnnotation);
        return newAnnotation;
    }

    protected void buttonPressed(int buttonID) {
        if (100 == buttonID) {
            this.findAndSelectNext();
            this.currentAnnotation = null;
        } else if (102 == buttonID) {
            this.currentAnnotation = this.annotateSelection();
        } else if (101 == buttonID) {
            this.annotateSelection();
            this.findAndSelectNext();
        } else if (103 != buttonID) {
            if (CLOSE_BUTTON == buttonID) {
                this.close();
                return;
            }
            throw new TaeError("Unkown button!");
        }
        this.updateAnnotationButtons();
    }
}

