/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.auth;

import org.apache.openejb.server.auth.ExactIPAddressPermission;
import org.apache.openejb.server.auth.ExactIPv6AddressPermission;
import org.apache.openejb.server.auth.FactorizedIPAddressPermission;
import org.apache.openejb.server.auth.IPAddressPermission;
import org.apache.openejb.server.auth.NetmaskIPAddressPermission;
import org.apache.openejb.server.auth.NetmaskIPv6AddressPermission;
import org.apache.openejb.server.auth.StartWithIPAddressPermission;

public class IPAddressPermissionFactory {
    public static IPAddressPermission getIPAddressMask(String mask) {
        if (StartWithIPAddressPermission.canSupport(mask)) {
            return new StartWithIPAddressPermission(mask);
        }
        if (ExactIPAddressPermission.canSupport(mask)) {
            return new ExactIPAddressPermission(mask);
        }
        if (FactorizedIPAddressPermission.canSupport(mask)) {
            return new FactorizedIPAddressPermission(mask);
        }
        if (NetmaskIPAddressPermission.canSupport(mask)) {
            return new NetmaskIPAddressPermission(mask);
        }
        if (ExactIPv6AddressPermission.canSupport(mask)) {
            return new ExactIPv6AddressPermission(mask);
        }
        if (NetmaskIPv6AddressPermission.canSupport(mask)) {
            return new NetmaskIPv6AddressPermission(mask);
        }
        throw new IllegalArgumentException("Mask " + mask + " is not supported.");
    }
}

