/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.DataPartitioner;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableCell;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.MapReduceTool;

public class DataPartitionerRemoteMapper
implements Mapper<Writable, Writable, Writable, Writable> {
    private DataPartitionerMapper _mapper = null;

    public void map(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this._mapper.processKeyValue(key, value, out, reporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(JobConf job) {
        MatrixCharacteristics mc = MRJobConfiguration.getPartitionedMatrixSize(job);
        InputInfo ii = MRJobConfiguration.getPartitioningInputInfo(job);
        OutputInfo oi = MRJobConfiguration.getPartitioningOutputInfo(job);
        ParForProgramBlock.PDataPartitionFormat pdf = MRJobConfiguration.getPartitioningFormat(job);
        int n = MRJobConfiguration.getPartitioningSizeN(job);
        boolean keepIndexes = MRJobConfiguration.getPartitioningIndexFlag(job);
        if (ii == InputInfo.TextCellInputInfo) {
            this._mapper = new DataPartitionerMapperTextcell(mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), pdf, n);
            return;
        } else if (ii == InputInfo.BinaryCellInputInfo) {
            this._mapper = new DataPartitionerMapperBinarycell(mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), pdf, n);
            return;
        } else {
            if (ii != InputInfo.BinaryBlockInputInfo) throw new RuntimeException("Unable to configure mapper with unknown input info: " + ii.toString());
            if (oi == OutputInfo.BinaryBlockOutputInfo) {
                this._mapper = new DataPartitionerMapperBinaryblock(mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), pdf, n, keepIndexes);
                return;
            } else {
                if (oi != OutputInfo.BinaryCellOutputInfo) throw new RuntimeException("Partitioning from '" + ii + "' to '" + oi + "' not supported");
                boolean outputEmpty = MRJobConfiguration.getProgramBlocks(job) != null;
                this._mapper = new DataPartitionerMapperBinaryblock2Binarycell(job, mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), pdf, n, keepIndexes, outputEmpty);
            }
        }
    }

    public void close() throws IOException {
        this._mapper.close();
    }

    private class DataPartitionerMapperBinaryblock2Binarycell
    extends DataPartitionerMapper {
        private JobConf _cachedJobConf;
        private boolean _outputEmpty;
        private boolean _keepIndexes;
        private OutputCollector<Writable, Writable> _out;

        protected DataPartitionerMapperBinaryblock2Binarycell(JobConf job, long rlen, long clen, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pdf, int n, boolean keepIndexes, boolean outputEmpty) {
            super(rlen, clen, brlen, bclen, pdf, n);
            this._cachedJobConf = null;
            this._outputEmpty = false;
            this._keepIndexes = false;
            this._out = null;
            this._outputEmpty = outputEmpty;
            this._cachedJobConf = job;
            this._keepIndexes = keepIndexes;
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            this._out = out;
            try {
                LongWritable longKey = new LongWritable();
                PairWritableCell pairValue = new PairWritableCell();
                MatrixIndexes key2 = (MatrixIndexes)key;
                MatrixBlock value2 = (MatrixBlock)value;
                MatrixIndexes cellkey2 = new MatrixIndexes();
                MatrixCell cellvalue2 = new MatrixCell();
                long row_offset = (key2.getRowIndex() - 1L) * (long)this._brlen;
                long col_offset = (key2.getColumnIndex() - 1L) * (long)this._bclen;
                boolean sparse = value2.isInSparseFormat();
                long rows = value2.getNumRows();
                long cols = value2.getNumColumns();
                if (row_offset + rows < 1L || row_offset + rows > this._rlen || col_offset + cols < 1L || col_offset + cols > this._clen) {
                    throw new IOException("Matrix block [" + (row_offset + 1L) + ":" + (row_offset + rows) + "," + (col_offset + 1L) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "].");
                }
                long rowBlockIndex = -1L;
                long colBlockIndex = -1L;
                switch (this._pdf) {
                    case ROW_WISE: {
                        if (sparse) {
                            Iterator<IJV> iter = value2.getSparseBlockIterator();
                            while (iter.hasNext()) {
                                IJV lcell = iter.next();
                                longKey.set(row_offset + (long)lcell.getI() + 1L);
                                cellkey2.setIndexes(1L, col_offset + (long)lcell.getJ() + 1L);
                                cellvalue2.setValue(lcell.getV());
                                pairValue.indexes = cellkey2;
                                pairValue.cell = cellvalue2;
                                out.collect((Object)longKey, (Object)pairValue);
                            }
                        } else {
                            int i = 0;
                            while ((long)i < rows) {
                                longKey.set(row_offset + (long)i + 1L);
                                int j = 0;
                                while ((long)j < cols) {
                                    double lvalue = value2.getValueDenseUnsafe(i, j);
                                    if (lvalue != 0.0) {
                                        cellkey2.setIndexes(1L, col_offset + (long)j + 1L);
                                        cellvalue2.setValue(lvalue);
                                        pairValue.indexes = cellkey2;
                                        pairValue.cell = cellvalue2;
                                        out.collect((Object)longKey, (Object)pairValue);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        longKey.set(row_offset / (long)this._brlen + 1L);
                        if (sparse) {
                            Iterator<IJV> iter = value2.getSparseBlockIterator();
                            while (iter.hasNext()) {
                                IJV lcell = iter.next();
                                cellkey2.setIndexes(1L, col_offset + (long)lcell.getJ() + 1L);
                                cellvalue2.setValue(lcell.getV());
                                pairValue.indexes = cellkey2;
                                pairValue.cell = cellvalue2;
                                out.collect((Object)longKey, (Object)pairValue);
                            }
                        } else {
                            int i = 0;
                            while ((long)i < rows) {
                                int j = 0;
                                while ((long)j < cols) {
                                    double lvalue = value2.getValueDenseUnsafe(i, j);
                                    if (lvalue != 0.0) {
                                        cellkey2.setIndexes(1L, col_offset + (long)j + 1L);
                                        cellvalue2.setValue(lvalue);
                                        pairValue.indexes = cellkey2;
                                        pairValue.cell = cellvalue2;
                                        out.collect((Object)longKey, (Object)pairValue);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        longKey.set(row_offset / (long)this._n + 1L);
                        rowBlockIndex = this._keepIndexes ? row_offset / (long)this._brlen + 1L : row_offset % (long)this._n / (long)this._brlen + 1L;
                        if (sparse) {
                            Iterator<IJV> iter = value2.getSparseBlockIterator();
                            while (iter.hasNext()) {
                                IJV lcell = iter.next();
                                cellkey2.setIndexes(rowBlockIndex, col_offset + (long)lcell.getJ() + 1L);
                                cellvalue2.setValue(lcell.getV());
                                pairValue.indexes = cellkey2;
                                pairValue.cell = cellvalue2;
                                out.collect((Object)longKey, (Object)pairValue);
                            }
                        } else {
                            int i = 0;
                            while ((long)i < rows) {
                                int j = 0;
                                while ((long)j < cols) {
                                    double lvalue = value2.getValueDenseUnsafe(i, j);
                                    if (lvalue != 0.0) {
                                        cellkey2.setIndexes(rowBlockIndex, col_offset + (long)j + 1L);
                                        cellvalue2.setValue(lvalue);
                                        pairValue.indexes = cellkey2;
                                        pairValue.cell = cellvalue2;
                                        out.collect((Object)longKey, (Object)pairValue);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        break;
                    }
                    case COLUMN_WISE: {
                        if (sparse) {
                            Iterator<IJV> iter = value2.getSparseBlockIterator();
                            while (iter.hasNext()) {
                                IJV lcell = iter.next();
                                longKey.set(col_offset + (long)lcell.getJ() + 1L);
                                cellkey2.setIndexes(row_offset + (long)lcell.getI() + 1L, 1L);
                                cellvalue2.setValue(lcell.getV());
                                pairValue.indexes = cellkey2;
                                pairValue.cell = cellvalue2;
                                out.collect((Object)longKey, (Object)pairValue);
                            }
                        } else {
                            int j = 0;
                            while ((long)j < cols) {
                                longKey.set(col_offset + (long)j + 1L);
                                int i = 0;
                                while ((long)i < rows) {
                                    double lvalue = value2.getValueDenseUnsafe(i, j);
                                    if (lvalue != 0.0) {
                                        cellkey2.setIndexes(row_offset + (long)i + 1L, 1L);
                                        cellvalue2.setValue(lvalue);
                                        pairValue.indexes = cellkey2;
                                        pairValue.cell = cellvalue2;
                                        out.collect((Object)longKey, (Object)pairValue);
                                    }
                                    ++i;
                                }
                                ++j;
                            }
                        }
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        longKey.set(col_offset / (long)this._bclen + 1L);
                        if (sparse) {
                            Iterator<IJV> iter = value2.getSparseBlockIterator();
                            while (iter.hasNext()) {
                                IJV lcell = iter.next();
                                cellkey2.setIndexes(row_offset + (long)lcell.getI() + 1L, 1L);
                                cellvalue2.setValue(lcell.getV());
                                pairValue.indexes = cellkey2;
                                pairValue.cell = cellvalue2;
                                out.collect((Object)longKey, (Object)pairValue);
                            }
                        } else {
                            int j = 0;
                            while ((long)j < cols) {
                                int i = 0;
                                while ((long)i < rows) {
                                    double lvalue = value2.getValueDenseUnsafe(i, j);
                                    if (lvalue != 0.0) {
                                        cellkey2.setIndexes(row_offset + (long)i + 1L, 1L);
                                        cellvalue2.setValue(lvalue);
                                        pairValue.indexes = cellkey2;
                                        pairValue.cell = cellvalue2;
                                        out.collect((Object)longKey, (Object)pairValue);
                                    }
                                    ++i;
                                }
                                ++j;
                            }
                        }
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        longKey.set(col_offset / (long)this._n + 1L);
                        colBlockIndex = this._keepIndexes ? col_offset / (long)this._bclen + 1L : col_offset % (long)this._n / (long)this._bclen + 1L;
                        if (sparse) {
                            Iterator<IJV> iter = value2.getSparseBlockIterator();
                            while (iter.hasNext()) {
                                IJV lcell = iter.next();
                                cellkey2.setIndexes(row_offset + (long)lcell.getI() + 1L, colBlockIndex);
                                cellvalue2.setValue(lcell.getV());
                                pairValue.indexes = cellkey2;
                                pairValue.cell = cellvalue2;
                                out.collect((Object)longKey, (Object)pairValue);
                            }
                        } else {
                            int j = 0;
                            while ((long)j < cols) {
                                int i = 0;
                                while ((long)i < rows) {
                                    double lvalue = value2.getValueDenseUnsafe(i, j);
                                    if (lvalue != 0.0) {
                                        cellkey2.setIndexes(row_offset + (long)i + 1L, colBlockIndex);
                                        cellvalue2.setValue(lvalue);
                                        pairValue.indexes = cellkey2;
                                        pairValue.cell = cellvalue2;
                                        out.collect((Object)longKey, (Object)pairValue);
                                    }
                                    ++i;
                                }
                                ++j;
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to partition binary block matrix.", e);
            }
        }

        @Override
        protected void close() throws IOException {
            if (this._outputEmpty) {
                LongWritable longKey = new LongWritable();
                PairWritableCell pairValue = new PairWritableCell();
                pairValue.indexes = new MatrixIndexes(-1L, -1L);
                pairValue.cell = new MatrixCell(0.0);
                long mapID = Long.parseLong(MapReduceTool.getUniqueKeyPerTask(this._cachedJobConf, true));
                long numMap = this._cachedJobConf.getNumMapTasks();
                long numPartitions = -1L;
                switch (this._pdf) {
                    case ROW_WISE: {
                        numPartitions = this._rlen;
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        numPartitions = (int)Math.ceil((double)this._rlen / (double)this._brlen);
                        break;
                    }
                    case COLUMN_WISE: {
                        numPartitions = this._clen;
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        numPartitions = (int)Math.ceil((double)this._clen / (double)this._bclen);
                        break;
                    }
                }
                long len = (long)Math.ceil((double)numPartitions / (double)numMap);
                long start = mapID * len;
                long end = Math.min((mapID + 1L) * len, numPartitions);
                for (long i = start; i < end; ++i) {
                    longKey.set(i + 1L);
                    this._out.collect((Object)longKey, (Object)pairValue);
                }
            }
        }
    }

    private class DataPartitionerMapperBinaryblock
    extends DataPartitionerMapper {
        private MatrixBlock _reuseBlk;
        private LongWritable _longKey;
        private MatrixIndexes _pairKey;
        private PairWritableBlock _pair;
        private boolean _keepIndexes;

        protected DataPartitionerMapperBinaryblock(long rlen, long clen, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pdf, int n, boolean keepIndexes) {
            super(rlen, clen, brlen, bclen, pdf, n);
            this._reuseBlk = null;
            this._longKey = null;
            this._pairKey = null;
            this._pair = null;
            this._keepIndexes = false;
            this._longKey = new LongWritable();
            this._pair = new PairWritableBlock();
            this._pairKey = new MatrixIndexes();
            this._reuseBlk = DataPartitioner.createReuseMatrixBlock(pdf, brlen, bclen);
            this._pair.indexes = this._pairKey;
            this._pair.block = this._reuseBlk;
            this._keepIndexes = keepIndexes;
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            try {
                MatrixIndexes key2 = (MatrixIndexes)key;
                MatrixBlock value2 = (MatrixBlock)value;
                long row_offset = (key2.getRowIndex() - 1L) * (long)this._brlen;
                long col_offset = (key2.getColumnIndex() - 1L) * (long)this._bclen;
                boolean sparse = value2.isInSparseFormat();
                long nnz = value2.getNonZeros();
                long rows = value2.getNumRows();
                long cols = value2.getNumColumns();
                double sparsity = (double)nnz / (double)(rows * cols);
                if (row_offset + rows < 1L || row_offset + rows > this._rlen || col_offset + cols < 1L || col_offset + cols > this._clen) {
                    throw new IOException("Matrix block [" + (row_offset + 1L) + ":" + (row_offset + rows) + "," + (col_offset + 1L) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "].");
                }
                switch (this._pdf) {
                    case ROW_WISE: {
                        this._reuseBlk.reset(1, (int)cols, sparse, (int)((double)cols * sparsity));
                        int i = 0;
                        while ((long)i < rows) {
                            this._longKey.set(row_offset + 1L + (long)i);
                            this._pairKey.setIndexes(1L, col_offset / (long)this._bclen + 1L);
                            value2.slice(i, i, 0, (int)(cols - 1L), this._reuseBlk);
                            out.collect((Object)this._longKey, (Object)this._pair);
                            this._reuseBlk.reset();
                            ++i;
                        }
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        this._longKey.set(row_offset / (long)this._brlen + 1L);
                        this._pairKey.setIndexes(1L, col_offset / (long)this._bclen + 1L);
                        this._pair.block = value2;
                        out.collect((Object)this._longKey, (Object)this._pair);
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        this._longKey.set(row_offset / (long)this._n + 1L);
                        if (this._keepIndexes) {
                            this._pairKey.setIndexes(row_offset / (long)this._brlen + 1L, col_offset / (long)this._bclen + 1L);
                        } else {
                            this._pairKey.setIndexes(row_offset % (long)this._n / (long)this._brlen + 1L, col_offset / (long)this._bclen + 1L);
                        }
                        this._pair.block = value2;
                        out.collect((Object)this._longKey, (Object)this._pair);
                        break;
                    }
                    case COLUMN_WISE: {
                        this._reuseBlk.reset((int)rows, 1, false);
                        int i = 0;
                        while ((long)i < cols) {
                            this._longKey.set(col_offset + 1L + (long)i);
                            this._pairKey.setIndexes(row_offset / (long)this._brlen + 1L, 1L);
                            value2.slice(0, (int)(rows - 1L), i, i, this._reuseBlk);
                            out.collect((Object)this._longKey, (Object)this._pair);
                            this._reuseBlk.reset();
                            ++i;
                        }
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        this._longKey.set(col_offset / (long)this._bclen + 1L);
                        this._pairKey.setIndexes(row_offset / (long)this._brlen + 1L, 1L);
                        this._pair.block = value2;
                        out.collect((Object)this._longKey, (Object)this._pair);
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        this._longKey.set(col_offset / (long)this._n + 1L);
                        if (this._keepIndexes) {
                            this._pairKey.setIndexes(row_offset / (long)this._brlen + 1L, col_offset / (long)this._bclen + 1L);
                        } else {
                            this._pairKey.setIndexes(row_offset / (long)this._brlen + 1L, col_offset % (long)this._n / (long)this._bclen + 1L);
                        }
                        this._pair.block = value2;
                        out.collect((Object)this._longKey, (Object)this._pair);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Unable to partition binary block matrix.", e);
            }
        }
    }

    private class DataPartitionerMapperBinarycell
    extends DataPartitionerMapper {
        protected DataPartitionerMapperBinarycell(long rlen, long clen, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pdf, int n) {
            super(rlen, clen, brlen, bclen, pdf, n);
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            long row = -1L;
            long col = -1L;
            try {
                LongWritable longKey = new LongWritable();
                PairWritableCell pairValue = new PairWritableCell();
                MatrixIndexes key2 = (MatrixIndexes)key;
                MatrixCell value2 = (MatrixCell)value;
                row = key2.getRowIndex();
                col = key2.getColumnIndex();
                switch (this._pdf) {
                    case ROW_WISE: {
                        longKey.set(row);
                        row = 1L;
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        longKey.set((row - 1L) / (long)this._brlen + 1L);
                        row = (row - 1L) % (long)this._brlen + 1L;
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        longKey.set((row - 1L) / (long)this._n + 1L);
                        row = (row - 1L) % (long)this._n + 1L;
                        break;
                    }
                    case COLUMN_WISE: {
                        longKey.set(col);
                        col = 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        longKey.set((col - 1L) / (long)this._bclen + 1L);
                        col = (col - 1L) % (long)this._bclen + 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        longKey.set((col - 1L) / (long)this._n + 1L);
                        col = (col - 1L) % (long)this._n + 1L;
                        break;
                    }
                }
                key2.setIndexes(row, col);
                pairValue.indexes = key2;
                pairValue.cell = value2;
                out.collect((Object)longKey, (Object)pairValue);
            }
            catch (Exception e) {
                if (row < 1L || row > this._rlen || col < 1L || col > this._clen) {
                    throw new IOException("Matrix cell [" + row + "," + col + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "].");
                }
                throw new IOException("Unable to partition binary cell matrix.", e);
            }
        }
    }

    private class DataPartitionerMapperTextcell
    extends DataPartitionerMapper {
        private FastStringTokenizer _st;

        protected DataPartitionerMapperTextcell(long rlen, long clen, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pdf, int n) {
            super(rlen, clen, brlen, bclen, pdf, n);
            this._st = null;
            this._st = new FastStringTokenizer(' ');
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            long row = -1L;
            long col = -1L;
            try {
                this._st.reset(value.toString());
                row = this._st.nextLong();
                col = this._st.nextLong();
                double lvalue = this._st.nextDouble();
                LongWritable longKey = new LongWritable();
                PairWritableCell pairValue = new PairWritableCell();
                MatrixIndexes key2 = new MatrixIndexes();
                MatrixCell value2 = new MatrixCell();
                switch (this._pdf) {
                    case ROW_WISE: {
                        longKey.set(row);
                        row = 1L;
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        longKey.set((row - 1L) / (long)this._brlen + 1L);
                        row = (row - 1L) % (long)this._brlen + 1L;
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        longKey.set((row - 1L) / (long)this._n + 1L);
                        row = (row - 1L) % (long)this._n + 1L;
                        break;
                    }
                    case COLUMN_WISE: {
                        longKey.set(col);
                        col = 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        longKey.set((col - 1L) / (long)this._bclen + 1L);
                        col = (col - 1L) % (long)this._bclen + 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        longKey.set((col - 1L) / (long)this._n + 1L);
                        col = (col - 1L) % (long)this._n + 1L;
                        break;
                    }
                }
                key2.setIndexes(row, col);
                value2.setValue(lvalue);
                pairValue.indexes = key2;
                pairValue.cell = value2;
                out.collect((Object)longKey, (Object)pairValue);
            }
            catch (Exception e) {
                if (row < 1L || row > this._rlen || col < 1L || col > this._clen) {
                    throw new IOException("Matrix cell [" + row + "," + col + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "].");
                }
                throw new IOException("Unable to partition text cell matrix.", e);
            }
        }
    }

    private abstract class DataPartitionerMapper {
        protected long _rlen = -1L;
        protected long _clen = -1L;
        protected int _brlen = -1;
        protected int _bclen = -1;
        protected ParForProgramBlock.PDataPartitionFormat _pdf = null;
        protected int _n = -1;

        protected DataPartitionerMapper(long rlen, long clen, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pdf, int n) {
            this._rlen = rlen;
            this._clen = clen;
            this._brlen = brlen;
            this._bclen = bclen;
            this._pdf = pdf;
            this._n = n;
        }

        protected abstract void processKeyValue(Writable var1, Writable var2, OutputCollector<Writable, Writable> var3, Reporter var4) throws IOException;

        protected void close() throws IOException {
        }
    }
}

