/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.beans.spring.parser.AbstractAuthenticatorBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractSearchAuthenticatorBeanDefinitionParser
extends AbstractAuthenticatorBeanDefinitionParser {
    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder dnResolver;
        BeanDefinitionBuilder connectionFactory;
        if (Boolean.valueOf(element.getAttribute("disablePooling")).booleanValue()) {
            connectionFactory = this.parseDefaultConnectionFactory(null, element, true);
            dnResolver = this.parseDnResolver(null, element, connectionFactory);
        } else {
            connectionFactory = this.parsePooledConnectionFactory(null, (String)(element.hasAttribute("id") ? element.getAttribute("id") + "-dn-resolver-pool" : "dn-resolver-pool"), element, true);
            dnResolver = this.parseDnResolver(null, element, connectionFactory);
        }
        BeanDefinitionBuilder entryResolver = null;
        if (Boolean.valueOf(element.getAttribute("resolveEntryWithBindCredentials")).booleanValue()) {
            BeanDefinitionBuilder connectionFactory2;
            if (Boolean.valueOf(element.getAttribute("disablePooling")).booleanValue()) {
                connectionFactory2 = this.parseDefaultConnectionFactory(null, element, true);
                entryResolver = this.parseEntryResolver(element, connectionFactory2);
            } else {
                connectionFactory2 = this.parsePooledConnectionFactory(null, (String)(element.hasAttribute("id") ? element.getAttribute("id") + "-entry-resolver-pool" : "entry-resolver-pool"), element, true);
                entryResolver = this.parseEntryResolver(element, connectionFactory2);
            }
        } else if (element.hasAttribute("binaryAttributes")) {
            entryResolver = this.parseEntryResolver(element, null);
        }
        BeanDefinitionBuilder authHandler = this.parseAuthHandler(element);
        BeanDefinitionBuilder authResponseHandler = this.parseAuthResponseHandler(builder, authHandler, element);
        if (authResponseHandler != null) {
            builder.addPropertyValue("responseHandlers", (Object)authResponseHandler.getBeanDefinition());
        }
        builder.addConstructorArgValue((Object)dnResolver.getBeanDefinition());
        builder.addConstructorArgValue((Object)authHandler.getBeanDefinition());
        if (entryResolver != null) {
            builder.addPropertyValue("entryResolver", (Object)entryResolver.getBeanDefinition());
        }
        this.setIfPresent(element, "returnAttributes", builder);
        this.setIfPresent(element, "resolveEntryOnFailure", builder);
    }

    protected BeanDefinitionBuilder parseDnResolver(BeanDefinitionBuilder builder, Element element, BeanDefinitionBuilder connectionFactory) {
        BeanDefinitionBuilder dnResolver = builder;
        if (dnResolver == null) {
            dnResolver = BeanDefinitionBuilder.genericBeanDefinition(SearchDnResolver.class);
        }
        dnResolver.addPropertyValue("baseDn", (Object)element.getAttribute("baseDn"));
        dnResolver.addPropertyValue("subtreeSearch", (Object)element.getAttribute("subtreeSearch"));
        dnResolver.addPropertyValue("userFilter", (Object)element.getAttribute("userFilter"));
        dnResolver.addPropertyValue("allowMultipleDns", (Object)element.getAttribute("allowMultipleDns"));
        dnResolver.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        return dnResolver;
    }
}

