/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketValidator;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.token.TokenTicketBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenTicketBuilder
implements TokenTicketBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenTicketBuilder.class);
    private final TicketValidator ticketValidator;
    private final ExpirationPolicyBuilder expirationPolicy;
    private final JwtBuilder jwtBuilder;
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;

    @Override
    public String build(String serviceTicketId, WebApplicationService webApplicationService) {
        TicketValidator.ValidationResult assertion = (TicketValidator.ValidationResult)FunctionUtils.doUnchecked(() -> this.ticketValidator.validate(serviceTicketId, webApplicationService.getId()));
        LinkedHashMap attributes = new LinkedHashMap(assertion.getAttributes());
        attributes.putAll(assertion.getPrincipal().getAttributes());
        LOGGER.trace("Assertion attributes received are [{}]", attributes);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)webApplicationService);
        Map finalAttributes = ProtocolAttributeEncoder.decodeAttributes(attributes, (RegisteredService)registeredService, (WebApplicationService)webApplicationService);
        LOGGER.debug("Final attributes decoded are [{}]", (Object)finalAttributes);
        ZonedDateTime dt = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.getTimeToLive());
        Date validUntilDate = DateTimeUtils.dateOf((ChronoZonedDateTime)dt);
        JwtBuilder.JwtRequest.JwtRequestBuilder<?, ?> builder = JwtBuilder.JwtRequest.builder();
        Object request = ((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)builder.registeredService(Optional.ofNullable(registeredService))).serviceAudience(webApplicationService.getId())).issueDate(new Date())).jwtId(serviceTicketId)).subject(assertion.getPrincipal().getId())).validUntilDate(validUntilDate)).attributes(finalAttributes)).issuer(this.casProperties.getServer().getPrefix())).build();
        LOGGER.debug("Building JWT using [{}]", request);
        return this.jwtBuilder.build((JwtBuilder.JwtRequest)request);
    }

    @Override
    public String build(TicketGrantingTicket ticketGrantingTicket, Map<String, List<Object>> claims) {
        Authentication authentication = ticketGrantingTicket.getAuthentication();
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>(authentication.getAttributes());
        attributes.putAll(authentication.getPrincipal().getAttributes());
        attributes.putAll(claims);
        ZonedDateTime dt = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.getTimeToLive());
        Date validUntilDate = DateTimeUtils.dateOf((ChronoZonedDateTime)dt);
        JwtBuilder.JwtRequest.JwtRequestBuilder<?, ?> builder = JwtBuilder.JwtRequest.builder();
        Object request = ((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)builder.serviceAudience(this.casProperties.getServer().getPrefix())).registeredService(Optional.empty())).issueDate(DateTimeUtils.dateOf((ChronoZonedDateTime)ticketGrantingTicket.getCreationTime()))).jwtId(ticketGrantingTicket.getId())).subject(authentication.getPrincipal().getId())).validUntilDate(validUntilDate)).attributes(attributes)).issuer(this.casProperties.getServer().getPrefix())).build();
        return this.jwtBuilder.build((JwtBuilder.JwtRequest)request);
    }

    protected Long getTimeToLive() {
        Long timeToLive = this.expirationPolicy.buildTicketExpirationPolicy().getTimeToLive();
        return Long.MAX_VALUE == timeToLive ? Long.valueOf(Integer.MAX_VALUE) : timeToLive;
    }

    @Generated
    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    @Generated
    public ExpirationPolicyBuilder getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public JwtBuilder getJwtBuilder() {
        return this.jwtBuilder;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public JwtTokenTicketBuilder(TicketValidator ticketValidator, ExpirationPolicyBuilder expirationPolicy, JwtBuilder jwtBuilder, ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        this.ticketValidator = ticketValidator;
        this.expirationPolicy = expirationPolicy;
        this.jwtBuilder = jwtBuilder;
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
    }
}

