/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class GenerateRandomPasswordPropagationActions
implements PropagationActions {
    protected static final Logger LOG = LoggerFactory.getLogger(GenerateRandomPasswordPropagationActions.class);
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected PasswordGenerator passwordGenerator;

    protected boolean generateRandomPassword(PropagationTaskInfo taskInfo) {
        return AnyTypeKind.USER == taskInfo.getAnyTypeKind() && taskInfo.getBeforeObj().isEmpty() && AttributeUtil.getPasswordValue((Set)taskInfo.getPropagationData().getAttributes()) == null;
    }

    @Transactional(readOnly=true)
    public void before(PropagationTaskInfo taskInfo) {
        if (this.generateRandomPassword(taskInfo)) {
            Set attrs = taskInfo.getPropagationData().getAttributes();
            attrs.add(AttributeBuilder.buildPassword((char[])this.passwordGenerator.generate(taskInfo.getResource(), this.realmDAO.findAncestors(((User)this.userDAO.find(taskInfo.getEntityKey())).getRealm())).toCharArray()));
            Optional.ofNullable(AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)attrs)).ifPresent(mandatoryMissing -> {
                attrs.remove(mandatoryMissing);
                Set newMandatoryMissing = mandatoryMissing.getValue().stream().filter(v -> !OperationalAttributes.PASSWORD_NAME.equals(v)).collect(Collectors.toSet());
                if (!newMandatoryMissing.isEmpty()) {
                    attrs.add(AttributeBuilder.build((String)"__MANDATORY_MISSING__", newMandatoryMissing));
                }
            });
        }
    }
}

