
package com.google.javascript.jscomp.colors;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ObjectColor extends ObjectColor {

  private final String className;
  private final String filename;
  private final Color prototype;
  private final Color instanceColor;
  private final ImmutableList<Color> disambiguationSupertypes;
  private final boolean invalidating;

  private AutoValue_ObjectColor(
      String className,
      String filename,
      @Nullable Color prototype,
      @Nullable Color instanceColor,
      ImmutableList<Color> disambiguationSupertypes,
      boolean invalidating) {
    this.className = className;
    this.filename = filename;
    this.prototype = prototype;
    this.instanceColor = instanceColor;
    this.disambiguationSupertypes = disambiguationSupertypes;
    this.invalidating = invalidating;
  }

  @Override
  public String getClassName() {
    return className;
  }

  @Override
  public String getFilename() {
    return filename;
  }

  @Nullable
  @Override
  public Color getPrototype() {
    return prototype;
  }

  @Nullable
  @Override
  public Color getInstanceColor() {
    return instanceColor;
  }

  @Override
  public ImmutableList<Color> getDisambiguationSupertypes() {
    return disambiguationSupertypes;
  }

  @Override
  public boolean isInvalidating() {
    return invalidating;
  }

  @Override
  public String toString() {
    return "ObjectColor{"
        + "className=" + className + ", "
        + "filename=" + filename + ", "
        + "prototype=" + prototype + ", "
        + "instanceColor=" + instanceColor + ", "
        + "disambiguationSupertypes=" + disambiguationSupertypes + ", "
        + "invalidating=" + invalidating
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ObjectColor) {
      ObjectColor that = (ObjectColor) o;
      return (this.className.equals(that.getClassName()))
           && (this.filename.equals(that.getFilename()))
           && ((this.prototype == null) ? (that.getPrototype() == null) : this.prototype.equals(that.getPrototype()))
           && ((this.instanceColor == null) ? (that.getInstanceColor() == null) : this.instanceColor.equals(that.getInstanceColor()))
           && (this.disambiguationSupertypes.equals(that.getDisambiguationSupertypes()))
           && (this.invalidating == that.isInvalidating());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.className.hashCode();
    h *= 1000003;
    h ^= this.filename.hashCode();
    h *= 1000003;
    h ^= (prototype == null) ? 0 : this.prototype.hashCode();
    h *= 1000003;
    h ^= (instanceColor == null) ? 0 : this.instanceColor.hashCode();
    h *= 1000003;
    h ^= this.disambiguationSupertypes.hashCode();
    h *= 1000003;
    h ^= this.invalidating ? 1231 : 1237;
    return h;
  }

  static final class Builder extends ObjectColor.Builder {
    private String className;
    private String filename;
    private Color prototype;
    private Color instanceColor;
    private ImmutableList<Color> disambiguationSupertypes;
    private Boolean invalidating;
    Builder() {
    }
    @Override
    public ObjectColor.Builder setClassName(String className) {
      if (className == null) {
        throw new NullPointerException("Null className");
      }
      this.className = className;
      return this;
    }
    @Override
    public ObjectColor.Builder setFilename(String filename) {
      if (filename == null) {
        throw new NullPointerException("Null filename");
      }
      this.filename = filename;
      return this;
    }
    @Override
    public ObjectColor.Builder setPrototype(@Nullable Color prototype) {
      this.prototype = prototype;
      return this;
    }
    @Override
    public ObjectColor.Builder setInstanceColor(@Nullable Color instanceColor) {
      this.instanceColor = instanceColor;
      return this;
    }
    @Override
    public ObjectColor.Builder setDisambiguationSupertypes(ImmutableList<Color> disambiguationSupertypes) {
      if (disambiguationSupertypes == null) {
        throw new NullPointerException("Null disambiguationSupertypes");
      }
      this.disambiguationSupertypes = disambiguationSupertypes;
      return this;
    }
    @Override
    public ObjectColor.Builder setInvalidating(boolean invalidating) {
      this.invalidating = invalidating;
      return this;
    }
    @Override
    public ObjectColor build() {
      String missing = "";
      if (this.className == null) {
        missing += " className";
      }
      if (this.filename == null) {
        missing += " filename";
      }
      if (this.disambiguationSupertypes == null) {
        missing += " disambiguationSupertypes";
      }
      if (this.invalidating == null) {
        missing += " invalidating";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ObjectColor(
          this.className,
          this.filename,
          this.prototype,
          this.instanceColor,
          this.disambiguationSupertypes,
          this.invalidating);
    }
  }

}
