/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationClientRetryAction
extends BaseCasWebflowAction {
    private final Clients clients;
    private final DelegatedClientIdentityProviderConfigurationProducer providerConfigurationProducer;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String clientName = WebUtils.getDelegatedAuthenticationClientName((RequestContext)requestContext);
        IndirectClient client = this.clients.findClient(clientName).map(IndirectClient.class::cast).get();
        DelegatedClientIdentityProviderConfiguration config = (DelegatedClientIdentityProviderConfiguration)this.providerConfigurationProducer.produce(requestContext, client).get();
        URIBuilder urlBuilder = new URIBuilder(config.getRedirectUrl());
        urlBuilder.addParameter("ForceAuthn", Boolean.TRUE.toString());
        response.sendRedirect(urlBuilder.toString());
        return null;
    }

    @Generated
    public DelegatedAuthenticationClientRetryAction(Clients clients, DelegatedClientIdentityProviderConfigurationProducer providerConfigurationProducer) {
        this.clients = clients;
        this.providerConfigurationProducer = providerConfigurationProducer;
    }
}

