/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.test.MockFlowSession;

public class MockFlowExecutionContext
implements FlowExecutionContext {
    private boolean started;
    private FlowExecutionKey key;
    private FlowDefinition flow;
    private FlowSession activeSession;
    private MutableAttributeMap<Object> flashScope = new LocalAttributeMap<Object>();
    private MutableAttributeMap<Object> conversationScope = new LocalAttributeMap<Object>();
    private MutableAttributeMap<Object> attributes = new LocalAttributeMap<Object>();
    private FlowExecutionOutcome outcome;

    public MockFlowExecutionContext() {
        this.setActiveSession(new MockFlowSession());
        this.flow = this.activeSession.getDefinition();
    }

    public MockFlowExecutionContext(Flow flow) {
        this(new MockFlowSession(flow));
    }

    public MockFlowExecutionContext(FlowSession flowSession) {
        this.setActiveSession(flowSession);
        this.flow = flowSession.getDefinition();
    }

    @Override
    public FlowExecutionKey getKey() {
        return this.key;
    }

    public String getCaption() {
        return this.flow.getCaption();
    }

    @Override
    public FlowDefinition getDefinition() {
        return this.flow;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    @Override
    public boolean isActive() {
        return this.activeSession != null;
    }

    @Override
    public boolean hasEnded() {
        return this.hasStarted() && !this.isActive();
    }

    @Override
    public FlowSession getActiveSession() throws IllegalStateException {
        if (this.activeSession == null) {
            throw new IllegalStateException("No flow session is active");
        }
        return this.activeSession;
    }

    @Override
    public MutableAttributeMap<Object> getFlashScope() {
        return this.flashScope;
    }

    @Override
    public MutableAttributeMap<Object> getConversationScope() {
        return this.conversationScope;
    }

    @Override
    public AttributeMap<Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public FlowExecutionOutcome getOutcome() {
        return this.outcome;
    }

    public Flow getDefinitionInternal() {
        return (Flow)this.getDefinition();
    }

    public void setFlow(FlowDefinition rootFlow) {
        this.flow = rootFlow;
    }

    public void setKey(FlowExecutionKey key) {
        this.key = key;
    }

    public void setActiveSession(FlowSession activeSession) {
        this.activeSession = activeSession;
        if (!this.started && activeSession != null) {
            this.started = true;
        }
    }

    public void setFlashScope(MutableAttributeMap<Object> scope) {
        this.flashScope = scope;
    }

    public void setConversationScope(MutableAttributeMap<Object> scope) {
        this.conversationScope = scope;
    }

    public void setOutcome(FlowExecutionOutcome outcome) {
        this.outcome = outcome;
    }

    public MockFlowSession getMockActiveSession() {
        return (MockFlowSession)this.activeSession;
    }

    public MutableAttributeMap<Object> getAttributeMap() {
        return this.attributes;
    }

    public void putAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }
}

