/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthRefreshTokenProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuth20RefreshTokenExpirationPolicyBuilder
implements ExpirationPolicyBuilder<OAuth20RefreshToken> {
    private static final long serialVersionUID = -3597980180617072826L;
    protected final CasConfigurationProperties casProperties;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OAuthRefreshTokenProperties rtProps = this.casProperties.getAuthn().getOauth().getRefreshToken();
        long timeout = Beans.newDuration((String)rtProps.getTimeToKillInSeconds()).getSeconds();
        if (this.casProperties.getLogout().isRemoveDescendantTickets()) {
            return new OAuth20RefreshTokenExpirationPolicy(timeout);
        }
        return new OAuth20RefreshTokenExpirationPolicy.OAuthRefreshTokenStandaloneExpirationPolicy(timeout);
    }

    @Generated
    public OAuth20RefreshTokenExpirationPolicyBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "OAuth20RefreshTokenExpirationPolicyBuilder(casProperties=" + this.casProperties + ")";
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

