/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.token.cipher.RegisteredServiceJwtTicketCipherExecutor;

public class OAuth20RegisteredServiceJwtAccessTokenCipherExecutor
extends RegisteredServiceJwtTicketCipherExecutor {
    protected RegisteredServiceProperty.RegisteredServiceProperties getSigningKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getEncryptionKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherStrategyTypeRegisteredServiceProperty(RegisteredService registeredService) {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_CIPHER_STRATEGY_TYPE;
    }

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        if (this.isSigningEnabledForRegisteredService(registeredService)) {
            return super.getSigningKey(registeredService);
        }
        return Optional.empty();
    }

    protected boolean isSigningEnabledForRegisteredService(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties prop = RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED;
        if (prop.isAssignedTo(registeredService)) {
            return prop.getPropertyBooleanValue(registeredService);
        }
        return BooleanUtils.toBoolean((String)prop.getDefaultValue());
    }

    protected boolean isEncryptionEnabledForRegisteredService(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties prop = RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED;
        if (prop.isAssignedTo(registeredService)) {
            return prop.getPropertyBooleanValue(registeredService);
        }
        return BooleanUtils.toBoolean((String)prop.getDefaultValue());
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        if (this.isEncryptionEnabledForRegisteredService(registeredService)) {
            return super.getEncryptionKey(registeredService);
        }
        return Optional.empty();
    }
}

