/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuth20AuthorizationRequestValidator
implements OAuth20AuthorizationRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20AuthorizationRequestValidator.class);
    protected final ServicesManager servicesManager;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;
    protected final OAuth20RequestParameterResolver requestParameterResolver;

    protected boolean preValidate(WebContext context) throws Exception {
        String clientId = this.getClientIdFromRequest(context);
        OAuthRegisteredService registeredService = this.verifyRegisteredServiceByClientId(context, clientId);
        if (registeredService == null) {
            return false;
        }
        String redirectUri = this.getRedirectUriFromRequest(context);
        if (!this.verifyRedirectUriForRegisteredService(context, registeredService, redirectUri)) {
            return false;
        }
        String responseType = this.getResponseTypeFromRequest(context);
        return this.verifyResponseType(context, responseType);
    }

    protected String getResponseTypeFromRequest(WebContext context) {
        return this.requestParameterResolver.resolveRequestParameter(context, "response_type").orElse("");
    }

    protected String getRedirectUriFromRequest(WebContext context) {
        return this.requestParameterResolver.resolveRequestParameter(context, "redirect_uri").orElse("");
    }

    protected String getClientIdFromRequest(WebContext context) {
        return this.requestParameterResolver.resolveRequestParameter(context, "client_id").orElse("");
    }

    protected OAuthRegisteredService verifyRegisteredServiceByClientId(WebContext context, String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            LOGGER.warn("Missing required parameter [{}]", (Object)"client_id");
            this.setErrorDetails(context, "invalid_request", String.format("Missing required parameter: [%s]", "client_id"), false);
            return null;
        }
        LOGGER.debug("Locating registered service for client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        if (accessResult.isExecutionFailure()) {
            LOGGER.warn("Registered service [{}] is not found or is not authorized for access.", ObjectUtils.defaultIfNull((Object)registeredService, (Object)clientId));
            this.setErrorDetails(context, "invalid_request", "", false);
            return null;
        }
        return registeredService;
    }

    protected void setErrorDetails(WebContext context, String error, String errorDescription, boolean errorWithCallBack) {
        context.setRequestAttribute("error", (Object)error);
        context.setRequestAttribute("error_description", (Object)errorDescription);
        context.setRequestAttribute("error_with_callback", (Object)errorWithCallBack);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
    }

    protected boolean verifyRedirectUriForRegisteredService(WebContext context, OAuthRegisteredService registeredService, String redirectUri) {
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            LOGGER.warn("Missing required parameter [{}]", (Object)"redirect_uri");
            this.setErrorDetails(context, "invalid_request", String.format("Missing required parameter: [%s]", "redirect_uri"), false);
            return false;
        }
        if (!OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, redirectUri)) {
            LOGGER.warn("Callback URL [{}] is not authorized for registered service [{}].", (Object)redirectUri, (Object)registeredService.getServiceId());
            this.setErrorDetails(context, "invalid_request", "", false);
            return false;
        }
        return true;
    }

    private boolean verifyResponseType(WebContext context, String responseType) {
        if (StringUtils.isBlank((CharSequence)responseType)) {
            this.setErrorDetails(context, "unsupported_response_type", String.format("Missing required parameter: [%s]", "response_type"), true);
            return false;
        }
        if (!OAuth20Utils.checkResponseTypes(responseType, OAuth20ResponseTypes.values())) {
            LOGGER.warn("Response type [{}] is not found in the list of supported values [{}].", (Object)responseType, (Object)OAuth20ResponseTypes.values());
            this.setErrorDetails(context, "unsupported_response_type", String.format("Unsupported response_type: [%s]", responseType), true);
            return false;
        }
        return true;
    }

    @Generated
    protected BaseOAuth20AuthorizationRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, OAuth20RequestParameterResolver requestParameterResolver) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.requestParameterResolver = requestParameterResolver;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }
}

