/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.splitter;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.splitter.ISplitterListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.util.lang.Args;

public class SplitterBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoSplitter";
    private final ISplitterListener listener;
    private JQueryAjaxBehavior onExpandAjaxBehavior = null;
    private JQueryAjaxBehavior onCollapseAjaxBehavior = null;

    public SplitterBehavior(String selector, ISplitterListener listener) {
        this(selector, new Options(), listener);
    }

    public SplitterBehavior(String selector, Options options, ISplitterListener listener) {
        super(selector, METHOD, options);
        this.listener = (ISplitterListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isExpandEventEnabled()) {
            this.onExpandAjaxBehavior = this.newOnExpandAjaxBehavior(this);
            component.add(new Behavior[]{this.onExpandAjaxBehavior});
        }
        if (this.listener.isCollapseEventEnabled()) {
            this.onCollapseAjaxBehavior = this.newOnCollapseAjaxBehavior(this);
            component.add(new Behavior[]{this.onCollapseAjaxBehavior});
        }
    }

    public void expand(IPartialPageRequestHandler handler, String pane) {
        handler.appendJavaScript((CharSequence)String.format("$('%s').data('%s').expand('%s');", this.selector, METHOD, pane));
    }

    public void collapse(IPartialPageRequestHandler handler, String pane) {
        handler.appendJavaScript((CharSequence)String.format("$('%s').data('%s').collapse('%s');", this.selector, METHOD, pane));
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onExpandAjaxBehavior != null) {
            this.setOption("expand", this.onExpandAjaxBehavior.getCallbackFunction());
        }
        if (this.onCollapseAjaxBehavior != null) {
            this.setOption("collapse", this.onCollapseAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ExpandEvent) {
            this.listener.onExpand(target, ((ExpandEvent)event).getPaneId());
        }
        if (event instanceof CollapseEvent) {
            this.listener.onCollapse(target, ((CollapseEvent)event).getPaneId());
        }
    }

    protected JQueryAjaxBehavior newOnExpandAjaxBehavior(IJQueryAjaxAware source) {
        return new OnExpandAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnCollapseAjaxBehavior(IJQueryAjaxAware source) {
        return new OnCollapseAjaxBehavior(source);
    }

    protected static class CollapseEvent
    extends JQueryEvent {
        private final String paneId = RequestCycleUtils.getQueryParameterValue((String)"id").toString("");

        public String getPaneId() {
            return this.paneId;
        }
    }

    protected static class ExpandEvent
    extends JQueryEvent {
        private final String paneId = RequestCycleUtils.getQueryParameterValue((String)"id").toString("");

        public String getPaneId() {
            return this.paneId;
        }
    }

    protected static class OnCollapseAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnCollapseAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"id", (String)"e.pane.id")};
        }

        protected JQueryEvent newEvent() {
            return new CollapseEvent();
        }
    }

    protected static class OnExpandAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnExpandAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"id", (String)"e.pane.id")};
        }

        protected JQueryEvent newEvent() {
            return new ExpandEvent();
        }
    }
}

