/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.exceptions;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.exceptions.ExceptionSettingsProperties;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.ExceptionSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.settings.exceptions", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ExceptionSettingsProperties.class})
public class ExceptionSettingsConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private ExceptionSettingsProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        ExceptionSettings exceptionSettings = webApplication.getExceptionSettings();
        exceptionSettings.setAjaxErrorHandlingStrategy(this.props.getErrorHandlingStrategyDuringAjaxRequests());
        exceptionSettings.setThreadDumpStrategy(this.props.getThreadDumpStrategy());
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

