/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.serializer.deflated;

import com.giffing.wicket.spring.boot.context.exceptions.extensions.ExtensionMisconfigurationException;
import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.serializer.deflated.DeflatedJavaSerializerProperties;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.DeflatedJavaSerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.serializer.deflated", value={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={DeflatedJavaSerializerProperties.class})
public class DeflatedJavaSerializerConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DeflatedJavaSerializerProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        ISerializer currentSerializer = webApplication.getFrameworkSettings().getSerializer();
        if (!(currentSerializer instanceof JavaSerializer)) {
            throw new ExtensionMisconfigurationException("DeflatedJavaSerializer: There is already another serializer configured " + currentSerializer);
        }
        webApplication.getFrameworkSettings().setSerializer((ISerializer)new DeflatedJavaSerializer(webApplication.getApplicationKey()));
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

