/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.draggable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.interaction.draggable.DraggableBehavior;
import com.googlecode.wicket.jquery.ui.interaction.draggable.IDraggableListener;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;

public class Draggable<T>
extends JQueryGenericContainer<T>
implements IDraggableListener {
    private static final long serialVersionUID = 1L;
    private Options options = new Options();

    public Draggable(String id) {
        super(id);
    }

    public Draggable(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    public boolean isStopEventEnabled() {
        return false;
    }

    @Override
    public void onDragStart(AjaxRequestTarget target, int top, int left) {
    }

    @Override
    public void onDragStop(AjaxRequestTarget target, int top, int left) {
    }

    public Draggable<T> setAxis(Axis axis) {
        this.options.set("axis", (Object)Options.asString((Object)((Object)axis)));
        return this;
    }

    public Draggable<T> setGrid(List<Integer> grid) {
        if (grid.size() == 2) {
            this.options.set("grid", (Object)grid.toString());
        }
        return this;
    }

    public Draggable<T> setContainment(Containment containment) {
        return this.setContainment(containment.toString());
    }

    public Draggable<T> setContainment(Component component) {
        return this.setContainment(IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    public Draggable<T> setContainment(String selector) {
        this.options.set("containment", (Object)Options.asString((String)selector));
        return this;
    }

    public Draggable<T> setRevert(Boolean revert) {
        this.options.set("revert", (Object)revert);
        return this;
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DraggableBehavior(selector, this.options, this);
    }

    public static enum Containment {
        Parent("parent"),
        Document("document"),
        Window("window");

        private String containment;

        private Containment(String containment) {
            this.containment = containment;
        }

        public String toString() {
            return this.containment;
        }
    }

    public static enum Axis {
        X("x"),
        Y("y");

        private String axis;

        private Axis(String axis) {
            this.axis = axis;
        }

        public String toString() {
            return this.axis;
        }
    }
}

