/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.menu;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.widget.menu.IMenuItem;
import com.googlecode.wicket.jquery.ui.widget.menu.IMenuListener;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public abstract class MenuBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "menu";
    private final IMenuListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior;

    public MenuBehavior(String selector, IMenuListener listener) {
        this(selector, new Options(), listener);
    }

    public MenuBehavior(String selector, Options options, IMenuListener listener) {
        super(selector, METHOD, options);
        this.listener = (IMenuListener)Args.notNull((Object)listener, (String)"listener");
    }

    protected abstract Map<String, IMenuItem> getMenuItemMap();

    public void bind(Component component) {
        super.bind(component);
        this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
        component.add(new Behavior[]{this.onSelectAjaxBehavior});
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        IMenuItem item;
        if (event instanceof SelectEvent && (item = this.getMenuItemMap().get(((SelectEvent)event).getHash())) != null) {
            item.onClick(target);
            this.listener.onClick(target, item);
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final String hash = RequestCycleUtils.getQueryParameterValue((String)"hash").toString();

        public String getHash() {
            return this.hash;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"hash", (String)"ui.item[0].id")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

