/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.JQueryIcon;
import com.googlecode.wicket.jquery.ui.form.button.AjaxIndicatingButtonBehavior;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;

public class ButtonAjaxBehavior
extends JQueryAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final DialogButton button;

    public ButtonAjaxBehavior(IJQueryAjaxAware source, DialogButton button) {
        super(source);
        this.button = button;
    }

    public DialogButton getButton() {
        return this.button;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(AjaxIndicatingButtonBehavior.newIndicatorCssHeaderItem());
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.button.isIndicating()) {
            AjaxCallListener ajaxCallListener = new AjaxCallListener();
            ajaxCallListener.onBefore((CharSequence)this.getBeforeStatement());
            ajaxCallListener.onSuccess((CharSequence)this.getFinishStatement());
            ajaxCallListener.onFailure((CharSequence)this.getFinishStatement());
            attributes.getAjaxCallListeners().add(ajaxCallListener);
        }
    }

    private String getBeforeStatement() {
        return String.format("jQuery('#%s').button(%s);", this.button.getMarkupId(), this.newOnClickOptions());
    }

    private String getFinishStatement() {
        return String.format("jQuery('#%s').button(%s);", this.button.getMarkupId(), this.newOnAjaxStopOptions());
    }

    protected Options newOnClickOptions() {
        Options options = new Options();
        options.set("disabled", (Object)true);
        options.set("icon", (Object)Options.asString((String)"ui-icon-indicator"));
        return options;
    }

    protected Options newOnAjaxStopOptions() {
        String icon = this.button.getIcon();
        Options options = new Options();
        options.set("disabled", (Object)(!this.button.isEnabled() ? 1 : 0));
        options.set("icon", (Object)(JQueryIcon.isNone(icon) ? Options.asString((String)"") : Options.asString((String)icon)));
        return options;
    }

    protected JQueryEvent newEvent() {
        return new ClickEvent(this.button);
    }

    protected static class ClickEvent
    extends JQueryEvent {
        private final DialogButton button;

        public ClickEvent(DialogButton button) {
            this.button = button;
        }

        public DialogButton getButton() {
            return this.button;
        }
    }
}

