/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitHeightDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitRectangleDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;

public abstract class PDDestination
implements PDDestinationOrAction {
    public static PDDestination create(COSBase base) throws IOException {
        PDDestination retval = null;
        if (base != null) {
            if (base instanceof COSArray && ((COSArray)base).size() > 1 && ((COSArray)base).getObject(1) instanceof COSName) {
                String typeString;
                COSArray array = (COSArray)base;
                COSName type = (COSName)array.getObject(1);
                switch (typeString = type.getName()) {
                    case "Fit": 
                    case "FitB": {
                        retval = new PDPageFitDestination(array);
                        break;
                    }
                    case "FitV": 
                    case "FitBV": {
                        retval = new PDPageFitHeightDestination(array);
                        break;
                    }
                    case "FitR": {
                        retval = new PDPageFitRectangleDestination(array);
                        break;
                    }
                    case "FitH": 
                    case "FitBH": {
                        retval = new PDPageFitWidthDestination(array);
                        break;
                    }
                    case "XYZ": {
                        retval = new PDPageXYZDestination(array);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown destination type: " + type.getName());
                    }
                }
            } else if (base instanceof COSString) {
                retval = new PDNamedDestination((COSString)base);
            } else if (base instanceof COSName) {
                retval = new PDNamedDestination((COSName)base);
            } else {
                throw new IOException("Error: can't convert to Destination " + base);
            }
        }
        return retval;
    }
}

