/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.data;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.metrics.data.MetricsRepositoryMethodInvocationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactoryCustomizer;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;
import org.springframework.util.function.SingletonSupplier;

class MetricsRepositoryMethodInvocationListenerBeanPostProcessor
implements BeanPostProcessor {
    private final RepositoryFactoryCustomizer customizer;

    MetricsRepositoryMethodInvocationListenerBeanPostProcessor(SingletonSupplier<MetricsRepositoryMethodInvocationListener> listener) {
        this.customizer = new MetricsRepositoryFactoryCustomizer(listener);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RepositoryFactoryBeanSupport) {
            ((RepositoryFactoryBeanSupport)bean).addRepositoryFactoryCustomizer(this.customizer);
        }
        return bean;
    }

    private static final class MetricsRepositoryFactoryCustomizer
    implements RepositoryFactoryCustomizer {
        private final SingletonSupplier<MetricsRepositoryMethodInvocationListener> listenerSupplier;

        private MetricsRepositoryFactoryCustomizer(SingletonSupplier<MetricsRepositoryMethodInvocationListener> listenerSupplier) {
            this.listenerSupplier = listenerSupplier;
        }

        public void customize(RepositoryFactorySupport repositoryFactory) {
            repositoryFactory.addInvocationListener((RepositoryMethodInvocationListener)this.listenerSupplier.get());
        }
    }
}

