/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.FlateFilterDecoderStream;
import org.apache.pdfbox.io.NonSeekableRandomAccessReadInputStream;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.SequenceRandomAccessRead;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.AnnotationFilter;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDViewportDictionary;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDTransition;
import org.apache.pdfbox.util.Matrix;

public class PDPage
implements COSObjectable,
PDContentStream {
    private static final Log LOG = LogFactory.getLog(PDPage.class);
    private static final byte[] DELIMITER = new byte[]{10};
    private final COSDictionary page;
    private PDResources pageResources;
    private ResourceCache resourceCache;
    private PDRectangle mediaBox;

    public PDPage() {
        this(PDRectangle.LETTER);
    }

    public PDPage(PDRectangle mediaBox) {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
        this.page.setItem(COSName.MEDIA_BOX, (COSObjectable)mediaBox);
    }

    public PDPage(COSDictionary pageDictionary) {
        this.page = pageDictionary;
    }

    PDPage(COSDictionary pageDictionary, ResourceCache resourceCache) {
        this.page = pageDictionary;
        this.resourceCache = resourceCache;
    }

    public void removePageResourceFromCache() {
        if (this.resourceCache == null) {
            return;
        }
        this.removeResources(this.page.getCOSDictionary(COSName.RESOURCES));
    }

    private void removeResources(COSDictionary resources) {
        if (resources == null) {
            return;
        }
        this.getIndirectResourceObjects(resources, COSName.COLORSPACE).forEach(this.resourceCache::removeColorSpace);
        this.getIndirectResourceObjects(resources, COSName.EXT_G_STATE).forEach(this.resourceCache::removeExtState);
        this.getIndirectResourceObjects(resources, COSName.FONT).forEach(this.resourceCache::removeFont);
        this.getIndirectResourceObjects(resources, COSName.PATTERN).forEach(this.resourceCache::removePattern);
        this.getIndirectResourceObjects(resources, COSName.PROPERTIES).forEach(this.resourceCache::removeProperties);
        this.getIndirectResourceObjects(resources, COSName.SHADING).forEach(this.resourceCache::removeShading);
        for (COSObject cosObject : this.getIndirectResourceObjects(resources, COSName.XOBJECT)) {
            PDXObject removedXObject = this.resourceCache.removeXObject(cosObject);
            if (!(removedXObject instanceof PDFormXObject)) continue;
            COSStream cosStream = removedXObject.getCOSObject();
            this.removeResources(cosStream.getCOSDictionary(COSName.RESOURCES));
        }
    }

    private List<COSObject> getIndirectResourceObjects(COSDictionary pageResources, COSName kind) {
        COSDictionary resourcesDictionary = pageResources.getCOSDictionary(kind);
        if (resourcesDictionary == null) {
            return Collections.emptyList();
        }
        return resourcesDictionary.getValues().stream().filter(COSObject.class::isInstance).map(COSObject.class::cast).filter(COSObject::isDereferenced).collect(Collectors.toList());
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.page;
    }

    public Iterator<PDStream> getContentStreams() {
        COSBase base = this.page.getDictionaryObject(COSName.CONTENTS);
        if (base instanceof COSStream) {
            return Collections.singletonList(new PDStream((COSStream)base)).iterator();
        }
        if (base instanceof COSArray) {
            COSArray array = (COSArray)base;
            ArrayList<PDStream> streams = new ArrayList<PDStream>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                COSStream stream = (COSStream)array.getObject(i);
                streams.add(new PDStream(stream));
            }
            return streams.iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public InputStream getContents() throws IOException {
        RandomAccessRead contentsForRandomAccess = this.getContentsForRandomAccess();
        if (contentsForRandomAccess != null) {
            return new RandomAccessInputStream(contentsForRandomAccess);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public RandomAccessRead getContentsForStreamParsing() throws IOException {
        COSStream contentStream = this.page.getCOSStream(COSName.CONTENTS);
        if (contentStream != null && COSName.FLATE_DECODE.equals(contentStream.getFilters())) {
            try {
                FlateFilterDecoderStream decoderStream = new FlateFilterDecoderStream(contentStream.createRawInputStream());
                return new NonSeekableRandomAccessReadInputStream((InputStream)decoderStream);
            }
            catch (IOException exception) {
                LOG.warn((Object)"skipped malformed content stream");
                return new RandomAccessReadBuffer(DELIMITER);
            }
        }
        return this.getContentsForRandomAccess();
    }

    @Override
    public RandomAccessRead getContentsForRandomAccess() throws IOException {
        COSStream contentStream = this.page.getCOSStream(COSName.CONTENTS);
        if (contentStream != null) {
            try {
                return contentStream.createView();
            }
            catch (IOException exception) {
                LOG.warn((Object)"skipped malformed content stream");
                return new RandomAccessReadBuffer(DELIMITER);
            }
        }
        COSArray array = this.page.getCOSArray(COSName.CONTENTS);
        if (array != null) {
            List<COSStream> streams = array.toList().stream().map(o -> o instanceof COSObject ? ((COSObject)o).getObject() : o).filter(COSStream.class::isInstance).map(b -> (COSStream)b).collect(Collectors.toList());
            ArrayList inputStreams = new ArrayList();
            streams.forEach(stream -> {
                try {
                    inputStreams.add(stream.createView());
                    inputStreams.add(new RandomAccessReadBuffer(DELIMITER));
                }
                catch (IOException exception) {
                    LOG.warn((Object)"malformed substream of content stream skipped");
                }
            });
            if (!inputStreams.isEmpty()) {
                return new SequenceRandomAccessRead(inputStreams);
            }
        }
        return new RandomAccessReadBuffer(new byte[0]);
    }

    public boolean hasContents() {
        COSBase contents = this.page.getDictionaryObject(COSName.CONTENTS);
        if (contents instanceof COSStream) {
            return ((COSStream)contents).size() > 0;
        }
        if (contents instanceof COSArray) {
            return ((COSArray)contents).size() > 0;
        }
        return false;
    }

    @Override
    public PDResources getResources() {
        COSBase base;
        if (this.pageResources == null && (base = PDPageTree.getInheritableAttribute(this.page, COSName.RESOURCES)) instanceof COSDictionary) {
            this.pageResources = new PDResources((COSDictionary)base, this.resourceCache);
        }
        return this.pageResources;
    }

    public void setResources(PDResources resources) {
        this.pageResources = resources;
        if (resources != null) {
            this.page.setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.page.removeItem(COSName.RESOURCES);
        }
    }

    public int getStructParents() {
        return this.page.getInt(COSName.STRUCT_PARENTS);
    }

    public void setStructParents(int structParents) {
        this.page.setInt(COSName.STRUCT_PARENTS, structParents);
    }

    @Override
    public PDRectangle getBBox() {
        return this.getCropBox();
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix();
    }

    public PDRectangle getMediaBox() {
        if (this.mediaBox == null) {
            COSBase base = PDPageTree.getInheritableAttribute(this.page, COSName.MEDIA_BOX);
            if (base instanceof COSArray) {
                this.mediaBox = new PDRectangle((COSArray)base);
            } else {
                LOG.debug((Object)"Can't find MediaBox, will use U.S. Letter");
                this.mediaBox = PDRectangle.LETTER;
            }
        }
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
        if (mediaBox == null) {
            this.page.removeItem(COSName.MEDIA_BOX);
        } else {
            this.page.setItem(COSName.MEDIA_BOX, (COSObjectable)mediaBox);
        }
    }

    public PDRectangle getCropBox() {
        COSBase base = PDPageTree.getInheritableAttribute(this.page, COSName.CROP_BOX);
        if (base instanceof COSArray) {
            return this.clipToMediaBox(new PDRectangle((COSArray)base));
        }
        return this.getMediaBox();
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.CROP_BOX);
        } else {
            this.page.setItem(COSName.CROP_BOX, (COSBase)cropBox.getCOSArray());
        }
    }

    public PDRectangle getBleedBox() {
        COSArray bleedBox = this.page.getCOSArray(COSName.BLEED_BOX);
        return bleedBox != null ? this.clipToMediaBox(new PDRectangle(bleedBox)) : this.getCropBox();
    }

    public void setBleedBox(PDRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(COSName.BLEED_BOX);
        } else {
            this.page.setItem(COSName.BLEED_BOX, (COSObjectable)bleedBox);
        }
    }

    public PDRectangle getTrimBox() {
        COSArray trimBox = this.page.getCOSArray(COSName.TRIM_BOX);
        return trimBox != null ? this.clipToMediaBox(new PDRectangle(trimBox)) : this.getCropBox();
    }

    public void setTrimBox(PDRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(COSName.TRIM_BOX);
        } else {
            this.page.setItem(COSName.TRIM_BOX, (COSObjectable)trimBox);
        }
    }

    public PDRectangle getArtBox() {
        COSArray artBox = this.page.getCOSArray(COSName.ART_BOX);
        return artBox != null ? this.clipToMediaBox(new PDRectangle(artBox)) : this.getCropBox();
    }

    public void setArtBox(PDRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(COSName.ART_BOX);
        } else {
            this.page.setItem(COSName.ART_BOX, (COSObjectable)artBox);
        }
    }

    private PDRectangle clipToMediaBox(PDRectangle box) {
        PDRectangle mediaBox = this.getMediaBox();
        PDRectangle result = new PDRectangle();
        result.setLowerLeftX(Math.max(mediaBox.getLowerLeftX(), box.getLowerLeftX()));
        result.setLowerLeftY(Math.max(mediaBox.getLowerLeftY(), box.getLowerLeftY()));
        result.setUpperRightX(Math.min(mediaBox.getUpperRightX(), box.getUpperRightX()));
        result.setUpperRightY(Math.min(mediaBox.getUpperRightY(), box.getUpperRightY()));
        return result;
    }

    public int getRotation() {
        int rotationAngle;
        COSBase obj = PDPageTree.getInheritableAttribute(this.page, COSName.ROTATE);
        if (obj instanceof COSNumber && (rotationAngle = ((COSNumber)obj).intValue()) % 90 == 0) {
            return (rotationAngle % 360 + 360) % 360;
        }
        return 0;
    }

    public void setRotation(int rotation) {
        this.page.setInt(COSName.ROTATE, rotation);
    }

    public void setContents(PDStream contents) {
        this.page.setItem(COSName.CONTENTS, (COSObjectable)contents);
    }

    public void setContents(List<PDStream> contents) {
        this.page.setItem(COSName.CONTENTS, (COSBase)new COSArray(contents));
    }

    public List<PDThreadBead> getThreadBeads() {
        COSArray beads = this.page.getCOSArray(COSName.B);
        if (beads == null) {
            beads = new COSArray();
        }
        ArrayList<PDThreadBead> pdObjects = new ArrayList<PDThreadBead>(beads.size());
        for (int i = 0; i < beads.size(); ++i) {
            COSBase base = beads.getObject(i);
            PDThreadBead bead = null;
            if (base instanceof COSDictionary) {
                bead = new PDThreadBead((COSDictionary)base);
            }
            pdObjects.add(bead);
        }
        return new COSArrayList<PDThreadBead>(pdObjects, beads);
    }

    public void setThreadBeads(List<PDThreadBead> beads) {
        this.page.setItem(COSName.B, (COSBase)new COSArray(beads));
    }

    public PDMetadata getMetadata() {
        COSStream metadata = this.page.getCOSStream(COSName.METADATA);
        return metadata != null ? new PDMetadata(metadata) : null;
    }

    public void setMetadata(PDMetadata meta) {
        this.page.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public PDPageAdditionalActions getActions() {
        COSDictionary addAct = this.page.getCOSDictionary(COSName.AA);
        if (addAct == null) {
            addAct = new COSDictionary();
            this.page.setItem(COSName.AA, (COSBase)addAct);
        }
        return new PDPageAdditionalActions(addAct);
    }

    public void setActions(PDPageAdditionalActions actions) {
        this.page.setItem(COSName.AA, (COSObjectable)actions);
    }

    public PDTransition getTransition() {
        COSDictionary transition = this.page.getCOSDictionary(COSName.TRANS);
        return transition != null ? new PDTransition(transition) : null;
    }

    public void setTransition(PDTransition transition) {
        this.page.setItem(COSName.TRANS, (COSObjectable)transition);
    }

    public void setTransition(PDTransition transition, float duration) {
        this.page.setItem(COSName.TRANS, (COSObjectable)transition);
        this.page.setItem(COSName.DUR, (COSBase)new COSFloat(duration));
    }

    public List<PDAnnotation> getAnnotations() throws IOException {
        return this.getAnnotations(annotation -> true);
    }

    public List<PDAnnotation> getAnnotations(AnnotationFilter annotationFilter) throws IOException {
        COSArray annots = this.page.getCOSArray(COSName.ANNOTS);
        if (annots == null) {
            return new COSArrayList<PDAnnotation>(this.page, COSName.ANNOTS);
        }
        ArrayList<PDAnnotation> actuals = new ArrayList<PDAnnotation>();
        for (int i = 0; i < annots.size(); ++i) {
            PDAnnotation createdAnnotation;
            COSBase item = annots.getObject(i);
            if (item == null || !annotationFilter.accept(createdAnnotation = PDAnnotation.createAnnotation(item))) continue;
            actuals.add(createdAnnotation);
        }
        return new COSArrayList<PDAnnotation>(actuals, annots);
    }

    public void setAnnotations(List<PDAnnotation> annotations) {
        this.page.setItem(COSName.ANNOTS, (COSBase)new COSArray(annotations));
    }

    public boolean equals(Object other) {
        return other instanceof PDPage && ((PDPage)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.page.hashCode();
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public List<PDViewportDictionary> getViewports() {
        COSArray array = this.page.getCOSArray(COSName.VP);
        if (array == null) {
            return null;
        }
        ArrayList<PDViewportDictionary> viewports = new ArrayList<PDViewportDictionary>();
        for (int i = 0; i < array.size(); ++i) {
            COSBase base2 = array.getObject(i);
            if (base2 instanceof COSDictionary) {
                viewports.add(new PDViewportDictionary((COSDictionary)base2));
                continue;
            }
            LOG.warn((Object)("Array element " + base2 + " is skipped, must be a (viewport) dictionary"));
        }
        return viewports;
    }

    public void setViewports(List<PDViewportDictionary> viewports) {
        if (viewports == null) {
            this.page.removeItem(COSName.VP);
            return;
        }
        this.page.setItem(COSName.VP, (COSBase)new COSArray(viewports));
    }

    public float getUserUnit() {
        float userUnit = this.page.getFloat(COSName.USER_UNIT, 1.0f);
        return userUnit > 0.0f ? userUnit : 1.0f;
    }

    public void setUserUnit(float userUnit) {
        if (userUnit <= 0.0f) {
            throw new IllegalArgumentException("User unit must be positive");
        }
        this.page.setFloat(COSName.USER_UNIT, userUnit);
    }
}

