/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.init;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.console.ConsoleProperties;
import org.apache.syncope.client.console.init.ClassPathScanImplementationContributor;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.syncope.client.console.widgets.ExtAlertWidget;
import org.apache.syncope.client.ui.commons.annotations.AMPage;
import org.apache.syncope.client.ui.commons.annotations.BinaryPreview;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.client.ui.commons.annotations.ExtWidget;
import org.apache.syncope.client.ui.commons.annotations.IdMPage;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup
implements Serializable {
    private static final long serialVersionUID = 5047756409117925203L;
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope";
    public static final Set<String> USER_FIELD_NAMES = new HashSet<String>();
    public static final Set<String> GROUP_FIELD_NAMES = new HashSet<String>();
    public static final Set<String> ANY_OBJECT_FIELD_NAMES = new HashSet<String>();
    private final Collection<ClassPathScanImplementationContributor> contributors;
    private Map<String, List<Class<?>>> classes;
    private List<Class<? extends BasePage>> idRepoPages;
    private List<Class<? extends BasePage>> idmPages;
    private List<Class<? extends BasePage>> amPages;
    private final ConsoleProperties props;

    private static void initFieldNames(Class<?> entityClass, Set<String> keys) {
        List classes = org.apache.commons.lang3.ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        classes.forEach(clazz -> {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                keys.add(field.getName());
            }
        });
    }

    protected static String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public ClassPathScanImplementationLookup(Collection<ClassPathScanImplementationContributor> contributors, ConsoleProperties props) {
        this.contributors = contributors;
        this.props = props;
    }

    protected ClassPathScanningCandidateComponentProvider scanner() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BasePage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseExtPage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseExtWidget.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ExtAlertWidget.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseSSOLoginFormPanel.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BinaryPreviewer.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ReportConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AccountRuleConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PasswordRuleConf.class));
        this.contributors.forEach(contributor -> contributor.extend(scanner));
        return scanner;
    }

    protected void addClass(String category, Class<?> clazz) {
        List<Class<?>> clazzes = this.classes.get(category);
        if (clazzes == null) {
            clazzes = new ArrayList();
            this.classes.put(category, clazzes);
        }
        clazzes.add(clazz);
    }

    public void load() {
        this.classes = new HashMap();
        this.idRepoPages = new ArrayList<Class<? extends BasePage>>();
        this.idmPages = new ArrayList<Class<? extends BasePage>>();
        this.amPages = new ArrayList<Class<? extends BasePage>>();
        for (BeanDefinition bd : this.scanner().findCandidateComponents(ClassPathScanImplementationLookup.getBasePackage())) {
            try {
                Class clazz = ClassUtils.resolveClassName((String)Objects.requireNonNull(bd.getBeanClassName()), (ClassLoader)ClassUtils.getDefaultClassLoader());
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                if (BaseExtPage.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(ExtPage.class)) {
                        this.addClass(BaseExtPage.class.getName(), clazz);
                        continue;
                    }
                    LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtPage.class.getName(), (Object)clazz.getName());
                    continue;
                }
                if (BaseExtWidget.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(ExtWidget.class)) {
                        this.addClass(BaseExtWidget.class.getName(), clazz);
                        continue;
                    }
                    LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtWidget.class.getName(), (Object)clazz.getName());
                    continue;
                }
                if (ExtAlertWidget.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(ExtWidget.class)) {
                        this.addClass(ExtAlertWidget.class.getName(), clazz);
                        continue;
                    }
                    LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtAlertWidget.class.getName(), (Object)clazz.getName());
                    continue;
                }
                if (BasePage.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(IdMPage.class)) {
                        if (clazz.getName().endsWith("Topology") && !clazz.getName().equals(this.props.getPage().get("topology").getName())) continue;
                        this.idmPages.add(clazz);
                        continue;
                    }
                    if (clazz.isAnnotationPresent(AMPage.class)) {
                        this.amPages.add(clazz);
                        continue;
                    }
                    this.idRepoPages.add(clazz);
                    continue;
                }
                if (BaseSSOLoginFormPanel.class.isAssignableFrom(clazz)) {
                    this.addClass(BaseSSOLoginFormPanel.class.getName(), clazz);
                    continue;
                }
                if (BinaryPreviewer.class.isAssignableFrom(clazz)) {
                    this.addClass(BinaryPreviewer.class.getName(), clazz);
                    continue;
                }
                if (ReportConf.class.isAssignableFrom(clazz)) {
                    this.addClass(ReportConf.class.getName(), clazz);
                    continue;
                }
                if (AccountRuleConf.class.isAssignableFrom(clazz)) {
                    this.addClass(AccountRuleConf.class.getName(), clazz);
                    continue;
                }
                if (PasswordRuleConf.class.isAssignableFrom(clazz)) {
                    this.addClass(PasswordRuleConf.class.getName(), clazz);
                    continue;
                }
                this.contributors.forEach(contributor -> contributor.getLabel(clazz).ifPresent(label -> this.addClass((String)label, clazz)));
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.idRepoPages = Collections.unmodifiableList(this.idRepoPages);
        this.idmPages.sort(Comparator.comparing(o -> o.getAnnotation(IdMPage.class).priority()));
        this.idmPages = Collections.unmodifiableList(this.idmPages);
        this.amPages.sort(Comparator.comparing(o -> o.getAnnotation(AMPage.class).priority()));
        this.amPages = Collections.unmodifiableList(this.amPages);
        if (this.classes.containsKey(BaseExtPage.class.getName())) {
            this.classes.get(BaseExtPage.class.getName()).sort(Comparator.comparing(o -> o.getAnnotation(ExtPage.class).priority()));
        }
        if (this.classes.containsKey(BaseExtWidget.class.getName())) {
            this.classes.get(BaseExtWidget.class.getName()).sort(Comparator.comparing(o -> o.getAnnotation(ExtWidget.class).priority()));
        }
        if (this.classes.containsKey(ExtAlertWidget.class.getName())) {
            this.classes.get(ExtAlertWidget.class.getName()).sort(Comparator.comparing(o -> o.getAnnotation(ExtWidget.class).priority()));
        }
        this.classes.forEach((category, clazzes) -> LOG.debug("{} found: {}", category, clazzes));
    }

    public List<Class<? extends BasePage>> getIdRepoPageClasses() {
        return this.idRepoPages;
    }

    public List<Class<? extends BasePage>> getIdMPageClasses() {
        return this.idmPages;
    }

    public List<Class<? extends BasePage>> getAMPageClasses() {
        return this.amPages;
    }

    public <T> List<Class<? extends T>> getClasses(Class<T> reference) {
        return this.classes.getOrDefault(reference.getName(), List.of()).stream().map(clazz -> clazz).collect(Collectors.toList());
    }

    public List<Class<? extends ExtAlertWidget<?>>> getExtAlertWidgetClasses() {
        return this.classes.getOrDefault(ExtAlertWidget.class.getName(), List.of()).stream().map(clazz -> clazz).collect(Collectors.toList());
    }

    public Class<? extends BinaryPreviewer> getPreviewerClass(String mimeType) {
        LOG.debug("Searching for previewer class for MIME type: {}", (Object)mimeType);
        Class<BinaryPreviewer> previewer = null;
        for (Class<BinaryPreviewer> candidate : this.getClasses(BinaryPreviewer.class)) {
            LOG.debug("Evaluating previewer class {} for MIME type {}", (Object)candidate.getName(), (Object)mimeType);
            if (!candidate.isAnnotationPresent(BinaryPreview.class) || !ArrayUtils.contains((Object[])candidate.getAnnotation(BinaryPreview.class).mimeTypes(), (Object)mimeType)) continue;
            LOG.debug("Found existing previewer for MIME type {}: {}", (Object)mimeType, (Object)candidate.getName());
            previewer = candidate;
        }
        return previewer;
    }

    static {
        ClassPathScanImplementationLookup.initFieldNames(UserTO.class, USER_FIELD_NAMES);
        ClassPathScanImplementationLookup.initFieldNames(GroupTO.class, GROUP_FIELD_NAMES);
        ClassPathScanImplementationLookup.initFieldNames(AnyObjectTO.class, ANY_OBJECT_FIELD_NAMES);
    }
}

