/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v11;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.SCIMProvider;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseResource;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11BasePatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11EnterpriseUser;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Group;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11GroupPatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Meta;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11User;
import net.tirasa.connid.bundles.scim.v11.dto.Scimv11GroupPatchOperation;
import net.tirasa.connid.bundles.scim.v11.service.SCIMv11Client;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMPatchOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(displayNameKey="SCIMv11Connector.connector.display", configurationClass=SCIMConnectorConfiguration.class)
public class SCIMv11Connector
extends AbstractSCIMConnector<SCIMv11User, SCIMv11Group, SCIMBaseResource<SCIMv11Meta>, SCIMv11BasePatch, SCIMPatchOperation, SCIMv11Client, SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager> {
    private Schema schema;

    @Override
    protected SCIMv11Client buildSCIMClient(SCIMConnectorConfiguration configuration) {
        return new SCIMv11Client(configuration);
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMAttributeUtils.buildSchema(this.configuration.getCustomAttributesJSON(), this.configuration.getManageComplexEntitlements(), this.configuration.getUseColonOnExtensionAttributes(), SCIMv11Attribute.class);
        }
        return this.schema;
    }

    @Override
    public Set<AttributeDelta> updateDelta(ObjectClass objectClass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        LOG.error("Update delta is not supported in version 1.1", new Object[0]);
        throw new ConnectorException("Update delta is not supported in version 1.1");
    }

    @Override
    public SCIMv11Client getClient() {
        return (SCIMv11Client)this.client;
    }

    @Override
    protected <T extends SCIMBaseAttribute<T>> SCIMv11User buildNewUserEntity(Optional<SCIMSchema<T>> customSchema) {
        SCIMv11User newUser = new SCIMv11User();
        customSchema.ifPresent(cs -> newUser.getSchemas().add(cs.getId()));
        return newUser;
    }

    @Override
    protected SCIMv11Group buildNewGroupEntity() {
        return new SCIMv11Group();
    }

    @Override
    protected void fillGroupPatches(SCIMv11User user, Map<String, SCIMv11BasePatch> groupPatches, List<String> groupsToAdd, List<String> groupsToRemove) {
        groupsToAdd.forEach(grp -> groupPatches.put((String)grp, (SCIMv11BasePatch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "add")));
        groupsToRemove.forEach(grp -> groupPatches.put((String)grp, (SCIMv11BasePatch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "remove")));
    }

    @Override
    protected SCIMv11BasePatch buildMembersGroupPatch(List<SCIMv11User> users, String op) {
        return new SCIMv11GroupPatch.Builder().members(users.stream().map(user -> new Scimv11GroupPatchOperation.Builder().operation("add").display(this.provider.equals((Object)SCIMProvider.WSO2) ? user.getUserName() : user.getDisplayName()).value(user.getId()).build()).collect(Collectors.toList())).build();
    }

    @Override
    protected SCIMv11BasePatch buildPatchFromGroup(SCIMv11Group group) {
        throw new IllegalArgumentException("Not implemented, yet");
    }

    @Override
    protected SCIMv11BasePatch buildUserPatch(Set<AttributeDelta> modifications, SCIMv11User currentUser, boolean manageGroups) {
        throw new ConnectorException("Update delta is not supported in version 1.1");
    }

    @Override
    protected SCIMv11BasePatch buildGroupPatch(Set<AttributeDelta> modifications) {
        throw new ConnectorException("Update delta is not supported in version 1.1");
    }

    @Override
    protected List<SCIMPatchOperation> buildPatchOperations(AttributeDelta currentDelta, SCIMBaseAttribute<?> attributeDefinition) {
        throw new ConnectorException("Update delta is not supported in version 1.1");
    }

    @Override
    protected List<SCIMPatchOperation> buildGroupPatchOperations(Set<AttributeDelta> modifications) {
        throw new ConnectorException("Update delta is not supported in version 1.1");
    }

    @Override
    protected List<SCIMPatchOperation> buildAddressesPatchOperations(Set<AttributeDelta> modifications, SCIMv11User currentUser) {
        throw new ConnectorException("Update delta is not supported in version 1.1");
    }

    @Override
    protected void manageEntitlements(SCIMv11User user, List<String> values) {
    }

    @Override
    protected SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager buildEnterpriseUserManager(String value) {
        SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager manager = new SCIMv11EnterpriseUser.SCIMv11EnterpriseUserManager();
        if (value.contains(":")) {
            String[] splitValue = value.split(":");
            manager.setManagerId(splitValue[0]);
            manager.setManagerId(splitValue[1]);
        } else {
            manager.setDisplayName(value);
        }
        return manager;
    }
}

