/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.dto.PagedResults;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseMeta;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBasePatch;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseResource;
import net.tirasa.connid.bundles.scim.common.dto.SCIMEnterpriseUser;
import net.tirasa.connid.bundles.scim.common.dto.SCIMGroup;
import net.tirasa.connid.bundles.scim.common.dto.SCIMUser;
import net.tirasa.connid.bundles.scim.common.service.NoSuchEntityException;
import net.tirasa.connid.bundles.scim.common.service.SCIMService;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.Type;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;

public abstract class AbstractSCIMService<UT extends SCIMUser<? extends SCIMBaseMeta, ? extends SCIMEnterpriseUser<?>>, GT extends SCIMGroup<? extends SCIMBaseMeta>, ERT extends SCIMBaseResource<? extends SCIMBaseMeta>, P extends SCIMBasePatch>
implements SCIMService<UT, GT, ERT, P> {
    protected static final Log LOG = Log.getLog(AbstractSCIMService.class);
    protected final SCIMConnectorConfiguration config;
    public static final String RESPONSE_ERRORS = "Errors";
    public static final String RESPONSE_RESOURCES = "Resources";
    public static final int MAX_RETRIES = 3;

    public AbstractSCIMService(SCIMConnectorConfiguration config) {
        this.config = config;
    }

    protected WebClient getWebclient(String path, Map<String, String> params) {
        HTTPClientPolicy policy;
        HTTPConduit conduit;
        WebClient webClient = this.checkBearerToken() ? WebClient.create((String)this.config.getBaseAddress()).header("Authorization", new Object[]{"Bearer " + this.getBearerToken(false)}) : WebClient.create((String)this.config.getBaseAddress(), (String)this.config.getUsername(), this.config.getPassword() == null ? null : SecurityUtil.decrypt((GuardedString)this.config.getPassword()), null);
        if (StringUtil.isNotBlank((String)this.config.getProxyServerHost())) {
            conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            policy = new HTTPClientPolicy();
            policy.setProxyServer(this.config.getProxyServerHost());
            policy.setProxyServerPort(this.config.getProxyServerPort());
            policy.setProxyServerType(ProxyServerType.valueOf((String)this.config.getProxyServerType().toUpperCase()));
            conduit.setClient(policy);
            if (StringUtil.isNotBlank((String)this.config.getProxyServerUser()) && StringUtil.isNotBlank((String)this.config.getProxyServerPassword())) {
                ProxyAuthorizationPolicy authorizationPolicy = new ProxyAuthorizationPolicy();
                authorizationPolicy.setAuthorizationType("Basic");
                authorizationPolicy.setUserName(this.config.getProxyServerUser());
                authorizationPolicy.setPassword(this.config.getProxyServerPassword());
                conduit.setProxyAuthorization(authorizationPolicy);
            }
        }
        if (this.config.getFollowHttpRedirects()) {
            conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            policy = conduit.getClient();
            policy.setAutoRedirect(true);
            conduit.setClient(policy);
        }
        webClient.type(this.config.getContentType()).accept(new String[]{this.config.getAccept()}).path((Object)path);
        Optional.ofNullable(params).ifPresent(p -> p.forEach((k, v) -> webClient.query(k, new Object[]{v})));
        return webClient;
    }

    protected String getBearerToken(boolean forceRefresh) {
        if (StringUtil.isNotBlank((String)this.config.getBearerToken()) && !forceRefresh) {
            return this.config.getBearerToken();
        }
        WebClient webClient = WebClient.create((String)this.config.getAccessTokenBaseAddress()).type(this.config.getAccessTokenContentType()).accept(new String[]{this.config.getAccessTokenAccept()});
        StringBuilder requestBuilder = new StringBuilder("&client_id=").append(this.config.getClientId()).append("&client_secret=").append(this.config.getClientSecret());
        if (StringUtil.isNotBlank((String)this.config.getUsername()) && this.config.getPassword() != null) {
            requestBuilder.append("&username=").append(this.config.getUsername()).append("&password=").append(SecurityUtil.decrypt((GuardedString)this.config.getPassword())).toString();
        }
        String token = null;
        try {
            Response response = webClient.post((Object)requestBuilder.toString());
            String body = (String)response.readEntity(String.class);
            JsonNode result = SCIMUtils.MAPPER.readTree(body);
            if (result == null || !result.hasNonNull(this.config.getAccessTokenNodeId())) {
                SCIMUtils.handleGeneralError("No access token found - " + body);
            }
            token = result.get(this.config.getAccessTokenNodeId()).textValue();
            this.config.setBearerToken(token);
        }
        catch (Exception ex) {
            SCIMUtils.handleGeneralError("While obtaining authentication token", ex);
        }
        return token;
    }

    protected JsonNode doGet(WebClient webClient) {
        LOG.ok("GET: {0}", new Object[]{webClient.getCurrentURI()});
        JsonNode result = null;
        try {
            Response response = this.executeAndRetry(WebClient::get, webClient, 0);
            String responseAsString = (String)response.readEntity(String.class);
            this.checkServiceErrors(response);
            result = SCIMUtils.MAPPER.readTree(responseAsString);
            if (result == null) {
                LOG.ok("Empty result from GET request", new Object[0]);
                result = SCIMUtils.MAPPER.createObjectNode();
            }
            if (result.isArray() && (!result.has(RESPONSE_RESOURCES) || result.get(RESPONSE_RESOURCES).isNull())) {
                SCIMUtils.handleGeneralError("Wrong response from GET request: " + responseAsString);
            }
            this.checkServiceResultErrors(result, response);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While retrieving data from SCIM API", new Object[0]);
        }
        return result;
    }

    protected void doCreate(UT user, WebClient webClient) {
        LOG.ok("CREATE: {0}", new Object[]{webClient.getCurrentURI()});
        try {
            String payload;
            JsonNode customAttributesNode = this.buildCustomAttributesNode(this.config.getCustomAttributesJSON(), user);
            if (customAttributesNode != null) {
                JsonNode userNode = null;
                try {
                    userNode = this.mergeNodes(SCIMUtils.MAPPER.readTree(SCIMUtils.MAPPER.writeValueAsString(user)), customAttributesNode);
                }
                catch (JsonProcessingException ex) {
                    SCIMUtils.handleGeneralError("While converting user to node", (Exception)((Object)ex));
                }
                payload = SCIMUtils.MAPPER.writeValueAsString(userNode);
            } else {
                payload = SCIMUtils.MAPPER.writeValueAsString(user);
            }
            LOG.ok("CREATE payload is {0}: ", new Object[]{payload});
            Response response = this.executeAndRetry(wc -> wc.post((Object)payload), webClient, 0);
            this.checkServiceErrors(response);
            String value = "id";
            String responseAsString = (String)response.readEntity(String.class);
            JsonNode responseObj = SCIMUtils.MAPPER.readTree(responseAsString);
            if (responseObj.hasNonNull(value)) {
                user.setId(responseObj.get(value).textValue());
            } else {
                LOG.error("CREATE payload {0}: ", new Object[]{payload});
                SCIMUtils.handleGeneralError("While getting " + value + " value for created User - Response : " + responseAsString);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Error while creating entity", new Object[0]);
            SCIMUtils.handleGeneralError("While creating User", ex);
        }
    }

    protected JsonNode doUpdate(UT user, WebClient webClient) {
        LOG.ok("UPDATE: {0}", new Object[]{webClient.getCurrentURI()});
        if (this.config.getUpdateUserMethod().equalsIgnoreCase("PATCH")) {
            WebClient.getConfig((Object)webClient).getRequestContext().put("use.async.http.conduit", true);
        }
        JsonNode result = null;
        try {
            String payload;
            JsonNode customAttributesNode = this.buildCustomAttributesNode(this.config.getCustomAttributesJSON(), user);
            if (customAttributesNode != null) {
                JsonNode userNode = null;
                try {
                    userNode = this.mergeNodes(SCIMUtils.MAPPER.readTree(SCIMUtils.MAPPER.writeValueAsString(user)), customAttributesNode);
                }
                catch (JsonProcessingException ex) {
                    SCIMUtils.handleGeneralError("While converting user to node", (Exception)((Object)ex));
                }
                payload = SCIMUtils.MAPPER.writeValueAsString(userNode);
            } else {
                payload = SCIMUtils.MAPPER.writeValueAsString(user);
            }
            LOG.ok("UPDATE payload is {0}: ", new Object[]{payload});
            Response response = this.config.getUpdateUserMethod().equalsIgnoreCase("PATCH") ? this.executeAndRetry(wc -> wc.invoke("PATCH", (Object)payload), webClient, 0) : this.executeAndRetry(wc -> wc.put((Object)payload), webClient, 0);
            this.checkServiceErrors(response);
            result = SCIMUtils.MAPPER.readTree((String)response.readEntity(String.class));
            this.checkServiceResultErrors(result, response);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Error while updating entity", new Object[0]);
            SCIMUtils.handleGeneralError("While updating User", ex);
        }
        return result;
    }

    protected JsonNode doUpdatePatch(Set<Attribute> replaceAttributes, WebClient webClient) {
        LOG.ok("UPDATE PATCH: {0}", new Object[]{webClient.getCurrentURI()});
        return this.doUpdatePatch(null, replaceAttributes, webClient);
    }

    protected JsonNode doUpdatePatch(P patch, Set<Attribute> replaceAttributes, WebClient webClient) {
        LOG.ok("UPDATE PATCH: {0}", new Object[]{webClient.getCurrentURI()});
        WebClient.getConfig((Object)webClient).getRequestContext().put("use.async.http.conduit", true);
        JsonNode result = null;
        try {
            String payload = SCIMUtils.MAPPER.writeValueAsString(patch == null ? this.buildPatchFromAttrs(replaceAttributes) : patch);
            LOG.ok("UPDATE PATCH payload is {0}: ", new Object[]{payload});
            Response response = this.executeAndRetry(wc -> webClient.invoke("PATCH", (Object)payload), webClient, 0);
            this.checkServiceErrors(response);
            result = Response.Status.NO_CONTENT.getStatusCode() == response.getStatus() ? this.doGet(webClient) : SCIMUtils.MAPPER.readTree((String)response.readEntity(String.class));
            this.checkServiceResultErrors(result, response);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Error while updating entity", new Object[0]);
            SCIMUtils.handleGeneralError("While updating Group with patch", ex);
        }
        return result;
    }

    protected abstract P buildPatchFromAttrs(Set<Attribute> var1);

    protected void doDeleteUser(String userId, WebClient webClient) {
        LOG.ok("DELETE: {0}", new Object[]{webClient.getCurrentURI()});
        int status = webClient.delete().getStatus();
        if (status != Response.Status.NO_CONTENT.getStatusCode() && status != Response.Status.OK.getStatusCode()) {
            throw new NoSuchEntityException(userId);
        }
    }

    protected void doActivate(String userId, WebClient webClient) {
        LOG.ok("ACTIVATE: {0}", new Object[]{webClient.getCurrentURI()});
        try {
            ObjectNode userIdNode = SCIMUtils.MAPPER.createObjectNode();
            userIdNode.set("user_id", (JsonNode)userIdNode.textNode(userId));
            String payload = SCIMUtils.MAPPER.writeValueAsString((Object)userIdNode);
            LOG.ok("Activate payload is {0}", new Object[]{payload});
            Response response = this.executeAndRetry(wc -> wc.post((Object)payload), webClient, 0);
            if (response == null) {
                SCIMUtils.handleGeneralError("While activating User - no response");
            } else {
                String responseAsString = (String)response.readEntity(String.class);
                LOG.ok("Response after activating user: {0}", new Object[]{responseAsString});
            }
        }
        catch (IOException ex) {
            SCIMUtils.handleGeneralError("While activating User", ex);
        }
    }

    protected void checkServiceErrors(Response response) {
        if (response == null) {
            SCIMUtils.handleGeneralError("While executing request - no response");
        }
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new NoSuchEntityException("No SCIM entity found");
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            SCIMUtils.handleGeneralError("While executing SCIM request: status is " + response.getStatus() + " and reponse " + (String)response.readEntity(String.class));
        }
    }

    protected void checkServiceResultErrors(JsonNode node, Response response) {
        if (node.has(RESPONSE_ERRORS)) {
            SCIMUtils.handleGeneralError((String)response.readEntity(String.class));
        }
    }

    protected JsonNode buildCustomAttributesNode(String customAttributesJSON, UT user) {
        ObjectNode rootNode = null;
        if (StringUtil.isNotBlank((String)customAttributesJSON) && !user.getSCIMCustomAttributes().isEmpty()) {
            rootNode = SCIMUtils.MAPPER.createObjectNode();
            for (SCIMBaseAttribute<?> attr : user.getSCIMCustomAttributes().keySet()) {
                if (attr.getType().equals("complex")) {
                    for (SCIMBaseAttribute sub : attr.getSubAttributes()) {
                        this.buildCustomSimpleAttributeNode((JsonNode)rootNode, sub, user);
                    }
                    continue;
                }
                this.buildCustomSimpleAttributeNode((JsonNode)rootNode, attr, user);
            }
        }
        return rootNode;
    }

    protected void buildCustomSimpleAttributeNode(JsonNode rootNode, SCIMBaseAttribute<? extends SCIMBaseAttribute<?>> scimAttribute, UT user) {
        ObjectNode newNode = SCIMUtils.MAPPER.createObjectNode();
        List<Object> values = user.getSCIMCustomAttributes().get(scimAttribute);
        List<Object> nodeValue = scimAttribute.getMultiValued() != false ? values : (values.isEmpty() ? null : values.get(0));
        String mainNodeKey = scimAttribute instanceof SCIMv2Attribute ? ((SCIMv2Attribute)SCIMv2Attribute.class.cast(scimAttribute)).getExtensionSchema() : ((SCIMv11Attribute)SCIMv11Attribute.class.cast(scimAttribute)).getSchema();
        String currentNodeKey = scimAttribute.getName();
        if (scimAttribute.getType().equals("complex")) {
            LOG.warn("Too many 'complex' type custom attributes, while parsing custom attribute {0} with schema {1}", new Object[]{currentNodeKey, mainNodeKey});
        } else if (mainNodeKey.contains("extension")) {
            if (rootNode.has(mainNodeKey)) {
                ((ObjectNode)rootNode.get(mainNodeKey)).putPOJO(currentNodeKey, nodeValue);
            } else {
                newNode.putPOJO(currentNodeKey, nodeValue);
                ((ObjectNode)rootNode).set(mainNodeKey, (JsonNode)newNode);
            }
        } else {
            ((ObjectNode)rootNode).putPOJO(currentNodeKey, nodeValue);
        }
    }

    protected JsonNode mergeNodes(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String updatedFieldName = (String)fieldNames.next();
            JsonNode valueToBeUpdated = mainNode.get(updatedFieldName);
            JsonNode updatedValue = updateNode.get(updatedFieldName);
            if (valueToBeUpdated != null && valueToBeUpdated.isArray() && updatedValue.isArray()) {
                for (int i = 0; i < updatedValue.size(); ++i) {
                    JsonNode updatedChildNode = updatedValue.get(i);
                    if (valueToBeUpdated.size() <= i) {
                        ((ArrayNode)valueToBeUpdated).add(updatedChildNode);
                    }
                    JsonNode childNodeToBeUpdated = valueToBeUpdated.get(i);
                    this.mergeNodes(childNodeToBeUpdated, updatedChildNode);
                }
                continue;
            }
            if (valueToBeUpdated != null && valueToBeUpdated.isObject()) {
                this.mergeNodes(valueToBeUpdated, updatedValue);
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            ((ObjectNode)mainNode).replace(updatedFieldName, updatedValue);
        }
        return mainNode;
    }

    protected <T extends SCIMBaseAttribute<T>> void readCustomAttributes(UT user, JsonNode node, Class<T> attrType) {
        SCIMUtils.extractSCIMSchemas(this.config.getCustomAttributesJSON(), attrType).ifPresent(scimSchema -> {
            for (SCIMBaseAttribute attr : scimSchema.getAttributes()) {
                List foundWithSchemaAsKey = node.findValues(attr instanceof SCIMv2Attribute ? ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attr)).getExtensionSchema() : ((SCIMv11Attribute)SCIMv11Attribute.class.cast(attr)).getSchema());
                if (foundWithSchemaAsKey.isEmpty() || !((JsonNode)foundWithSchemaAsKey.get(0)).has(attr.getName())) continue;
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(Type.integer.name().equals(attr.getType()) ? Integer.valueOf(((JsonNode)foundWithSchemaAsKey.get(0)).get(attr.getName()).intValue()) : (Type.BOOLEAN.name().toLowerCase().equals(attr.getType()) ? Boolean.valueOf(((JsonNode)foundWithSchemaAsKey.get(0)).get(attr.getName()).booleanValue()) : ((JsonNode)foundWithSchemaAsKey.get(0)).get(attr.getName()).textValue()));
                user.getReturnedCustomAttributes().put((attr instanceof SCIMv2Attribute ? ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attr)).getExtensionSchema() : ((SCIMv11Attribute)SCIMv11Attribute.class.cast(attr)).getSchema()) + (this.config.getUseColonOnExtensionAttributes() ? ":" : ".") + attr.getName(), values);
            }
        });
    }

    protected void readCustomAttributes(PagedResults<UT> resources, JsonNode node) {
        for (SCIMUser resource : resources.getResources()) {
            this.readCustomAttributes(resource, node, SCIMv2Attribute.class);
        }
    }

    @Override
    public void deleteUser(String userId) {
        this.doDeleteUser(userId, this.getWebclient("Users", null).path((Object)userId));
    }

    @Override
    public void activateUser(String userId) {
        this.doActivateUser(userId);
    }

    protected <T extends SCIMBaseAttribute<T>> UT doGetUser(WebClient webClient, Class<UT> userType, Class<T> attrType) {
        SCIMUser user = null;
        JsonNode node = this.doGet(webClient);
        if (node == null) {
            SCIMUtils.handleGeneralError("While retrieving User from service");
        }
        try {
            user = (SCIMUser)SCIMUtils.MAPPER.readValue(node.toString(), userType);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to User", new Object[0]);
        }
        if (user == null) {
            SCIMUtils.handleGeneralError("While retrieving user from service after create");
        } else {
            this.readCustomAttributes(user, node, attrType);
        }
        return (UT)user;
    }

    protected void doActivateUser(String userId) {
        this.doActivate(userId, this.getWebclient("activation", null).path((Object)"tokens"));
    }

    protected UT doCreateUser(UT user) {
        this.doCreate((GT)user, this.getWebclient("Users", null));
        return user;
    }

    protected UT doUpdateUser(String userId, P userPatch, Class<UT> userType) {
        SCIMUser updated = null;
        JsonNode node = this.doUpdatePatch(userPatch, Collections.emptySet(), this.getWebclient("Users", null).path((Object)userId));
        if (node == null) {
            SCIMUtils.handleGeneralError("While running update patch on service");
        }
        try {
            updated = (SCIMUser)SCIMUtils.MAPPER.readValue(node.toString(), userType);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to User", new Object[0]);
        }
        if (updated == null) {
            SCIMUtils.handleGeneralError("While retrieving user from service after update");
        }
        return (UT)updated;
    }

    protected UT doUpdateUser(UT user, Set<Attribute> replaceAttributes, Class<UT> userType) {
        JsonNode node;
        if (StringUtil.isBlank((String)user.getId())) {
            SCIMUtils.handleGeneralError("Missing required user id attribute for update");
        }
        SCIMUser updated = null;
        JsonNode jsonNode = node = this.config.getUpdateUserMethod().equalsIgnoreCase("PATCH") && !replaceAttributes.isEmpty() ? this.doUpdatePatch(replaceAttributes, this.getWebclient("Users", null).path((Object)user.getId())) : this.doUpdate((GT)user, this.getWebclient("Users", null).path((Object)user.getId()));
        if (node == null) {
            SCIMUtils.handleGeneralError("While running update on service");
        }
        try {
            updated = (SCIMUser)SCIMUtils.MAPPER.readValue(node.toString(), userType);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to User", new Object[0]);
        }
        if (updated == null) {
            SCIMUtils.handleGeneralError("While retrieving user from service after update");
        }
        return (UT)updated;
    }

    @Override
    public boolean testService() {
        HashSet<String> attributesToGet = new HashSet<String>();
        attributesToGet.add("userName");
        return this.getAllUsers(1, 1, attributesToGet) != null;
    }

    @Override
    public List<UT> getAllUsers(Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!attributesToGet.isEmpty() && this.config.getRequestAttributesOnSearch()) {
            params.put("attributes", SCIMUtils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON(), this.config.getUseColonOnExtensionAttributes(), SCIMv2Attribute.class));
        }
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient).getResources();
    }

    @Override
    public List<UT> getAllUsers(String filterQuery, Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filter", filterQuery);
        if (!attributesToGet.isEmpty() && this.config.getRequestAttributesOnSearch()) {
            params.put("attributes", SCIMUtils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON(), this.config.getUseColonOnExtensionAttributes(), SCIMv2Attribute.class));
        }
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient).getResources();
    }

    @Override
    public PagedResults<UT> getAllUsers(Integer startIndex, Integer count, Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startIndex", String.valueOf(startIndex));
        Optional.ofNullable(count).ifPresent(c -> params.put("count", String.valueOf(c)));
        if (!attributesToGet.isEmpty() && this.config.getRequestAttributesOnSearch()) {
            params.put("attributes", SCIMUtils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON(), this.config.getUseColonOnExtensionAttributes(), SCIMv2Attribute.class));
        }
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient);
    }

    public PagedResults<UT> getAllUsers(String filterQuery, Integer startIndex, Integer count, Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startIndex", String.valueOf(startIndex));
        if (count != null) {
            params.put("count", String.valueOf(count));
        }
        params.put("filter", filterQuery);
        if (!attributesToGet.isEmpty() && this.config.getRequestAttributesOnSearch()) {
            params.put("attributes", SCIMUtils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON(), this.config.getUseColonOnExtensionAttributes(), SCIMv2Attribute.class));
        }
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient);
    }

    protected PagedResults<UT> doGetAllUsers(WebClient webClient) {
        PagedResults<UT> pagedResults = null;
        JsonNode node = this.doGet(webClient);
        if (node == null) {
            SCIMUtils.handleGeneralError("While retrieving Users from service");
        }
        try {
            pagedResults = this.deserializeUserPagedResults(node.toString());
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Users", new Object[0]);
        }
        if (pagedResults == null) {
            SCIMUtils.handleGeneralError("While retrieving Users from service");
        } else if (!pagedResults.getResources().isEmpty()) {
            this.readCustomAttributes(pagedResults, node.get(RESPONSE_RESOURCES));
        }
        return pagedResults;
    }

    protected GT doGetGroup(WebClient webClient, Class<GT> groupType) {
        SCIMGroup group = null;
        JsonNode node = this.doGet(webClient);
        if (node == null) {
            SCIMUtils.handleGeneralError("While retrieving Group from service");
        }
        try {
            group = (SCIMGroup)SCIMUtils.MAPPER.readValue(node.toString(), groupType);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Group", new Object[0]);
        }
        if (group == null) {
            SCIMUtils.handleGeneralError("While retrieving group from service");
        }
        return (GT)group;
    }

    protected GT doCreateGroup(GT group) {
        this.doCreate(group, this.getWebclient("Groups", null));
        return group;
    }

    @Override
    public PagedResults<GT> getAllGroups(Integer startIndex, Integer count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startIndex", String.valueOf(startIndex));
        if (count != null) {
            params.put("count", String.valueOf(count));
        }
        WebClient webClient = this.getWebclient("Groups", params);
        return this.doGetAllGroups(webClient);
    }

    @Override
    public List<GT> getAllGroups() {
        WebClient webClient = this.getWebclient("Groups", Collections.emptyMap());
        return this.doGetAllGroups(webClient).getResources();
    }

    @Override
    public List<GT> getAllGroups(String filterQuery) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filter", filterQuery);
        WebClient webClient = this.getWebclient("Groups", params);
        return this.doGetAllGroups(webClient).getResources();
    }

    public PagedResults<GT> getAllGroups(String filterQuery, Integer startIndex, Integer count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startIndex", String.valueOf(startIndex));
        if (count != null) {
            params.put("count", String.valueOf(count));
        }
        params.put("filter", filterQuery);
        WebClient webClient = this.getWebclient("Groups", params);
        return this.doGetAllGroups(webClient);
    }

    protected PagedResults<GT> doGetAllGroups(WebClient webClient) {
        PagedResults<GT> pagedResults = null;
        JsonNode node = this.doGet(webClient);
        if (node == null) {
            SCIMUtils.handleGeneralError("While retrieving Groups from service");
        }
        try {
            pagedResults = this.deserializeGroupPagedResults(node.toString());
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Users", new Object[0]);
        }
        if (pagedResults == null) {
            SCIMUtils.handleGeneralError("While retrieving Groups from service");
        }
        return pagedResults;
    }

    @Override
    public void deleteGroup(String groupId) {
        this.doDeleteGroup(groupId, this.getWebclient("Groups", null).path((Object)groupId));
    }

    @Override
    public GT createGroup(GT group) {
        return this.doCreateGroup(group);
    }

    protected ERT doGetEntitlement(WebClient webClient, Class<ERT> entitlementType) {
        SCIMBaseResource entitlement = null;
        JsonNode node = this.doGet(webClient);
        if (node == null) {
            SCIMUtils.handleGeneralError("While retrieving Entitlement from service");
        }
        try {
            entitlement = (SCIMBaseResource)SCIMUtils.MAPPER.readValue(node.toString(), entitlementType);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Entitlement", new Object[0]);
        }
        if (entitlement == null) {
            SCIMUtils.handleGeneralError("While retrieving Entitlement from service");
        }
        return (ERT)entitlement;
    }

    protected void doCreate(GT group, WebClient webClient) {
        LOG.ok("CREATE: {0}", new Object[]{webClient.getCurrentURI()});
        try {
            String payload = SCIMUtils.MAPPER.writeValueAsString(group);
            LOG.ok("CREATE payload is {0}: ", new Object[]{payload});
            Response response = this.executeAndRetry(wc -> wc.post((Object)payload), webClient, 0);
            this.checkServiceErrors(response);
            String value = "id";
            String responseAsString = (String)response.readEntity(String.class);
            JsonNode responseObj = SCIMUtils.MAPPER.readTree(responseAsString);
            if (responseObj.hasNonNull(value)) {
                group.setId(responseObj.get(value).textValue());
            } else {
                LOG.error("CREATE payload {0} error {1}", new Object[]{payload, responseAsString});
                SCIMUtils.handleGeneralError("While getting " + value + " value for created Group - Response : " + responseAsString);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Unable to create entity", new Object[0]);
            SCIMUtils.handleGeneralError("While creating Group", ex);
        }
    }

    protected GT doUpdateGroup(GT group, P patch, Class<GT> groupType) {
        return this.doUpdateGroup(group, Collections.emptySet(), patch, groupType);
    }

    protected GT doUpdateGroup(GT group, Set<Attribute> replaceAttributes, P patch, Class<GT> groupType) {
        JsonNode node;
        if (StringUtil.isBlank((String)group.getId())) {
            SCIMUtils.handleGeneralError("Missing required group id attribute for update");
        }
        SCIMGroup updated = null;
        JsonNode jsonNode = node = this.config.getUpdateGroupMethod().equalsIgnoreCase("PATCH") && patch != null ? this.doUpdatePatch(patch, replaceAttributes, this.getWebclient("Groups", null).path((Object)group.getId())) : this.doUpdate(group, this.getWebclient("Groups", null).path((Object)group.getId()));
        if (node == null) {
            SCIMUtils.handleGeneralError("While running update group on service");
        }
        try {
            updated = (SCIMGroup)SCIMUtils.MAPPER.readValue(node.toString(), groupType);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Group", new Object[0]);
        }
        if (updated == null) {
            SCIMUtils.handleGeneralError("While retrieving group from service after update");
        }
        return (GT)updated;
    }

    protected JsonNode doUpdate(GT group, WebClient webClient) {
        LOG.ok("UPDATE: {0}", new Object[]{webClient.getCurrentURI()});
        JsonNode result = null;
        try {
            String payload = SCIMUtils.MAPPER.writeValueAsString(group);
            LOG.ok("UPDATE payload is {0}: ", new Object[]{payload});
            Response response = this.executeAndRetry(wc -> wc.put((Object)payload), webClient, 0);
            this.checkServiceErrors(response);
            String responseEntity = (String)response.readEntity(String.class);
            result = StringUtil.isNotBlank((String)responseEntity) ? SCIMUtils.MAPPER.readTree(responseEntity) : this.doGet(this.getWebclient("Groups", null).path((Object)group.getId()));
            this.checkServiceResultErrors(result, response);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Unable to update entity", new Object[0]);
            SCIMUtils.handleGeneralError("While updating Group", ex);
        }
        return result;
    }

    protected void doDeleteGroup(String groupId, WebClient webClient) {
        LOG.ok("DELETE Group: {0}", new Object[]{webClient.getCurrentURI()});
        int status = this.executeAndRetry(WebClient::delete, webClient, 0).getStatus();
        if (status != Response.Status.NO_CONTENT.getStatusCode() && status != Response.Status.OK.getStatusCode()) {
            throw new NoSuchEntityException(groupId);
        }
    }

    protected Response executeAndRetry(Function<WebClient, Response> action, WebClient webClient, int retry) {
        if (this.checkBearerToken()) {
            Response response = action.apply(webClient.replaceHeader("Authorization", (Object)("Bearer " + this.config.getBearerToken())));
            if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                if (retry < 3) {
                    LOG.ok("Refreshing bearer token after UNAUTHORIZED response, try #{0}", new Object[]{retry});
                    this.getBearerToken(true);
                    return this.executeAndRetry(action, webClient, retry + 1);
                }
                LOG.error("Max retries {0} reached after unauthorized error", new Object[]{3});
            }
            return response;
        }
        return action.apply(webClient);
    }

    private boolean checkBearerToken() {
        return StringUtil.isNotBlank((String)this.config.getBearerToken()) || StringUtil.isNotBlank((String)this.config.getClientId()) && StringUtil.isNotBlank((String)this.config.getClientSecret()) && StringUtil.isNotBlank((String)this.config.getAccessTokenBaseAddress()) && StringUtil.isNotBlank((String)this.config.getAccessTokenAccept()) && StringUtil.isNotBlank((String)this.config.getAccessTokenNodeId());
    }

    protected abstract PagedResults<UT> deserializeUserPagedResults(String var1) throws JsonProcessingException;

    protected abstract PagedResults<GT> deserializeGroupPagedResults(String var1) throws JsonProcessingException;
}

