/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;

public class BootstrapButton
extends Button
implements IBootstrapButton<BootstrapButton> {
    private static final long serialVersionUID = 1L;
    private final Buttons.Type type;
    private Icon icon;
    private Component label;
    private Component splitter;
    private ButtonBehavior buttonBehavior;
    private boolean useSplitter = true;

    public BootstrapButton(String componentId, Buttons.Type type) {
        this(componentId, null, type);
    }

    public BootstrapButton(String componentId, IModel<String> model, Buttons.Type type) {
        super(componentId, model);
        this.type = type;
        this.add(new Behavior[]{this.getButtonBehavior()});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getIcon(), this.getSplitter(), this.getButtonLabel()});
    }

    private ButtonBehavior getButtonBehavior() {
        if (this.buttonBehavior == null) {
            this.buttonBehavior = new ButtonBehavior(this.type, Buttons.Size.Medium);
        }
        return this.buttonBehavior;
    }

    private Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.newIcon("icon");
        }
        return this.icon;
    }

    private Component getSplitter() {
        if (this.splitter == null) {
            this.splitter = this.newSplitter("splitter");
        }
        return this.splitter;
    }

    private Component getButtonLabel() {
        if (this.label == null) {
            this.label = this.newLabel("label", (IModel<String>)this.getModel());
        }
        return this.label;
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected Component newLabel(String markupId, IModel<String> model) {
        return new Label(markupId, model).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false).setVisible(false);
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.useSplitter) {
            this.getSplitter().setVisible(this.getIcon().hasIconType() && StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getModelObject())));
        }
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    public BootstrapButton setLabel(IModel<String> label) {
        this.getButtonLabel().setDefaultModel(label);
        this.setModel(label);
        return this;
    }

    public BootstrapButton setIconType(IconType iconType) {
        this.getIcon().setType(iconType);
        return this;
    }

    @Override
    public BootstrapButton setSize(Buttons.Size size) {
        this.getButtonBehavior().setSize(size);
        return this;
    }

    @Override
    public BootstrapButton setType(Buttons.Type type) {
        this.getButtonBehavior().setType(type);
        return this;
    }

    public BootstrapButton setBlock(boolean block) {
        this.getButtonBehavior().setBlock(block);
        return this;
    }

    public BootstrapButton useSplitter(boolean value) {
        this.useSplitter = value;
        return this;
    }
}

