/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.utils.ReadBuffer;

public class StructArrayDecoder<P>
implements Iterator<StructDecoder<StructArrayDecoder<P>>> {
    private final P parent;
    private final ReadBuffer arrayReadBuffer;
    private final int arrayLength;
    private final StructField field;
    private StructDecoder<StructArrayDecoder<P>> current = null;

    public StructArrayDecoder(StructField field, ReadBuffer readBuffer, P parent) {
        this.parent = parent;
        this.field = field;
        int arraySize = readBuffer.getVlqInt();
        this.arrayReadBuffer = readBuffer.limit(arraySize);
        this.arrayLength = readBuffer.getVlqInt();
    }

    public int length() {
        return this.arrayLength;
    }

    public P end() {
        this.arrayReadBuffer.skipAll();
        return this.parent;
    }

    @Override
    public boolean hasNext() {
        return !this.arrayReadBuffer.limitReached();
    }

    @Override
    public StructDecoder<StructArrayDecoder<P>> next() {
        if (this.current != null) {
            this.current.end();
        }
        if (this.arrayReadBuffer.limitReached()) {
            throw new NoSuchElementException();
        }
        this.current = new StructDecoder<StructArrayDecoder<P>>(this.field, this.arrayReadBuffer, this);
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

