/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.entity.topology.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import org.terracotta.connection.ConnectionException;
import org.terracotta.dynamic_config.entity.topology.client.DynamicTopologyEntity;
import org.terracotta.dynamic_config.entity.topology.client.DynamicTopologyEntityFactory;

public class DynamicTopologyEntityProvider {
    private final String connectionName;
    private final DynamicTopologyEntity.Settings settings;
    private final Duration connectTimeout;
    private final String securityRootDirectory;

    public DynamicTopologyEntityProvider(String connectionName, Duration connectTimeout, DynamicTopologyEntity.Settings settings, String securityRootDirectory) {
        this.connectionName = Objects.requireNonNull(connectionName);
        this.settings = Objects.requireNonNull(settings);
        this.connectTimeout = Objects.requireNonNull(connectTimeout);
        this.securityRootDirectory = securityRootDirectory;
    }

    public DynamicTopologyEntity fetchDynamicTopologyEntity(Collection<InetSocketAddress> addresses) throws ConnectionException {
        return DynamicTopologyEntityFactory.fetch(addresses, this.connectionName, this.connectTimeout, this.settings, this.securityRootDirectory);
    }
}

