/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCDirectByteBufferCache;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.CachingClearTextBufferManagerFactory;
import com.tc.net.core.ClearTextBufferManagerFactory;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCComm;
import com.tc.net.core.TCCommImpl;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionImpl;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCListener;
import com.tc.net.core.TCListenerImpl;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.core.event.TCListenerEvent;
import com.tc.net.core.event.TCListenerEventListener;
import com.tc.net.protocol.ProtocolAdaptorFactory;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.properties.TCPropertiesImpl;
import com.tc.text.PrettyPrintable;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCConnectionManagerImpl
implements TCConnectionManager {
    protected static final TCConnection[] EMPTY_CONNECTION_ARRAY = new TCConnection[0];
    protected static final TCListener[] EMPTY_LISTENER_ARRAY = new TCListener[0];
    private static final boolean MESSAGE_PACKUP = TCPropertiesImpl.getProperties().getBoolean("tc.messages.packup.enabled", false);
    protected static final Logger logger = LoggerFactory.getLogger(TCConnectionManager.class);
    private final TCCommImpl comm;
    private final Set<TCConnection> connections = new HashSet<TCConnection>();
    private final Set<TCListener> listeners = new HashSet<TCListener>();
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final ConnectionEvents connEvents;
    private final ListenerEvents listenerEvents;
    private final SocketParams socketParams;
    private final BufferManagerFactory bufferManagerFactory;
    private final TCDirectByteBufferCache buffers = new TCDirectByteBufferCache(TCByteBufferFactory.getFixedBufferSize(), 16384);

    public TCConnectionManagerImpl() {
        this("ConnectionMgr", 0, MESSAGE_PACKUP ? new CachingClearTextBufferManagerFactory() : new ClearTextBufferManagerFactory());
    }

    public TCConnectionManagerImpl(String name, int workerCommCount, BufferManagerFactory bufferManagerFactory) {
        this.connEvents = new ConnectionEvents();
        this.listenerEvents = new ListenerEvents();
        this.socketParams = new SocketParams();
        this.bufferManagerFactory = bufferManagerFactory;
        this.comm = new TCCommImpl(name, workerCommCount, this.socketParams);
        this.comm.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            state.put("connections", this.connections.stream().map(connection -> connection.getState()).collect(Collectors.toList()));
        }
        state.put("processors", this.comm.getState());
        state.put("buffers.cached", this.buffers.size());
        state.put("buffers.referenced", this.buffers.referenced());
        if (this.bufferManagerFactory instanceof PrettyPrintable) {
            state.put("bufferManager", ((PrettyPrintable)((Object)this.bufferManagerFactory)).getStateMap());
        } else {
            state.put("bufferManager", this.bufferManagerFactory.toString());
        }
        return state;
    }

    protected TCConnection createConnectionImpl(TCProtocolAdaptor adaptor, TCConnectionEventListener listener) {
        return new TCConnectionImpl(listener, adaptor, this, this.comm.nioServiceThreadForNewConnection(), this.socketParams, this.bufferManagerFactory);
    }

    protected TCListener createListenerImpl(InetSocketAddress addr, ProtocolAdaptorFactory factory, int backlog, boolean reuseAddr) throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.configureBlocking(false);
        ServerSocket serverSocket = ssc.socket();
        this.socketParams.applyServerSocketParams(serverSocket, reuseAddr);
        try {
            serverSocket.bind(addr, backlog);
        }
        catch (IOException ioe) {
            logger.warn("Unable to bind socket on address " + addr.getAddress() + ", port " + addr.getPort() + ", " + ioe.getMessage());
            throw ioe;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bind: " + serverSocket.getLocalSocketAddress());
        }
        CoreNIOServices commThread = this.comm.nioServiceThreadForNewListener();
        TCListenerImpl rv = new TCListenerImpl(ssc, factory, this.getConnectionListener(), this, commThread, this.bufferManagerFactory);
        commThread.registerListener(rv, ssc);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCConnection[] getAllConnections() {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            return this.connections.toArray(EMPTY_CONNECTION_ARRAY);
        }
    }

    @Override
    public synchronized TCListener[] getAllListeners() {
        return this.listeners.toArray(EMPTY_LISTENER_ARRAY);
    }

    @Override
    public final TCListener createListener(InetSocketAddress addr, ProtocolAdaptorFactory factory) throws IOException {
        return this.createListener(addr, factory, 512, true);
    }

    @Override
    public final TCListener createListener(InetSocketAddress addr, ProtocolAdaptorFactory factory, int backlog, boolean reuseAddr) throws IOException {
        this.checkShutdown();
        TCListener rv = this.createListenerImpl(addr, factory, backlog, reuseAddr);
        rv.addEventListener(this.listenerEvents);
        this.addCreatedListener(rv);
        return rv;
    }

    @Override
    public final TCConnection createConnection(TCProtocolAdaptor adaptor) throws IOException {
        this.checkShutdown();
        TCConnection rv = this.createConnectionImpl(adaptor, this.connEvents);
        this.newConnection(rv);
        return rv;
    }

    @Override
    public void closeAllConnections(long timeout) {
        this.closeAllConnections(false, timeout);
    }

    @Override
    public void asynchCloseAllConnections() {
        this.closeAllConnections(true, 0L);
    }

    private void closeAllConnections(boolean async, long timeout) {
        TCConnection[] conns = this.getAllConnections();
        logger.info("closing {} connection/s for {}", (Object)conns.length, (Object)this.comm.toString());
        for (TCConnection conn : conns) {
            try {
                if (async) {
                    conn.asynchClose();
                    continue;
                }
                conn.close(timeout);
            }
            catch (Exception e) {
                logger.error("Exception trying to close " + conn, (Throwable)e);
            }
        }
    }

    @Override
    public void closeAllListeners() {
        TCListener[] list;
        for (TCListener lsnr : list = this.getAllListeners()) {
            try {
                lsnr.stop();
            }
            catch (Exception e) {
                logger.error("Exception trying to close " + lsnr, (Throwable)e);
            }
        }
    }

    private synchronized void addCreatedListener(TCListener listener) throws IOException {
        if (listener.isStopped()) {
            throw new IOException("listener closed");
        }
        this.listeners.add(listener);
    }

    private synchronized void removeDeadListener(TCListener listener) {
        if (!listener.isStopped()) {
            throw new RuntimeException("listener not closed");
        }
        this.listeners.remove(listener);
    }

    @Override
    public TCComm getTcComm() {
        return this.comm;
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown.attemptSet()) {
            this.closeAllListeners();
            this.asynchCloseAllConnections();
            this.buffers.close();
            this.comm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(TCConnection conn) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newConnection(TCConnection conn) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            this.connections.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(TCConnection connection) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
        }
    }

    protected TCConnectionEventListener getConnectionListener() {
        return this.connEvents;
    }

    private void checkShutdown() throws IOException {
        if (this.shutdown.isSet()) {
            throw new IOException("connection manager shutdown");
        }
    }

    TCDirectByteBufferCache getBufferCache() {
        return this.buffers;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.referenced();
    }

    class ListenerEvents
    implements TCListenerEventListener {
        ListenerEvents() {
        }

        @Override
        public void closeEvent(TCListenerEvent event) {
            TCConnectionManagerImpl.this.removeDeadListener(event.getSource());
        }
    }

    static class ConnectionEvents
    implements TCConnectionEventListener {
        ConnectionEvents() {
        }

        @Override
        public final void connectEvent(TCConnectionEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug("connect event: " + event.toString());
            }
        }

        @Override
        public final void closeEvent(TCConnectionEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug("close event: " + event.toString());
            }
        }

        @Override
        public final void errorEvent(TCConnectionErrorEvent event) {
            try {
                Exception err = event.getException();
                if (err != null) {
                    if (err instanceof IOException) {
                        if (!event.getSource().isClosed()) {
                            logger.info("error event on connection " + event.getSource() + ": " + err.getMessage());
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("error event on connection " + event.getSource() + ": " + err.getMessage(), (Throwable)err);
                        }
                    } else {
                        logger.error("Exception: ", (Throwable)err);
                    }
                }
            }
            finally {
                event.getSource().asynchClose();
            }
        }

        @Override
        public final void endOfFileEvent(TCConnectionEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug("EOF event: " + event.toString());
            }
            event.getSource().asynchClose();
        }
    }
}

