/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.inline.hook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.okta.sdk.client.Client;
import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookBuilder;
import com.okta.sdk.resource.inline.hook.InlineHookChannel;
import com.okta.sdk.resource.inline.hook.InlineHookChannelConfig;
import com.okta.sdk.resource.inline.hook.InlineHookChannelConfigAuthScheme;
import com.okta.sdk.resource.inline.hook.InlineHookChannelConfigHeaders;
import com.okta.sdk.resource.inline.hook.InlineHookType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultInlineHookBuilder
implements InlineHookBuilder {
    private static final String VERSION = "1.0.0";
    private String name;
    private InlineHookType hookType;
    private InlineHookChannel.TypeEnum channelType;
    private String url;
    private String authorizationHeaderValue;
    private Map<String, String> headerMap = Maps.newHashMap();

    public InlineHookBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public InlineHookBuilder setHookType(InlineHookType hookType) {
        this.hookType = hookType;
        return this;
    }

    public InlineHookBuilder setChannelType(InlineHookChannel.TypeEnum channelType) {
        this.channelType = channelType;
        return this;
    }

    public InlineHookBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public InlineHookBuilder setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
        return this;
    }

    public InlineHookBuilder addHeader(String name, String value) {
        this.headerMap.put(name, value);
        return this;
    }

    public InlineHook buildAndCreate(Client client) {
        ArrayList headers = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            headers.add(((InlineHookChannelConfigHeaders)client.instantiate(InlineHookChannelConfigHeaders.class)).setKey(entry.getKey()).setValue(entry.getValue()));
        }
        InlineHookChannelConfigAuthScheme inlineHookChannelConfigAuthScheme = ((InlineHookChannelConfigAuthScheme)client.instantiate(InlineHookChannelConfigAuthScheme.class)).setType("HEADER").setKey("Authorization").setValue(this.authorizationHeaderValue);
        InlineHookChannelConfig inlineHookChannelConfig = ((InlineHookChannelConfig)client.instantiate(InlineHookChannelConfig.class)).setUri(this.url).setHeaders((List)headers).setAuthScheme(inlineHookChannelConfigAuthScheme);
        InlineHookChannel inlineHookChannel = ((InlineHookChannel)client.instantiate(InlineHookChannel.class)).setType(this.channelType).setVersion(VERSION).setConfig(inlineHookChannelConfig);
        InlineHook createdInlineHook = client.createInlineHook(((InlineHook)client.instantiate(InlineHook.class)).setName(this.name).setType(this.hookType).setVersion(VERSION).setChannel(inlineHookChannel));
        return createdInlineHook;
    }
}

