/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventsubscription.service.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Signal;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractServiceEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionBuilder;
import org.flowable.eventsubscription.service.EventSubscriptionServiceConfiguration;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryImpl;
import org.flowable.eventsubscription.service.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.eventsubscription.service.impl.persistence.entity.GenericEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.data.EventSubscriptionDataManager;

public class EventSubscriptionEntityManagerImpl
extends AbstractServiceEngineEntityManager<EventSubscriptionServiceConfiguration, EventSubscriptionEntity, EventSubscriptionDataManager>
implements EventSubscriptionEntityManager {
    public EventSubscriptionEntityManagerImpl(EventSubscriptionServiceConfiguration eventSubscriptionServiceConfiguration, EventSubscriptionDataManager eventSubscriptionDataManager) {
        super((AbstractServiceConfiguration)eventSubscriptionServiceConfiguration, eventSubscriptionServiceConfiguration.getEngineName(), (DataManager)eventSubscriptionDataManager);
    }

    @Override
    public CompensateEventSubscriptionEntity createCompensateEventSubscription() {
        return ((EventSubscriptionDataManager)this.dataManager).createCompensateEventSubscription();
    }

    @Override
    public MessageEventSubscriptionEntity createMessageEventSubscription() {
        return ((EventSubscriptionDataManager)this.dataManager).createMessageEventSubscription();
    }

    @Override
    public SignalEventSubscriptionEntity createSignalEventSubscription() {
        return ((EventSubscriptionDataManager)this.dataManager).createSignalEventSubscription();
    }

    @Override
    public GenericEventSubscriptionEntity createGenericEventSubscription() {
        return ((EventSubscriptionDataManager)this.dataManager).createGenericEventSubscriptionEntity();
    }

    @Override
    public EventSubscription createEventSubscription(EventSubscriptionBuilder eventSubscriptionBuilder) {
        if ("signal".equals(eventSubscriptionBuilder.getEventType())) {
            return this.insertSignalEvent(eventSubscriptionBuilder);
        }
        if ("message".equals(eventSubscriptionBuilder.getEventType())) {
            return this.insertMessageEvent(eventSubscriptionBuilder);
        }
        if ("compensate".equals(eventSubscriptionBuilder.getEventType())) {
            return this.insertCompensationEvent(eventSubscriptionBuilder);
        }
        return this.insertGenericEvent(eventSubscriptionBuilder);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionId(String executionId) {
        return this.findCompensateEventSubscriptionsByExecutionIdAndActivityId(executionId, null);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionIdAndActivityId(String executionId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByExecutionAndType(executionId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || activityId != null && !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(String processInstanceId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByProcessInstanceAndActivityId(processInstanceId, activityId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    @Override
    public long findEventSubscriptionCountByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionCountByQueryCriteria(eventSubscriptionQueryImpl);
    }

    @Override
    public List<EventSubscription> findEventSubscriptionsByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByQueryCriteria(eventSubscriptionQueryImpl);
    }

    @Override
    public List<MessageEventSubscriptionEntity> findMessageEventSubscriptionsByProcessInstanceAndEventName(String processInstanceId, String eventName) {
        return ((EventSubscriptionDataManager)this.dataManager).findMessageEventSubscriptionsByProcessInstanceAndEventName(processInstanceId, eventName);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByEventName(String eventName, String tenantId) {
        return ((EventSubscriptionDataManager)this.dataManager).findSignalEventSubscriptionsByEventName(eventName, tenantId);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByProcessInstanceAndEventName(String processInstanceId, String eventName) {
        return ((EventSubscriptionDataManager)this.dataManager).findSignalEventSubscriptionsByProcessInstanceAndEventName(processInstanceId, eventName);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByScopeAndEventName(String scopeId, String scopeType, String eventName) {
        return ((EventSubscriptionDataManager)this.dataManager).findSignalEventSubscriptionsByScopeAndEventName(scopeId, scopeType, eventName);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByNameAndExecution(String name, String executionId) {
        return ((EventSubscriptionDataManager)this.dataManager).findSignalEventSubscriptionsByNameAndExecution(name, executionId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecutionAndType(String executionId, String type) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByExecutionAndType(executionId, type);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByProcessInstanceAndType(String processInstanceId, String type) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByProcessInstanceAndType(processInstanceId, type);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByProcessInstanceAndActivityId(String processInstanceId, String activityId, String type) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByProcessInstanceAndActivityId(processInstanceId, activityId, type);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecution(String executionId) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByExecution(executionId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsBySubScopeId(String subScopeId) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsBySubScopeId(subScopeId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByTypeAndProcessDefinitionId(String type, String processDefinitionId, String tenantId) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByTypeAndProcessDefinitionId(type, processDefinitionId, tenantId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByScopeIdAndType(String scopeId, String type) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByScopeIdAndType(scopeId, type);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByName(String type, String eventName, String tenantId) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByName(type, eventName, tenantId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndExecution(String type, String eventName, String executionId) {
        return ((EventSubscriptionDataManager)this.dataManager).findEventSubscriptionsByNameAndExecution(type, eventName, executionId);
    }

    @Override
    public MessageEventSubscriptionEntity findMessageStartEventSubscriptionByName(String messageName, String tenantId) {
        return ((EventSubscriptionDataManager)this.dataManager).findMessageStartEventSubscriptionByName(messageName, tenantId);
    }

    @Override
    public void updateEventSubscriptionTenantId(String oldTenantId, String newTenantId) {
        ((EventSubscriptionDataManager)this.dataManager).updateEventSubscriptionTenantId(oldTenantId, newTenantId);
    }

    @Override
    public boolean lockEventSubscription(String eventSubscriptionId) {
        EventSubscriptionServiceConfiguration serviceConfiguration = (EventSubscriptionServiceConfiguration)this.getServiceConfiguration();
        int lockMillis = (int)serviceConfiguration.getEventSubscriptionLockTime().toMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(serviceConfiguration.getClock().getCurrentTime());
        lockCal.add(14, lockMillis);
        Date lockExpirationTime = lockCal.getTime();
        String lockOwner = serviceConfiguration.getLockOwner();
        return ((EventSubscriptionDataManager)this.dataManager).updateEventSubscriptionLockTime(eventSubscriptionId, lockExpirationTime, lockOwner, this.getClock().getCurrentTime());
    }

    @Override
    public void unlockEventSubscription(String eventSubscriptionId) {
        ((EventSubscriptionDataManager)this.dataManager).clearEventSubscriptionLockTime(eventSubscriptionId);
    }

    @Override
    public void deleteEventSubscriptionsForProcessDefinition(String processDefinitionId) {
        ((EventSubscriptionDataManager)this.dataManager).deleteEventSubscriptionsForProcessDefinition(processDefinitionId);
    }

    @Override
    public void deleteEventSubscriptionsByExecutionId(String executionId) {
        ((EventSubscriptionDataManager)this.dataManager).deleteEventSubscriptionsByExecutionId(executionId);
    }

    @Override
    public void deleteEventSubscriptionsForScopeIdAndType(String scopeId, String scopeType) {
        ((EventSubscriptionDataManager)this.dataManager).deleteEventSubscriptionsForScopeIdAndType(scopeId, scopeType);
    }

    @Override
    public void deleteEventSubscriptionsForScopeDefinitionIdAndType(String scopeDefinitionId, String scopeType) {
        ((EventSubscriptionDataManager)this.dataManager).deleteEventSubscriptionsForScopeDefinitionIdAndType(scopeDefinitionId, scopeType);
    }

    @Override
    public void deleteEventSubscriptionsForScopeDefinitionIdAndTypeAndNullScopeId(String scopeDefinitionId, String scopeType) {
        ((EventSubscriptionDataManager)this.dataManager).deleteEventSubscriptionsForScopeDefinitionIdAndTypeAndNullScopeId(scopeDefinitionId, scopeType);
    }

    protected SignalEventSubscriptionEntity insertSignalEvent(EventSubscriptionBuilder eventSubscriptionBuilder) {
        SignalEventSubscriptionEntity subscriptionEntity = this.createSignalEventSubscription();
        subscriptionEntity.setExecutionId(eventSubscriptionBuilder.getExecutionId());
        subscriptionEntity.setProcessInstanceId(eventSubscriptionBuilder.getProcessInstanceId());
        subscriptionEntity.setEventName(eventSubscriptionBuilder.getEventName());
        Signal signal = eventSubscriptionBuilder.getSignal();
        if (signal != null) {
            if (eventSubscriptionBuilder.getEventName() == null) {
                if (StringUtils.isNotEmpty((CharSequence)signal.getName())) {
                    subscriptionEntity.setEventName(signal.getName());
                } else {
                    subscriptionEntity.setEventName(signal.getId());
                }
            }
            if (signal.getScope() != null) {
                subscriptionEntity.setConfiguration(signal.getScope());
            }
        }
        subscriptionEntity.setActivityId(eventSubscriptionBuilder.getActivityId());
        subscriptionEntity.setProcessDefinitionId(eventSubscriptionBuilder.getProcessDefinitionId());
        subscriptionEntity.setSubScopeId(eventSubscriptionBuilder.getSubScopeId());
        subscriptionEntity.setScopeId(eventSubscriptionBuilder.getScopeId());
        subscriptionEntity.setScopeDefinitionId(eventSubscriptionBuilder.getScopeDefinitionId());
        subscriptionEntity.setScopeType(eventSubscriptionBuilder.getScopeType());
        if (eventSubscriptionBuilder.getTenantId() != null) {
            subscriptionEntity.setTenantId(eventSubscriptionBuilder.getTenantId());
        }
        this.insert(subscriptionEntity);
        return subscriptionEntity;
    }

    protected MessageEventSubscriptionEntity insertMessageEvent(EventSubscriptionBuilder eventSubscriptionBuilder) {
        MessageEventSubscriptionEntity subscriptionEntity = this.createMessageEventSubscription();
        subscriptionEntity.setExecutionId(eventSubscriptionBuilder.getExecutionId());
        subscriptionEntity.setProcessInstanceId(eventSubscriptionBuilder.getProcessInstanceId());
        subscriptionEntity.setEventName(eventSubscriptionBuilder.getEventName());
        subscriptionEntity.setActivityId(eventSubscriptionBuilder.getActivityId());
        subscriptionEntity.setProcessDefinitionId(eventSubscriptionBuilder.getProcessDefinitionId());
        if (eventSubscriptionBuilder.getTenantId() != null) {
            subscriptionEntity.setTenantId(eventSubscriptionBuilder.getTenantId());
        }
        subscriptionEntity.setConfiguration(eventSubscriptionBuilder.getConfiguration());
        this.insert(subscriptionEntity);
        return subscriptionEntity;
    }

    protected CompensateEventSubscriptionEntity insertCompensationEvent(EventSubscriptionBuilder eventSubscriptionBuilder) {
        CompensateEventSubscriptionEntity eventSubscription = this.createCompensateEventSubscription();
        eventSubscription.setExecutionId(eventSubscriptionBuilder.getExecutionId());
        eventSubscription.setProcessInstanceId(eventSubscriptionBuilder.getProcessInstanceId());
        eventSubscription.setActivityId(eventSubscriptionBuilder.getActivityId());
        if (eventSubscriptionBuilder.getTenantId() != null) {
            eventSubscription.setTenantId(eventSubscriptionBuilder.getTenantId());
        }
        eventSubscription.setConfiguration(eventSubscriptionBuilder.getConfiguration());
        this.insert(eventSubscription);
        return eventSubscription;
    }

    protected GenericEventSubscriptionEntity insertGenericEvent(EventSubscriptionBuilder eventSubscriptionBuilder) {
        GenericEventSubscriptionEntity eventSubscription = this.createGenericEventSubscription();
        eventSubscription.setEventType(eventSubscriptionBuilder.getEventType());
        eventSubscription.setEventName(eventSubscriptionBuilder.getEventName());
        eventSubscription.setExecutionId(eventSubscriptionBuilder.getExecutionId());
        eventSubscription.setProcessInstanceId(eventSubscriptionBuilder.getProcessInstanceId());
        eventSubscription.setActivityId(eventSubscriptionBuilder.getActivityId());
        eventSubscription.setProcessDefinitionId(eventSubscriptionBuilder.getProcessDefinitionId());
        eventSubscription.setSubScopeId(eventSubscriptionBuilder.getSubScopeId());
        eventSubscription.setScopeId(eventSubscriptionBuilder.getScopeId());
        eventSubscription.setScopeDefinitionId(eventSubscriptionBuilder.getScopeDefinitionId());
        eventSubscription.setScopeType(eventSubscriptionBuilder.getScopeType());
        if (eventSubscriptionBuilder.getTenantId() != null) {
            eventSubscription.setTenantId(eventSubscriptionBuilder.getTenantId());
        }
        eventSubscription.setConfiguration(eventSubscriptionBuilder.getConfiguration());
        this.insert(eventSubscription);
        return eventSubscription;
    }

    protected List<SignalEventSubscriptionEntity> toSignalEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<SignalEventSubscriptionEntity> signalEventSubscriptionEntities = new ArrayList<SignalEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            signalEventSubscriptionEntities.add((SignalEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return signalEventSubscriptionEntities;
    }

    protected List<MessageEventSubscriptionEntity> toMessageEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<MessageEventSubscriptionEntity> messageEventSubscriptionEntities = new ArrayList<MessageEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            messageEventSubscriptionEntities.add((MessageEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return messageEventSubscriptionEntities;
    }
}

