/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.monitor.JdbcSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.security.CasWebSecurityConfigurerAdapter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.WebApplication)
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
@AutoConfiguration
@EnableWebSecurity
public class CasWebAppSecurityConfiguration
extends GlobalMethodSecurityConfiguration {
    @Bean
    public InitializingBean securityContextHolderInitialization() {
        return () -> SecurityContextHolder.setStrategyName((String)"MODE_THREADLOCAL");
    }

    @Configuration(value="CasWebAppSecurityJdbcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(name={"cas.monitor.endpoints.jdbc.query"})
    public static class CasWebAppSecurityJdbcConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"jdbcUserDetailsPasswordEncoder"})
        public static PasswordEncoder jdbcUserDetailsPasswordEncoder(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            JdbcSecurityActuatorEndpointsMonitorProperties jdbc = casProperties.getMonitor().getEndpoints().getJdbc();
            return PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)jdbc.getPasswordEncoder(), (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"jdbcUserDetailsManager"})
        public UserDetailsManager jdbcUserDetailsManager(CasConfigurationProperties casProperties) {
            JdbcSecurityActuatorEndpointsMonitorProperties jdbc = casProperties.getMonitor().getEndpoints().getJdbc();
            JdbcUserDetailsManager manager = new JdbcUserDetailsManager((DataSource)JpaBeans.newDataSource((AbstractJpaProperties)jdbc));
            manager.setRolePrefix(jdbc.getRolePrefix());
            manager.setUsersByUsernameQuery(jdbc.getQuery());
            return manager;
        }
    }

    @Configuration(value="CasWebappCoreSecurityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebappCoreSecurityConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"casWebSecurityCustomizer"})
        public WebSecurityCustomizer casWebSecurityCustomizer(@Qualifier(value="securityContextRepository") SecurityContextRepository securityContextRepository, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<ProtocolEndpointWebSecurityConfigurer> configurersList, SecurityProperties securityProperties, CasConfigurationProperties casProperties) {
            CasWebSecurityConfigurerAdapter adapter = new CasWebSecurityConfigurerAdapter(casProperties, securityProperties, pathMappedEndpoints, configurersList, securityContextRepository);
            return adapter::configureWebSecurity;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebSecurityConfigurerAdapter"})
        public SecurityFilterChain casWebSecurityConfigurerAdapter(@Qualifier(value="securityContextRepository") SecurityContextRepository securityContextRepository, HttpSecurity http, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<ProtocolEndpointWebSecurityConfigurer> configurersList, SecurityProperties securityProperties, CasConfigurationProperties casProperties) throws Exception {
            CasWebSecurityConfigurerAdapter adapter = new CasWebSecurityConfigurerAdapter(casProperties, securityProperties, pathMappedEndpoints, configurersList, securityContextRepository);
            return (SecurityFilterChain)adapter.configureHttpSecurity(http).build();
        }
    }

    @Configuration(value="CasWebAppSecurityMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasWebAppSecurityMvcConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"securityContextRepository"})
        public SecurityContextRepository securityContextRepository() {
            return new HttpSessionSecurityContextRepository();
        }

        @Bean
        public FilterRegistrationBean<SecurityContextHolderFilter> securityContextHolderFilter(@Qualifier(value="securityContextRepository") SecurityContextRepository securityContextRepository) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new SecurityContextHolderFilter(securityContextRepository));
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("Spring Security Context Holder Filter");
            bean.setAsyncSupported(true);
            bean.setOrder(Integer.MIN_VALUE);
            return bean;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebAppSecurityWebMvcConfigurer"})
        public WebMvcConfigurer casWebAppSecurityWebMvcConfigurer(final CasConfigurationProperties casProperties) {
            return new WebMvcConfigurer(){

                public void addViewControllers(ViewControllerRegistry registry) {
                    if (casProperties.getMonitor().getEndpoints().isFormLoginEnabled()) {
                        registry.addViewController("/adminlogin").setViewName("admin/casAdminLoginView");
                        registry.setOrder(Integer.MIN_VALUE);
                    }
                }
            };
        }
    }
}

