/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.FieldExtension;

public class FieldExtensionExport
implements BpmnXMLConstants {
    public static boolean writeFieldExtensions(List<FieldExtension> fieldExtensionList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        for (FieldExtension fieldExtension : fieldExtensionList) {
            if (!StringUtils.isNotEmpty((CharSequence)fieldExtension.getFieldName()) || !StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue()) && !StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) continue;
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "field", "http://flowable.org/bpmn");
            BpmnXMLUtil.writeDefaultAttribute("name", fieldExtension.getFieldName(), xtw);
            if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) {
                xtw.writeStartElement("flowable", "string", "http://flowable.org/bpmn");
                xtw.writeCData(fieldExtension.getStringValue());
            } else {
                xtw.writeStartElement("flowable", "expression", "http://flowable.org/bpmn");
                xtw.writeCData(fieldExtension.getExpression());
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }
}

