/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.MapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;

public class RelationRelationMapTableFieldStrategy
extends MapTableFieldStrategy {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(RelationRelationMapTableFieldStrategy.class);
    private String _keyRelationName = null;

    @Override
    public Column[] getKeyColumns(ClassMapping cls) {
        return this.field.getKeyMapping().getColumns();
    }

    @Override
    public Column[] getValueColumns(ClassMapping cls) {
        return this.field.getElementMapping().getColumns();
    }

    @Override
    public void selectKey(Select sel, ClassMapping key, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) {
        sel.select(key, this.field.getKeyMapping().getSelectSubclasses(), store, fetch, 0, joins);
    }

    @Override
    public void selectValue(Select sel, ClassMapping val, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) {
        sel.select(val, this.field.getElementMapping().getSelectSubclasses(), store, fetch, 0, joins);
    }

    @Override
    public Result[] getResults(final OpenJPAStateManager sm, final JDBCStore store, final JDBCFetchConfiguration fetch, final int eagerMode, final Joins[] resJoins, boolean lrs) throws SQLException {
        ValueMapping key = this.field.getKeyMapping();
        final ClassMapping[] keys = key.getIndependentTypeMappings();
        Union kunion = store.getSQLFactory().newUnion(keys.length);
        if (fetch.getSubclassFetchMode(key.getTypeMapping()) != 1) {
            kunion.abortUnion();
        }
        kunion.setLRS(lrs);
        kunion.select(new Union.Selector(){

            @Override
            public void select(Select sel, int idx) {
                ForeignKey joinFK = null;
                if (RelationRelationMapTableFieldStrategy.this.field.isUni1ToMFK()) {
                    ValueMapping val = RelationRelationMapTableFieldStrategy.this.field.getElementMapping();
                    ValueMappingInfo vinfo = val.getValueInfo();
                    Table table = vinfo.getTable(val);
                    joinFK = RelationRelationMapTableFieldStrategy.this.field.getMappingInfo().getJoinForeignKey(RelationRelationMapTableFieldStrategy.this.field, table, true);
                } else {
                    joinFK = RelationRelationMapTableFieldStrategy.this.field.getJoinForeignKey();
                }
                sel.whereForeignKey(joinFK, sm.getObjectId(), RelationRelationMapTableFieldStrategy.this.field.getDefiningMapping(), store);
                Joins joins = RelationRelationMapTableFieldStrategy.this.joinKeyRelation(sel.newJoins(), keys[idx]);
                sel.orderBy(RelationRelationMapTableFieldStrategy.this.field.getKeyMapping().getColumns(), true, true);
                sel.select(keys[idx], RelationRelationMapTableFieldStrategy.this.field.getKeyMapping().getSelectSubclasses(), store, fetch, eagerMode, joins);
                if (idx == 0) {
                    resJoins[0] = joins;
                }
            }
        });
        ValueMapping val = this.field.getElementMapping();
        final ClassMapping[] vals = val.getIndependentTypeMappings();
        Union vunion = store.getSQLFactory().newUnion(vals.length);
        if (fetch.getSubclassFetchMode(val.getTypeMapping()) != 1) {
            vunion.abortUnion();
        }
        vunion.setLRS(lrs);
        vunion.select(new Union.Selector(){

            @Override
            public void select(Select sel, int idx) {
                if (RelationRelationMapTableFieldStrategy.this.field.isUni1ToMFK()) {
                    sel.orderBy(RelationRelationMapTableFieldStrategy.this.field.getKeyMapping().getColumns(), true, true);
                    sel.select(vals[idx], RelationRelationMapTableFieldStrategy.this.field.getElementMapping().getSelectSubclasses(), store, fetch, eagerMode, null);
                    sel.whereForeignKey(RelationRelationMapTableFieldStrategy.this.field.getElementMapping().getForeignKey(), sm.getObjectId(), RelationRelationMapTableFieldStrategy.this.field.getElementMapping().getDeclaredTypeMapping(), store);
                } else {
                    sel.whereForeignKey(RelationRelationMapTableFieldStrategy.this.field.getJoinForeignKey(), sm.getObjectId(), RelationRelationMapTableFieldStrategy.this.field.getDefiningMapping(), store);
                    Joins joins = RelationRelationMapTableFieldStrategy.this.joinValueRelation(sel.newJoins(), vals[idx]);
                    sel.orderBy(RelationRelationMapTableFieldStrategy.this.field.getKeyMapping().getColumns(), true, true);
                    sel.select(vals[idx], RelationRelationMapTableFieldStrategy.this.field.getElementMapping().getSelectSubclasses(), store, fetch, eagerMode, joins);
                    if (idx == 0) {
                        resJoins[1] = joins;
                    }
                }
            }
        });
        Result kres = null;
        Result vres = null;
        try {
            kres = kunion.execute(store, fetch);
            vres = vunion.execute(store, fetch);
            return new Result[]{kres, vres};
        }
        catch (SQLException se) {
            if (kres != null) {
                kres.close();
            }
            if (vres != null) {
                vres.close();
            }
            throw se;
        }
    }

    @Override
    public Object loadKey(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        ClassMapping key = res.getBaseMapping();
        if (key == null) {
            key = this.field.getKeyMapping().getIndependentTypeMappings()[0];
        }
        return res.load(key, store, fetch, joins);
    }

    @Override
    public Object loadValue(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        ClassMapping val = res.getBaseMapping();
        if (val == null) {
            val = this.field.getElementMapping().getIndependentTypeMappings()[0];
        }
        return res.load(val, store, fetch, joins);
    }

    @Override
    public Joins joinKeyRelation(Joins joins, ClassMapping key) {
        ValueMapping vm = this.field.getKeyMapping();
        return joins.joinRelation(this._keyRelationName, vm.getForeignKey(key), key, vm.getSelectSubclasses(), false, false);
    }

    @Override
    public Joins joinValueRelation(Joins joins, ClassMapping val) {
        ValueMapping vm = this.field.getElementMapping();
        ForeignKey fk = vm.getForeignKey(val);
        if (fk == null) {
            return joins;
        }
        return joins.joinRelation(this.field.getName(), fk, val, vm.getSelectSubclasses(), false, false);
    }

    @Override
    public void map(boolean adapt) {
        super.map(adapt);
        ValueMapping key = this.field.getKeyMapping();
        if (key.getTypeCode() != 15 || key.isEmbeddedPC()) {
            throw new MetaDataException(_loc.get("not-relation", (Object)key));
        }
        ValueMapping val = this.field.getElementMapping();
        if (val.getTypeCode() != 15 || val.isEmbeddedPC()) {
            throw new MetaDataException(_loc.get("not-relation", (Object)val));
        }
        FieldMapping mapped = this.field.getMappedByMapping();
        DBDictionary dict = this.field.getMappingRepository().getDBDictionary();
        DBIdentifier keyName = null;
        if (this.field.isUni1ToMFK() || !this.field.isBiMTo1JT() && mapped != null) {
            this.handleMappedByForeignKey(adapt);
            keyName = dict.getValidColumnName(DBIdentifier.newColumn("vkey"), this.field.getTable());
        } else if (this.field.isBiMTo1JT() || mapped == null) {
            this.field.mapJoin(adapt, true);
            this.mapTypeJoin(val, DBIdentifier.newColumn("value"), adapt);
            keyName = dict.getValidColumnName(DBIdentifier.newColumn("key"), this.field.getTable());
        }
        this.mapTypeJoin(key, keyName, adapt);
        this.field.mapPrimaryKey(adapt);
    }

    private void mapTypeJoin(ValueMapping vm, DBIdentifier name, boolean adapt) {
        if (vm.getTypeMapping().isMapped()) {
            ValueMappingInfo vinfo = vm.getValueInfo();
            ForeignKey fk = vinfo.getTypeJoin(vm, name, false, adapt);
            vm.setForeignKey(fk);
            vm.setColumnIO(vinfo.getColumnIO());
        } else {
            RelationStrategies.mapRelationToUnmappedPC(vm, name, adapt);
        }
        vm.mapConstraints(name, adapt);
    }

    @Override
    public void initialize() {
        this._keyRelationName = this.field.getName() + ":key";
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.insert(sm, rm, (Map)sm.fetchObject(this.field.getIndex()), store);
    }

    private void insert(OpenJPAStateManager sm, RowManager rm, Map map, JDBCStore store) throws SQLException {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (!this.field.isBiMTo1JT() && this.field.getMappedBy() != null) {
            return;
        }
        Row row = null;
        if (!this.field.isUni1ToMFK()) {
            row = rm.getSecondaryRow(this.field.getTable(), 1);
            row.setForeignKey(this.field.getJoinForeignKey(), this.field.getJoinColumnIO(), sm);
        }
        ValueMapping key = this.field.getKeyMapping();
        ValueMapping val = this.field.getElementMapping();
        StoreContext ctx = sm.getContext();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            OpenJPAStateManager keysm = RelationStrategies.getStateManager(entry.getKey(), ctx);
            OpenJPAStateManager valsm = RelationStrategies.getStateManager(entry.getValue(), ctx);
            if (this.field.isUni1ToMFK()) {
                row = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                row.wherePrimaryKey(valsm);
                val.setForeignKey(row, sm);
            } else {
                val.setForeignKey(row, valsm);
            }
            key.setForeignKey(row, keysm);
            PersistenceCapable obj = sm.getPersistenceCapable();
            if (this.populateKey(row, valsm, obj, ctx, rm, store) || this.field.isUni1ToMFK()) continue;
            rm.flushSecondaryRow(row);
        }
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Collection add;
        Collection rem;
        OpenJPAStateManager valsm;
        OpenJPAStateManager keysm;
        Iterator mkey;
        Proxy proxy;
        if (this.field.getMappedBy() != null && !this.field.isBiMTo1JT()) {
            return;
        }
        Map map = (Map)sm.fetchObject(this.field.getIndex());
        ChangeTracker ct = null;
        if (map instanceof Proxy && Proxies.isOwner((Proxy)(proxy = (Proxy)map), (OpenJPAStateManager)sm, (int)this.field.getIndex())) {
            ct = proxy.getChangeTracker();
        }
        if (ct == null || !ct.isTracking()) {
            this.delete(sm, store, rm);
            this.insert(sm, rm, map, store);
            return;
        }
        ValueMapping key = this.field.getKeyMapping();
        ValueMapping val = this.field.getElementMapping();
        StoreContext ctx = store.getContext();
        Collection change = ct.getChanged();
        boolean canChange = val.getForeignKey().isLogical();
        if (canChange && !change.isEmpty()) {
            Row changeRow = null;
            if (!this.field.isUni1ToMFK()) {
                changeRow = rm.getSecondaryRow(this.field.getTable(), 0);
                changeRow.whereForeignKey(this.field.getJoinForeignKey(), sm);
            }
            for (Iterator o : change) {
                mkey = o;
                Object mval = map.get(mkey);
                if (mval == null) {
                    Set entries = map.entrySet();
                    for (Map.Entry entry : entries) {
                        if (!entry.getKey().equals(mkey)) continue;
                        mval = entry.getValue();
                    }
                }
                if (mval == null) continue;
                keysm = RelationStrategies.getStateManager(mkey, ctx);
                valsm = RelationStrategies.getStateManager(mval, ctx);
                key.whereForeignKey(changeRow, keysm);
                if (this.field.isUni1ToMFK()) {
                    changeRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                    changeRow.wherePrimaryKey(valsm);
                    val.setForeignKey(changeRow, sm);
                    continue;
                }
                val.setForeignKey(changeRow, valsm);
                rm.flushSecondaryRow(changeRow);
            }
        }
        if (!(rem = ct.getRemoved()).isEmpty() || !canChange && !change.isEmpty()) {
            Row delRow = null;
            if (!this.field.isUni1ToMFK()) {
                delRow = rm.getSecondaryRow(this.field.getTable(), 2);
                delRow.whereForeignKey(this.field.getJoinForeignKey(), sm);
            }
            for (Object pc : rem) {
                if (this.field.isUni1ToMFK()) {
                    this.updateSetNull(sm, rm, pc);
                    continue;
                }
                keysm = RelationStrategies.getStateManager(pc, ctx);
                key.whereForeignKey(delRow, keysm);
                rm.flushSecondaryRow(delRow);
            }
            if (!canChange && !change.isEmpty()) {
                for (Object pc : change) {
                    if (this.field.isUni1ToMFK()) {
                        this.updateSetNull(sm, rm, pc);
                        continue;
                    }
                    keysm = RelationStrategies.getStateManager(pc, ctx);
                    key.whereForeignKey(delRow, keysm);
                    rm.flushSecondaryRow(delRow);
                }
            }
        }
        if (!(add = ct.getAdded()).isEmpty() || !canChange && !change.isEmpty()) {
            Set entries;
            Object mval;
            Row addRow = null;
            if (!this.field.isUni1ToMFK()) {
                addRow = rm.getSecondaryRow(this.field.getTable(), 1);
                addRow.setForeignKey(this.field.getJoinForeignKey(), this.field.getJoinColumnIO(), sm);
            }
            for (Object value : add) {
                mkey = value;
                mval = map.get(mkey);
                if (mval == null) {
                    entries = map.entrySet();
                    for (Map.Entry entry : entries) {
                        if (!entry.getKey().equals(mkey)) continue;
                        mval = entry.getValue();
                    }
                }
                if (mval == null) continue;
                keysm = RelationStrategies.getStateManager(mkey, ctx);
                valsm = RelationStrategies.getStateManager(mval, ctx);
                if (this.field.isUni1ToMFK()) {
                    addRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                    addRow.wherePrimaryKey(valsm);
                    key.setForeignKey(addRow, keysm);
                    val.setForeignKey(addRow, sm);
                    continue;
                }
                key.setForeignKey(addRow, keysm);
                val.setForeignKey(addRow, valsm);
                rm.flushSecondaryRow(addRow);
            }
            if (!canChange && !change.isEmpty()) {
                for (Object o : change) {
                    mkey = o;
                    mval = map.get(mkey);
                    if (mval == null) {
                        entries = map.entrySet();
                        for (Map.Entry entry : entries) {
                            if (!entry.getKey().equals(mkey)) continue;
                            mval = entry.getValue();
                        }
                    }
                    if (mval == null) continue;
                    keysm = RelationStrategies.getStateManager(mkey, ctx);
                    valsm = RelationStrategies.getStateManager(mval, ctx);
                    if (this.field.isUni1ToMFK()) {
                        addRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                        addRow.wherePrimaryKey(valsm);
                        key.setForeignKey(addRow, keysm);
                        val.setForeignKey(addRow, sm);
                        continue;
                    }
                    key.setForeignKey(addRow, keysm);
                    val.setForeignKey(addRow, valsm);
                    rm.flushSecondaryRow(addRow);
                }
            }
        }
    }

    @Override
    public Joins joinRelation(Joins joins, boolean forceOuter, boolean traverse) {
        ValueMapping val = this.field.getElementMapping();
        ClassMapping[] clss = val.getIndependentTypeMappings();
        if (clss.length != 1) {
            if (traverse) {
                throw RelationStrategies.unjoinable(val);
            }
            return joins;
        }
        ForeignKey fk = val.getForeignKey(clss[0]);
        if (fk == null) {
            return joins;
        }
        if (forceOuter) {
            return joins.outerJoinRelation(this.field.getName(), fk, clss[0], val.getSelectSubclasses(), false, false);
        }
        return joins.joinRelation(this.field.getName(), fk, clss[0], val.getSelectSubclasses(), false, false);
    }

    @Override
    public Joins joinKeyRelation(Joins joins, boolean forceOuter, boolean traverse) {
        ValueMapping key = this.field.getKeyMapping();
        ClassMapping[] clss = key.getIndependentTypeMappings();
        if (clss.length != 1) {
            if (traverse) {
                throw RelationStrategies.unjoinable(key);
            }
            return joins;
        }
        if (forceOuter) {
            return joins.outerJoinRelation(this.field.getName(), key.getForeignKey(clss[0]), clss[0], key.getSelectSubclasses(), false, false);
        }
        return joins.joinRelation(this._keyRelationName, key.getForeignKey(clss[0]), clss[0], key.getSelectSubclasses(), false, false);
    }

    @Override
    public Object toDataStoreValue(Object val, JDBCStore store) {
        return RelationStrategies.toDataStoreValue(this.field.getElementMapping(), val, store);
    }

    @Override
    public Object toKeyDataStoreValue(Object val, JDBCStore store) {
        return RelationStrategies.toDataStoreValue(this.field.getKeyMapping(), val, store);
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this.field.isUni1ToMFK()) {
            Map mapObj = (Map)sm.fetchObject(this.field.getIndex());
            this.updateSetNull(sm, store, rm, mapObj.keySet());
            return;
        }
        super.delete(sm, store, rm);
    }

    private void updateSetNull(OpenJPAStateManager sm, JDBCStore store, RowManager rm, Set rem) throws SQLException {
        for (Object mkey : rem) {
            this.updateSetNull(sm, rm, mkey);
        }
    }

    private void updateSetNull(OpenJPAStateManager sm, RowManager rm, Object mkey) throws SQLException {
        StoreContext ctx = sm.getContext();
        ValueMapping key = this.field.getKeyMapping();
        ValueMapping val = this.field.getElementMapping();
        OpenJPAStateManager keysm = RelationStrategies.getStateManager(mkey, ctx);
        Row delRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, sm, true);
        ValueMappingInfo vinfo = this.field.getElementMapping().getValueInfo();
        Table table = vinfo.getTable(val);
        ForeignKey joinFK = this.field.getMappingInfo().getJoinForeignKey(this.field, table, true);
        delRow.whereForeignKey(joinFK, sm);
        delRow.whereForeignKey(key.getForeignKey(), keysm);
        val.setForeignKey(delRow, null);
        key.setForeignKey(delRow, null);
    }
}

