/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class CompositeHealthIndicator
extends AbstractHealthIndicator {
    private final List<? extends HealthIndicator> healthIndicators;

    protected void doHealthCheck(Health.Builder builder) {
        ArrayList aggregatedStatus = new ArrayList();
        this.healthIndicators.forEach(indicator -> {
            Health health = indicator.getHealth(true);
            String name = health.getDetails().getOrDefault("name", indicator.getClass().getSimpleName());
            LinkedHashMap<String, Status> details = new LinkedHashMap<String, Status>(health.getDetails());
            details.putIfAbsent("status", health.getStatus());
            builder.withDetail(name, details);
            aggregatedStatus.add(health.getStatus());
        });
        boolean isUp = aggregatedStatus.stream().allMatch(s -> s.equals((Object)Status.UP));
        builder.status(isUp ? Status.UP : Status.DOWN);
    }

    @Generated
    public CompositeHealthIndicator(List<? extends HealthIndicator> healthIndicators) {
        this.healthIndicators = healthIndicators;
    }
}

