/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.NumberUtility;

final class DigitShiftAccumulator
implements IShiftAccumulator {
    private static final long[] TenPowersLong = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final EInteger ValueTen = EInteger.FromInt32(10);
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    private int bitLeftmost;
    private int bitsAfterLeftmost;
    private FastInteger discardedDigitCount;
    private boolean isSmall;
    private FastInteger knownDigitLength;
    private EInteger shiftedBigInt;
    private int shiftedSmall;

    public String toString() {
        return "[this.bitLeftmost=" + this.bitLeftmost + ", this.bitsAfterLeftmost=" + this.bitsAfterLeftmost + ", this.discardedDigitCount=" + this.discardedDigitCount + ", this.isSmall=" + this.isSmall + ", this.knownDigitLength=" + this.knownDigitLength + ", this.shiftedBigInt=" + this.shiftedBigInt + ", this.shiftedSmall=" + this.shiftedSmall + "]";
    }

    public DigitShiftAccumulator(EInteger bigint, int lastDiscarded, int olderDiscarded) {
        if (bigint.CanFitInInt32()) {
            this.shiftedSmall = bigint.ToInt32Checked();
            if (this.shiftedSmall < 0) {
                throw new IllegalArgumentException("shiftedSmall(" + this.shiftedSmall + ") is less than 0");
            }
            this.isSmall = true;
        } else {
            this.shiftedBigInt = bigint;
            this.isSmall = false;
        }
        this.bitsAfterLeftmost = olderDiscarded != 0 ? 1 : 0;
        this.bitLeftmost = lastDiscarded;
    }

    public DigitShiftAccumulator(int smallint, int lastDiscarded, int olderDiscarded) {
        this.shiftedSmall = smallint;
        if (this.shiftedSmall < 0) {
            throw new IllegalArgumentException("shiftedSmall(" + this.shiftedSmall + ") is less than 0");
        }
        this.isSmall = true;
        this.bitsAfterLeftmost = olderDiscarded != 0 ? 1 : 0;
        this.bitLeftmost = lastDiscarded;
    }

    @Override
    public final FastInteger getDiscardedDigitCount() {
        this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
        return this.discardedDigitCount;
    }

    @Override
    public final int getLastDiscardedDigit() {
        return this.bitLeftmost;
    }

    @Override
    public final int getOlderDiscardedDigits() {
        return this.bitsAfterLeftmost;
    }

    @Override
    public final EInteger getShiftedInt() {
        return this.isSmall ? EInteger.FromInt32(this.shiftedSmall) : this.shiftedBigInt;
    }

    @Override
    public int ShiftedIntMod(int mod) {
        switch (mod) {
            case 1: {
                return 0;
            }
            case 2: {
                return this.isSmall ? this.shiftedSmall & 1 : (this.shiftedBigInt.isEven() ? 0 : 1);
            }
        }
        return this.isSmall ? this.shiftedSmall % mod : this.shiftedBigInt.Mod(mod).ToInt32Checked();
    }

    @Override
    public final FastInteger getShiftedIntFast() {
        return this.isSmall ? new FastInteger(this.shiftedSmall) : FastInteger.FromBig(this.shiftedBigInt);
    }

    @Override
    public FastInteger GetDigitLength() {
        this.knownDigitLength = this.knownDigitLength == null ? this.CalcKnownDigitLength() : this.knownDigitLength;
        return this.knownDigitLength;
    }

    @Override
    public FastInteger OverestimateDigitLength() {
        if (this.knownDigitLength != null) {
            return this.knownDigitLength;
        }
        if (this.isSmall) {
            return this.GetDigitLength();
        }
        return NumberUtility.DecimalDigitLengthBounds(this.shiftedBigInt)[1];
    }

    private FastInteger UnderestimateDigitLength() {
        if (this.knownDigitLength != null) {
            return this.knownDigitLength;
        }
        if (this.isSmall) {
            return this.GetDigitLength();
        }
        return NumberUtility.DecimalDigitLengthBounds(this.shiftedBigInt)[0];
    }

    public void ShiftRight(FastInteger fastint) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (fastint.CanFitInInt32()) {
            int fi = fastint.ToInt32();
            if (fi < 0) {
                return;
            }
            this.ShiftRightInt(fi);
        } else {
            if (fastint.signum() <= 0) {
                return;
            }
            EInteger digitsToShift = fastint.ToEInteger();
            while (digitsToShift.signum() > 0) {
                if (digitsToShift.compareTo(1000000) >= 0 && (this.isSmall || this.shiftedBigInt.GetUnsignedBitLengthAsEInteger().compareTo(digitsToShift) < 0)) {
                    this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
                    this.discardedDigitCount.AddBig(digitsToShift);
                    this.bitsAfterLeftmost |= this.bitLeftmost;
                    this.bitsAfterLeftmost |= (this.isSmall ? this.shiftedSmall == 0 : this.shiftedBigInt.isZero()) ? 0 : 1;
                    this.bitLeftmost = 0;
                    this.knownDigitLength = new FastInteger(1);
                    this.isSmall = true;
                    this.shiftedSmall = 0;
                    return;
                }
                int count = 1000000;
                if (digitsToShift.compareTo(1000000) < 0) {
                    count = digitsToShift.ToInt32Checked();
                }
                this.ShiftRightInt(count);
                digitsToShift = digitsToShift.Subtract(EInteger.FromInt32(count));
                if (!(this.isSmall ? this.shiftedSmall == 0 : this.shiftedBigInt.isZero())) continue;
                return;
            }
        }
    }

    @Override
    public void ShiftRightInt(int digits) {
        if (this.isSmall) {
            this.ShiftRightSmall(digits);
        } else {
            this.ShiftRightBig(digits, false, false);
        }
    }

    @Override
    public void ShiftToDigits(FastInteger bits, FastInteger preShift, boolean truncate) {
        if (preShift != null && preShift.signum() > 0) {
            FastInteger kdl;
            this.knownDigitLength = kdl = this.knownDigitLength == null ? this.CalcKnownDigitLength() : this.knownDigitLength;
            if (kdl.compareTo(bits) <= 0) {
                this.TruncateOrShiftRight(preShift, truncate);
                return;
            }
            FastInteger bitDiff = kdl.Copy().Subtract(bits);
            int cmp = bitDiff.compareTo(preShift);
            if (cmp <= 0) {
                this.TruncateOrShiftRight(preShift, truncate);
                return;
            }
            this.TruncateOrShiftRight(bitDiff, truncate);
            return;
        }
        if (bits.CanFitInInt32()) {
            int intval = bits.ToInt32();
            if (intval < 0) {
                throw new IllegalArgumentException("intval(" + intval + ") is less than 0");
            }
            if (this.isSmall) {
                this.ShiftToDigitsSmall(intval);
            } else {
                this.ShiftToDigitsBig(intval, truncate);
            }
        } else {
            FastInteger kdl;
            this.knownDigitLength = kdl = this.knownDigitLength == null ? this.CalcKnownDigitLength() : this.knownDigitLength;
            EInteger bigintDiff = kdl.ToEInteger();
            EInteger bitsBig = bits.ToEInteger();
            if ((bigintDiff = bigintDiff.Subtract(bitsBig)).signum() > 0) {
                this.ShiftRight(FastInteger.FromBig(bigintDiff));
            }
        }
    }

    public boolean TruncateRightExact(FastInteger fastint) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (fastint.CanFitInInt32()) {
            if (fastint.signum() < 0) {
                return (this.bitLeftmost | this.bitsAfterLeftmost) == 0;
            }
            if (!this.isSmall && !this.shiftedBigInt.CanFitInInt64()) {
                int a = fastint.ToInt32();
                if (a > 10) {
                    this.ShiftRightBig(10, true, true);
                    if ((this.bitLeftmost | this.bitsAfterLeftmost) != 0) {
                        return false;
                    }
                    if (this.isSmall) {
                        this.ShiftRightInt(a - 10);
                    } else {
                        this.ShiftRightBig(a - 10, true, true);
                    }
                } else {
                    this.ShiftRightBig(a, true, true);
                }
                return (this.bitLeftmost | this.bitsAfterLeftmost) == 0;
            }
        }
        this.TruncateOrShiftRight(fastint, true);
        return (this.bitLeftmost | this.bitsAfterLeftmost) == 0;
    }

    public void TruncateRightSimple(FastInteger fastint) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (fastint.CanFitInInt32()) {
            if (fastint.signum() < 0) {
                return;
            }
            if (!this.isSmall && !this.shiftedBigInt.CanFitInInt64()) {
                this.ShiftRightBig(fastint.ToInt32(), true, true);
                return;
            }
        }
        this.TruncateOrShiftRight(fastint, true);
    }

    @Override
    public void TruncateOrShiftRight(FastInteger fastint, boolean truncate) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (truncate && fastint.CanFitInInt32()) {
            int fi = fastint.ToInt32();
            if (fi < 0) {
                return;
            }
            if (!this.isSmall) {
                if (this.shiftedBigInt.CanFitInInt64()) {
                    this.TruncateRightLong(this.shiftedBigInt.ToInt64Checked(), fi);
                } else {
                    this.ShiftRightBig(fi, true, false);
                }
            } else {
                this.TruncateRightSmall(fi);
            }
        } else {
            this.ShiftRight(fastint);
        }
    }

    private static int FastParseLong(String str, int offset, int length) {
        if (length > 9) {
            throw new IllegalArgumentException("length(" + length + ") is more than 9 ");
        }
        int ret = 0;
        for (int i = 0; i < length; ++i) {
            int digit = str.charAt(offset + i) - 48;
            ret *= 10;
            ret += digit;
        }
        return ret;
    }

    private static EInteger DivideByPowerOfTen(EInteger ei, int pow) {
        return ei.Divide(NumberUtility.FindPowerOfTen(pow));
    }

    private FastInteger CalcKnownDigitLength() {
        if (this.isSmall) {
            int kb = NumberUtility.DecimalDigitLength(this.shiftedSmall);
            return new FastInteger(kb);
        }
        long digits = this.shiftedBigInt.GetDigitCountAsInt64();
        if (digits == Long.MAX_VALUE) {
            return FastInteger.FromBig(this.shiftedBigInt.GetDigitCountAsEInteger());
        }
        if (digits < Integer.MAX_VALUE) {
            return new FastInteger((int)digits);
        }
        return FastInteger.FromBig(EInteger.FromInt64(digits));
    }

    private void UpdateKnownLengthInt(int digits) {
        if (this.knownDigitLength != null) {
            this.knownDigitLength.SubtractInt(digits);
            if (this.knownDigitLength.CompareToInt(1) < 0) {
                this.knownDigitLength.SetInt(1);
            }
        }
    }

    private void UpdateKnownLength(FastInteger digitsShiftedFast) {
        if (this.knownDigitLength != null) {
            this.knownDigitLength.Subtract(digitsShiftedFast);
            if (this.knownDigitLength.CompareToInt(1) < 0) {
                this.knownDigitLength.SetInt(1);
            }
        }
    }

    private void ShiftRightBig(int digits, boolean truncate, boolean simple) {
        if (digits <= 0) {
            return;
        }
        if (this.shiftedBigInt.isZero()) {
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        if (truncate) {
            EInteger bigquo;
            EInteger bigBitLength = this.shiftedBigInt.GetUnsignedBitLengthAsEInteger();
            boolean bigPower = false;
            if (digits > 50 && bigBitLength.compareTo(100) > 0 && bigBitLength.Add(5).compareTo(digits) < 0) {
                bigPower = true;
            } else {
                int bitLength;
                int n = bitLength = bigBitLength.CanFitInInt32() ? bigBitLength.ToInt32Checked() : Integer.MAX_VALUE;
                if (digits > 50 && bitLength < 160 || digits > 100 && bitLength < 326) {
                    bigPower = true;
                } else {
                    FastInteger digitsUpperBound = this.OverestimateDigitLength();
                    boolean bl = bigPower = digitsUpperBound.Copy().SubtractInt(digits).CompareToInt(-2) < 0;
                }
            }
            if (bigPower) {
                this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
                this.discardedDigitCount.AddInt(digits);
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitsAfterLeftmost |= this.shiftedBigInt.isZero() ? 0 : 1;
                this.bitLeftmost = 0;
                this.knownDigitLength = new FastInteger(1);
                this.isSmall = true;
                this.shiftedSmall = 0;
                return;
            }
            if (!simple || this.ShiftedIntMod(2) == 0 && this.bitLeftmost == 0) {
                EInteger[] quorem = this.shiftedBigInt.DivRem(NumberUtility.FindPowerOfTen(digits));
                bigquo = quorem[0];
                this.bitLeftmost |= quorem[1].isZero() ? 0 : 1;
            } else {
                this.bitLeftmost = 1;
                bigquo = this.shiftedBigInt.Divide(NumberUtility.FindPowerOfTen(digits));
            }
            this.bitsAfterLeftmost |= this.bitLeftmost;
            FastInteger fastInteger = this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(digits) : this.discardedDigitCount.AddInt(digits);
            if (bigquo.isZero()) {
                this.isSmall = true;
                this.shiftedBigInt = null;
                this.shiftedSmall = 0;
                this.knownDigitLength = new FastInteger(1);
            } else if (bigquo.CanFitInInt32()) {
                this.isSmall = true;
                this.shiftedSmall = bigquo.ToInt32Unchecked();
                this.shiftedBigInt = null;
                this.UpdateKnownLengthInt(digits);
            } else {
                this.isSmall = false;
                this.shiftedBigInt = bigquo;
                this.UpdateKnownLengthInt(digits);
            }
            return;
        }
        if (digits == 1) {
            EInteger[] divrem = this.shiftedBigInt.DivRem(EInteger.FromInt32(10));
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem.ToInt32Checked();
            this.shiftedBigInt = bigquo;
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.UpdateKnownLengthInt(digits);
            return;
        }
        if (digits >= 2 && digits <= 8) {
            EInteger[] divrem = this.shiftedBigInt.DivRem(NumberUtility.FindPowerOfTen(digits));
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            int intRem = bigrem.ToInt32Checked();
            int smallPower = ValueTenPowers[digits - 1];
            int leftBit = intRem / smallPower;
            int otherBits = intRem - leftBit * smallPower;
            this.bitsAfterLeftmost |= otherBits | this.bitLeftmost;
            this.bitLeftmost = leftBit;
            this.shiftedBigInt = bigquo;
            this.discardedDigitCount = this.discardedDigitCount != null ? this.discardedDigitCount.AddInt(digits) : new FastInteger(digits);
            this.UpdateKnownLengthInt(digits);
            int n = this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            if (this.shiftedBigInt.CanFitInInt32()) {
                this.isSmall = true;
                this.shiftedSmall = this.shiftedBigInt.ToInt32Unchecked();
                this.shiftedBigInt = null;
            }
            return;
        }
        FastInteger fastInteger = this.knownDigitLength = this.knownDigitLength == null ? this.CalcKnownDigitLength() : this.knownDigitLength;
        if (new FastInteger(digits).Decrement().compareTo(this.knownDigitLength) >= 0) {
            this.bitsAfterLeftmost |= this.shiftedBigInt.isZero() ? 0 : 1;
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownDigitLength = new FastInteger(1);
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            return;
        }
        if (this.shiftedBigInt.CanFitInInt32()) {
            this.isSmall = true;
            this.shiftedSmall = this.shiftedBigInt.ToInt32Checked();
            this.ShiftRightSmall(digits);
            return;
        }
        if (this.shiftedBigInt.CanFitInInt64()) {
            this.ShiftRightLong(this.shiftedBigInt.ToInt64Unchecked(), digits);
            return;
        }
        EInteger sbi = this.shiftedBigInt;
        EInteger[] divrem1 = sbi.DivRem(NumberUtility.FindPowerOfTen(digits - 1));
        EInteger[] divrem2 = divrem1[0].DivRem(10);
        this.bitsAfterLeftmost |= this.bitLeftmost;
        this.bitsAfterLeftmost |= divrem1[1].isZero() ? 0 : 1;
        this.bitLeftmost = divrem2[1].ToInt32Checked();
        this.discardedDigitCount = this.discardedDigitCount != null ? this.discardedDigitCount.AddInt(digits) : new FastInteger(digits);
        this.UpdateKnownLengthInt(digits);
        if (divrem2[0].CanFitInInt32()) {
            this.isSmall = true;
            this.shiftedSmall = divrem2[0].ToInt32Checked();
        } else {
            this.isSmall = false;
            this.shiftedBigInt = divrem2[0];
        }
    }

    private void ShiftRightLong(long shiftedLong, int digits) {
        if (digits <= 0) {
            return;
        }
        if (shiftedLong == 0L) {
            this.shiftedSmall = 0;
            this.isSmall = true;
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        if (digits >= 2 && digits <= 8) {
            if (shiftedLong >= (long)ValueTenPowers[digits]) {
                long bigPower = ValueTenPowers[digits];
                long smallPower = ValueTenPowers[digits - 1];
                this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
                this.discardedDigitCount.AddInt(digits);
                long div = shiftedLong / bigPower;
                long rem = shiftedLong - div * bigPower;
                long rem2 = rem / smallPower;
                this.bitLeftmost = (int)rem2;
                this.bitsAfterLeftmost |= rem - rem2 * smallPower == 0L ? 0 : 1;
                boolean bl = this.isSmall = div <= Integer.MAX_VALUE;
                if (this.isSmall) {
                    this.shiftedSmall = (int)div;
                    this.knownDigitLength = div < 10L ? new FastInteger(1) : new FastInteger(NumberUtility.DecimalDigitLength(div));
                } else {
                    this.shiftedBigInt = EInteger.FromInt64(div);
                    this.knownDigitLength = div < 10L ? new FastInteger(1) : this.CalcKnownDigitLength();
                }
                return;
            }
            if (this.shiftedSmall >= ValueTenPowers[digits - 1]) {
                int smallPower = ValueTenPowers[digits - 1];
                if (this.discardedDigitCount != null) {
                    this.discardedDigitCount.AddInt(digits);
                } else {
                    this.discardedDigitCount = new FastInteger(digits);
                }
                long rem = shiftedLong;
                long rem2 = rem / (long)smallPower;
                this.bitLeftmost = (int)rem2;
                this.bitsAfterLeftmost |= rem - rem2 * (long)smallPower == 0L ? 0 : 1;
                this.isSmall = true;
                this.shiftedSmall = 0;
                this.knownDigitLength = new FastInteger(1);
                return;
            }
            if (this.discardedDigitCount != null) {
                this.discardedDigitCount.AddInt(digits);
            } else {
                this.discardedDigitCount = new FastInteger(digits);
            }
            this.bitLeftmost = 0;
            this.bitsAfterLeftmost |= shiftedLong == 0L ? 0 : 1;
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        this.knownDigitLength = new FastInteger(NumberUtility.DecimalDigitLength(shiftedLong));
        if (this.discardedDigitCount != null) {
            this.discardedDigitCount.AddInt(digits);
        } else {
            this.discardedDigitCount = new FastInteger(digits);
        }
        int digitsShifted = 0;
        while (digits > 0) {
            if (shiftedLong == 0L) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = 0;
                break;
            }
            long newShift = shiftedLong < 43698L ? shiftedLong * 26215L >> 18 : shiftedLong / 10L;
            int digit = (int)(shiftedLong - newShift * 10L);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = digit;
            --digits;
            ++digitsShifted;
            shiftedLong = newShift;
        }
        boolean bl = this.isSmall = shiftedLong <= Integer.MAX_VALUE;
        if (this.isSmall) {
            this.shiftedSmall = (int)shiftedLong;
        } else {
            this.shiftedBigInt = EInteger.FromInt64(shiftedLong);
        }
        this.UpdateKnownLengthInt(digitsShifted);
        this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
    }

    private void ShiftToDigitsBig(int digits, boolean truncate) {
        boolean haveKnownDigitLength;
        if (this.knownDigitLength != null && this.knownDigitLength.CompareToInt(digits) <= 0) {
            return;
        }
        FastInteger estDigitLength = this.UnderestimateDigitLength();
        boolean bl = haveKnownDigitLength = this.knownDigitLength != null;
        if (estDigitLength.CompareToInt(digits) <= 0) {
            if (!haveKnownDigitLength) {
                this.GetDigitLength();
                this.ShiftToDigitsBig(digits, truncate);
            }
            return;
        }
        FastInteger digitDiff = estDigitLength.Copy().SubtractInt(digits);
        if (truncate && digitDiff.CanFitInInt32()) {
            this.TruncateOrShiftRight(digitDiff, truncate);
            if (!haveKnownDigitLength) {
                this.GetDigitLength();
                this.ShiftToDigitsBig(digits, truncate);
            }
            return;
        }
        if (digitDiff.CompareToInt(1) == 0) {
            EInteger[] divrem = this.shiftedBigInt.DivRem(ValueTen);
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem.ToInt32Checked();
            this.shiftedBigInt = bigquo;
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.Add(digitDiff);
            int n = this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            if (!haveKnownDigitLength) {
                this.GetDigitLength();
                this.ShiftToDigitsBig(digits, truncate);
            } else {
                this.UpdateKnownLength(digitDiff);
            }
            return;
        }
        if (digitDiff.CompareToInt(9) <= 0) {
            int diffInt = digitDiff.ToInt32();
            EInteger radixPower = NumberUtility.FindPowerOfTen(diffInt);
            EInteger[] divrem = this.shiftedBigInt.DivRem(radixPower);
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            int rem = bigrem.ToInt32Checked();
            this.bitsAfterLeftmost |= this.bitLeftmost;
            for (int i = 0; i < diffInt; ++i) {
                if (i == diffInt - 1) {
                    this.bitLeftmost = rem % 10;
                    continue;
                }
                int intQuot = rem < 43698 ? rem * 26215 >> 18 : rem / 10;
                this.bitsAfterLeftmost |= rem - intQuot * 10;
                rem = intQuot;
            }
            this.shiftedBigInt = bigquo;
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.Add(digitDiff);
            int n = this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            if (!haveKnownDigitLength) {
                this.GetDigitLength();
                this.ShiftToDigitsBig(digits, truncate);
            } else {
                this.UpdateKnownLength(digitDiff);
            }
            return;
        }
        if (digitDiff.CanFitInInt32()) {
            EInteger[] divrem;
            EInteger bigquo;
            EInteger bigrem = null;
            int power = digitDiff.ToInt32() - 1;
            if (!this.shiftedBigInt.isEven() || this.bitsAfterLeftmost != 0) {
                bigquo = this.shiftedBigInt;
                this.bitsAfterLeftmost |= 1;
                bigquo = bigquo.Divide(NumberUtility.FindPowerOfTen(power));
            } else {
                EInteger radixPower = NumberUtility.FindPowerOfTen(power);
                divrem = this.shiftedBigInt.DivRem(radixPower);
                bigquo = divrem[0];
                bigrem = divrem[1];
                this.bitsAfterLeftmost |= this.bitLeftmost;
                if (!bigrem.isZero()) {
                    this.bitsAfterLeftmost |= 1;
                }
            }
            divrem = bigquo.DivRem(ValueTen);
            EInteger bigquo2 = divrem[0];
            bigrem = divrem[1];
            this.bitLeftmost = bigrem.ToInt32Checked();
            this.shiftedBigInt = bigquo2;
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.Add(digitDiff);
            int n = this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            if (!haveKnownDigitLength) {
                this.GetDigitLength();
                this.ShiftToDigitsBig(digits, truncate);
            } else {
                this.UpdateKnownLength(digitDiff);
            }
            return;
        }
        String str = this.shiftedBigInt.toString();
        int digitLength = str.length();
        this.knownDigitLength = new FastInteger(digitLength);
        if (digitLength > digits) {
            int digitShift = digitLength - digits;
            this.UpdateKnownLengthInt(digitShift);
            int newLength = digitLength - digitShift;
            FastInteger fastInteger = this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            if (digitShift <= Integer.MAX_VALUE) {
                this.discardedDigitCount.AddInt(digitShift);
            } else {
                this.discardedDigitCount.AddBig(EInteger.FromInt32(digitShift));
            }
            for (int i = str.length() - 1; i >= 0; --i) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = str.charAt(i) - 48;
                if (--digitShift <= 0) break;
            }
            if (newLength <= 9) {
                this.isSmall = true;
                this.shiftedSmall = DigitShiftAccumulator.FastParseLong(str, 0, newLength);
            } else {
                this.shiftedBigInt = EInteger.FromSubstring(str, 0, newLength);
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }

    private void ShiftToDigitsSmall(int digits) {
        int kb = 0;
        int v2 = this.shiftedSmall;
        kb = v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1))))))));
        this.knownDigitLength = new FastInteger(kb);
        if (kb > digits) {
            int digitShift = kb - digits;
            this.UpdateKnownLengthInt(digitShift);
            this.discardedDigitCount = this.discardedDigitCount != null ? this.discardedDigitCount.AddInt(digitShift) : new FastInteger(digitShift);
            for (int i = 0; i < digitShift; ++i) {
                int digit = this.shiftedSmall % 10;
                this.shiftedSmall /= 10;
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = digit;
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }

    private void TruncateRightLong(long shiftedLong, int digits) {
        if (digits <= 0) {
            return;
        }
        if (shiftedLong == 0L || digits >= 21) {
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = shiftedLong == 0L ? 0 : 1;
            this.shiftedSmall = 0;
            this.isSmall = true;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        if (digits >= 1 && digits <= TenPowersLong.length - 1) {
            if (shiftedLong >= TenPowersLong[digits]) {
                long bigPower = TenPowersLong[digits];
                if (this.discardedDigitCount != null) {
                    this.discardedDigitCount.AddInt(digits);
                } else {
                    this.discardedDigitCount = new FastInteger(digits);
                }
                long quo = shiftedLong / bigPower;
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = (shiftedLong & 1L) == 1L ? 1 : (shiftedLong - quo * bigPower == 0L ? 0 : 1);
                shiftedLong = quo;
                boolean bl = this.isSmall = shiftedLong <= Integer.MAX_VALUE;
                if (this.isSmall) {
                    this.shiftedSmall = (int)shiftedLong;
                } else {
                    this.shiftedBigInt = EInteger.FromInt64(shiftedLong);
                }
                this.UpdateKnownLengthInt(digits);
                return;
            }
            if (this.discardedDigitCount != null) {
                this.discardedDigitCount.AddInt(digits);
            } else {
                this.discardedDigitCount = new FastInteger(digits);
            }
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = shiftedLong == 0L ? 0 : 1;
            shiftedLong = 0L;
            boolean bl = this.isSmall = shiftedLong <= Integer.MAX_VALUE;
            if (this.isSmall) {
                this.shiftedSmall = (int)shiftedLong;
            } else {
                this.shiftedBigInt = EInteger.FromInt64(shiftedLong);
            }
            this.UpdateKnownLengthInt(digits);
            return;
        }
        this.ShiftRightInt(digits);
    }

    private void ShiftRightSmall(int digits) {
        if (digits <= 0) {
            return;
        }
        if (this.shiftedSmall == 0) {
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        if (digits >= 2 && digits <= 8) {
            if (this.shiftedSmall >= ValueTenPowers[digits]) {
                int rem2;
                int bigPower = ValueTenPowers[digits];
                int smallPower = ValueTenPowers[digits - 1];
                this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
                this.discardedDigitCount.AddInt(digits);
                int div = this.shiftedSmall / bigPower;
                int rem = this.shiftedSmall - div * bigPower;
                this.bitLeftmost = rem2 = rem / smallPower;
                this.bitsAfterLeftmost |= rem - rem2 * smallPower;
                this.shiftedSmall = div;
                this.knownDigitLength = div < 10 ? new FastInteger(1) : this.CalcKnownDigitLength();
                return;
            }
            if (this.shiftedSmall >= ValueTenPowers[digits - 1]) {
                int rem2;
                int smallPower = ValueTenPowers[digits - 1];
                if (this.discardedDigitCount != null) {
                    this.discardedDigitCount.AddInt(digits);
                } else {
                    this.discardedDigitCount = new FastInteger(digits);
                }
                int rem = this.shiftedSmall;
                this.bitLeftmost = rem2 = rem / smallPower;
                this.bitsAfterLeftmost |= rem - rem2 * smallPower;
                this.shiftedSmall = 0;
                this.knownDigitLength = new FastInteger(1);
                return;
            }
            if (this.discardedDigitCount != null) {
                this.discardedDigitCount.AddInt(digits);
            } else {
                this.discardedDigitCount = new FastInteger(digits);
            }
            int rem = this.shiftedSmall;
            this.bitLeftmost = 0;
            this.bitsAfterLeftmost |= rem;
            this.shiftedSmall = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        int v2 = this.shiftedSmall;
        int kb = v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1))))))));
        this.knownDigitLength = new FastInteger(kb);
        if (this.discardedDigitCount != null) {
            this.discardedDigitCount.AddInt(digits);
        } else {
            this.discardedDigitCount = new FastInteger(digits);
        }
        int digitsShifted = 0;
        while (digits > 0) {
            if (this.shiftedSmall == 0) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = 0;
                this.knownDigitLength = new FastInteger(1);
                break;
            }
            int digit = this.shiftedSmall % 10;
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = digit;
            --digits;
            ++digitsShifted;
            this.shiftedSmall /= 10;
        }
        this.UpdateKnownLengthInt(digitsShifted);
        this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
    }

    private void TruncateRightSmall(int digits) {
        if (digits <= 0) {
            return;
        }
        if (this.shiftedSmall == 0 || digits >= 11) {
            this.discardedDigitCount = this.discardedDigitCount == null ? new FastInteger(0) : this.discardedDigitCount;
            this.discardedDigitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = this.shiftedSmall == 0 ? 0 : 1;
            this.shiftedSmall = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        if (digits >= 1 && digits <= 8) {
            if (this.shiftedSmall >= ValueTenPowers[digits]) {
                int bigPower = ValueTenPowers[digits];
                if (this.discardedDigitCount != null) {
                    this.discardedDigitCount.AddInt(digits);
                } else {
                    this.discardedDigitCount = new FastInteger(digits);
                }
                this.bitsAfterLeftmost |= this.bitLeftmost;
                if ((this.shiftedSmall & 1) == 1) {
                    this.bitLeftmost = 1;
                    this.shiftedSmall /= bigPower;
                } else {
                    int quo = this.shiftedSmall / bigPower;
                    int rem = this.shiftedSmall - quo * bigPower;
                    this.shiftedSmall = quo;
                    this.bitLeftmost |= rem == 0 ? 0 : 1;
                }
                this.UpdateKnownLengthInt(digits);
                return;
            }
            if (this.discardedDigitCount != null) {
                this.discardedDigitCount.AddInt(digits);
            } else {
                this.discardedDigitCount = new FastInteger(digits);
            }
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = this.shiftedSmall == 0 ? 0 : 1;
            this.shiftedSmall = 0;
            this.knownDigitLength = new FastInteger(1);
            return;
        }
        this.ShiftRightSmall(digits);
    }
}

