/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.attributes.compiler.AttributeExpressionParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import xjavadoc.SourceClass;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XField;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;
import xjavadoc.XTag;
import xjavadoc.ant.XJavadocTask;
import xjavadoc.filesystem.AbstractFile;

public class AttributeCompiler
extends XJavadocTask {
    private final ArrayList fileSets = new ArrayList();
    private Path src;
    private File destDir;
    private int numGenerated;
    private int numIgnored;
    private String attributePackages = "";

    public void setAttributePackages(String attributePackages) {
        this.attributePackages = attributePackages;
    }

    public void addFileset(FileSet set) {
        super.addFileset(set);
        this.fileSets.add(set);
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setSourcepathref(String pathref) {
        String sourcePaths = ((ProjectComponent)this).project.getReference(pathref).toString();
        StringTokenizer tok = new StringTokenizer(sourcePaths, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            FileSet fs = new FileSet();
            fs.setDir(new File(tok.nextToken()));
            fs.setIncludes("**/*.java");
            fs.setProject(((ProjectComponent)this).project);
            this.addFileset(fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyImports(File source, PrintWriter dest) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(source));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("import ")) continue;
                dest.println(line);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            br.close();
            throw throwable;
        }
        br.close();
    }

    protected void addExpressions(Collection tags, PrintWriter pw, String collectionName, File sourceFile) {
        this.addExpressions(tags, null, pw, collectionName, sourceFile);
    }

    protected void addExpressions(Collection tags, String selector, PrintWriter pw, String collectionName, File sourceFile) {
        String fileName = sourceFile != null ? sourceFile.getPath().replace('\\', '/') : "<unknown>";
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            XTag tag = (XTag)iter.next();
            if (!this.isAttribute(tag)) continue;
            String expression = tag.getName() + " " + tag.getValue();
            expression = expression.trim();
            expression = expression.substring(1);
            if (selector != null) {
                if (!expression.startsWith(".")) continue;
                String tagSelector = expression.substring(1, expression.indexOf(" "));
                expression = expression.substring(expression.indexOf(" ")).trim();
                if (!selector.equals(tagSelector)) {
                    continue;
                }
            } else if (expression.startsWith(".")) continue;
            pw.println("        {");
            this.outputAttributeExpression(pw, expression, fileName, tag.getLineNumber(), "_attr");
            pw.println("        Object _oattr = _attr; // Need to erase type information");
            pw.println("        if (_oattr instanceof org.apache.commons.attributes.Sealable) {");
            pw.println("            ((org.apache.commons.attributes.Sealable) _oattr).seal ();");
            pw.println("        }");
            pw.println("        " + collectionName + ".add ( _attr );");
            pw.println("        }");
        }
    }

    protected void outputAttributeExpression(PrintWriter pw, String expression, String filename, int line, String tempVariableName) {
        AttributeExpressionParser.Argument arg;
        AttributeExpressionParser.ParseResult result = AttributeExpressionParser.parse(expression, filename, line);
        pw.print("            " + result.className + " " + tempVariableName + " = new " + result.className + "(");
        boolean first = true;
        Iterator iter = result.arguments.iterator();
        while (iter.hasNext()) {
            arg = (AttributeExpressionParser.Argument)iter.next();
            if (arg.field != null) continue;
            if (!first) {
                pw.print(", ");
            }
            first = false;
            pw.print(arg.text);
        }
        pw.println("  // " + filename + ":" + line);
        pw.println(");");
        iter = result.arguments.iterator();
        while (iter.hasNext()) {
            arg = (AttributeExpressionParser.Argument)iter.next();
            if (arg.field == null) continue;
            String methodName = "set" + arg.field.substring(0, 1).toUpperCase() + arg.field.substring(1);
            pw.println("            " + tempVariableName + "." + methodName + "(\n" + arg.text + "  // " + filename + ":" + line + "\n" + ");");
        }
    }

    protected boolean elementHasAttributes(Collection xElements) {
        Iterator iter = xElements.iterator();
        while (iter.hasNext()) {
            XProgramElement element = (XProgramElement)iter.next();
            if (!this.tagHasAttributes(element.getDoc().getTags())) continue;
            return true;
        }
        return false;
    }

    private void getTransformedQualifiedName(XClass type, StringBuffer sb) {
        if (type.isInner()) {
            String packageName = type.getContainingPackage().getName();
            sb.append(packageName);
            if (packageName.length() > 0) {
                sb.append(".");
            }
            sb.append(type.getName().replace('.', '$'));
        } else {
            sb.append(type.getQualifiedName());
        }
    }

    protected String getParameterTypes(Collection parameters) {
        StringBuffer sb = new StringBuffer();
        Iterator params = parameters.iterator();
        while (params.hasNext()) {
            XParameter parameter = (XParameter)params.next();
            this.getTransformedQualifiedName(parameter.getType(), sb);
            sb.append(parameter.getDimensionAsString());
            if (!params.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected void generateClass(XClass xClass) throws Exception {
        String name = null;
        File sourceFile = null;
        File destFile = null;
        String packageName = null;
        String className = null;
        packageName = xClass.getContainingPackage().getName();
        if (xClass.isInner()) {
            name = xClass.getQualifiedName().substring(packageName.length());
            sourceFile = this.getSourceFile(xClass);
            className = xClass.getName().replace('.', '$');
            name = packageName + (packageName.length() > 0 ? "." : "") + className;
        } else {
            name = xClass.getQualifiedName();
            sourceFile = this.getSourceFile(xClass);
            className = xClass.getName();
        }
        if (sourceFile == null) {
            this.log("Unable to find source file for: " + name);
        }
        destFile = new File(this.destDir, name.replace('.', '/') + "$__attributeRepository.java");
        if (xClass.isAnonymous()) {
            this.log(xClass.getName() + " is anonymous - ignoring.", 3);
            ++this.numIgnored;
            return;
        }
        if (!this.hasAttributes(xClass)) {
            if (destFile.exists()) {
                destFile.delete();
            }
            return;
        }
        if (destFile.exists() && sourceFile != null && destFile.lastModified() >= sourceFile.lastModified()) {
            return;
        }
        ++this.numGenerated;
        destFile.getParentFile().mkdirs();
        PrintWriter pw = new PrintWriter(new FileWriter(destFile));
        try {
            if (packageName != null && !packageName.equals("")) {
                pw.println("package " + packageName + ";");
            }
            if (sourceFile != null) {
                this.copyImports(sourceFile, pw);
            }
            StringTokenizer tok = new StringTokenizer(this.attributePackages, ";");
            while (tok.hasMoreTokens()) {
                pw.println("import " + tok.nextToken() + ".*;");
            }
            pw.println("public class " + className + "$__attributeRepository implements org.apache.commons.attributes.AttributeRepositoryClass {");
            pw.println("    private final java.util.Set classAttributes = new java.util.HashSet ();");
            pw.println("    private final java.util.Map fieldAttributes = new java.util.HashMap ();");
            pw.println("    private final java.util.Map methodAttributes = new java.util.HashMap ();");
            pw.println("    private final java.util.Map constructorAttributes = new java.util.HashMap ();");
            pw.println();
            pw.println("    public " + className + "$__attributeRepository " + "() {");
            pw.println("        initClassAttributes ();");
            pw.println("        initMethodAttributes ();");
            pw.println("        initFieldAttributes ();");
            pw.println("        initConstructorAttributes ();");
            pw.println("    }");
            pw.println();
            pw.println("    public java.util.Set getClassAttributes () { return classAttributes; }");
            pw.println("    public java.util.Map getFieldAttributes () { return fieldAttributes; }");
            pw.println("    public java.util.Map getConstructorAttributes () { return constructorAttributes; }");
            pw.println("    public java.util.Map getMethodAttributes () { return methodAttributes; }");
            pw.println();
            pw.println("    private void initClassAttributes () {");
            this.addExpressions(xClass.getDoc().getTags(), pw, "classAttributes", sourceFile);
            pw.println("    }");
            pw.println();
            pw.println("    private void initFieldAttributes () {");
            pw.println("        java.util.Set attrs = null;");
            Iterator iter = xClass.getFields().iterator();
            while (iter.hasNext()) {
                XField member = (XField)iter.next();
                if (member.getDoc().getTags().size() <= 0) continue;
                String key = member.getName();
                pw.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(member.getDoc().getTags(), pw, "attrs", sourceFile);
                pw.println("        fieldAttributes.put (\"" + key + "\", attrs);");
                pw.println("        attrs = null;");
                pw.println();
            }
            pw.println("    }");
            pw.println("    private void initMethodAttributes () {");
            pw.println("        java.util.Set attrs = null;");
            pw.println("        java.util.List bundle = null;");
            Iterator iter2 = xClass.getMethods().iterator();
            while (iter2.hasNext()) {
                XMethod member = (XMethod)iter2.next();
                if (member.getDoc().getTags().size() <= 0) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(member.getName()).append("(");
                sb.append(this.getParameterTypes(member.getParameters()));
                sb.append(")");
                String key = sb.toString();
                pw.println("        bundle = new java.util.ArrayList ();");
                pw.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(member.getDoc().getTags(), null, pw, "attrs", sourceFile);
                pw.println("        bundle.add (attrs);");
                pw.println("        attrs = null;");
                pw.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(member.getDoc().getTags(), "return", pw, "attrs", sourceFile);
                pw.println("        bundle.add (attrs);");
                pw.println("        attrs = null;");
                Iterator parameters = member.getParameters().iterator();
                while (parameters.hasNext()) {
                    XParameter parameter = (XParameter)parameters.next();
                    pw.println("        attrs = new java.util.HashSet ();");
                    this.addExpressions(member.getDoc().getTags(), parameter.getName(), pw, "attrs", sourceFile);
                    pw.println("        bundle.add (attrs);");
                    pw.println("        attrs = null;");
                }
                pw.println("        methodAttributes.put (\"" + key + "\", bundle);");
                pw.println("        bundle = null;");
                pw.println();
            }
            pw.println("    }");
            pw.println("    private void initConstructorAttributes () {");
            pw.println("        java.util.Set attrs = null;");
            pw.println("        java.util.List bundle = null;");
            Iterator iter3 = xClass.getConstructors().iterator();
            while (iter3.hasNext()) {
                XConstructor member = (XConstructor)iter3.next();
                if (member.getDoc().getTags().size() <= 0) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("(");
                sb.append(this.getParameterTypes(member.getParameters()));
                sb.append(")");
                String key = sb.toString();
                pw.println("        bundle = new java.util.ArrayList ();");
                pw.println("        attrs = new java.util.HashSet ();");
                this.addExpressions(member.getDoc().getTags(), null, pw, "attrs", sourceFile);
                pw.println("        bundle.add (attrs);");
                pw.println("        attrs = null;");
                Iterator parameters = member.getParameters().iterator();
                while (parameters.hasNext()) {
                    XParameter parameter = (XParameter)parameters.next();
                    pw.println("        attrs = new java.util.HashSet ();");
                    this.addExpressions(member.getDoc().getTags(), parameter.getName(), pw, "attrs", sourceFile);
                    pw.println("        bundle.add (attrs);");
                    pw.println("        attrs = null;");
                }
                pw.println("        constructorAttributes.put (\"" + key + "\", bundle);");
                pw.println("        bundle = null;");
                pw.println();
            }
            pw.println("    }");
            pw.println("}");
            pw.close();
        }
        catch (Exception e) {
            pw.close();
            destFile.delete();
            throw e;
        }
    }

    protected File getSourceFile(XClass xClass) throws BuildException {
        while (xClass != null && xClass.isInner()) {
            xClass = xClass.getContainingClass();
        }
        if (xClass != null && xClass instanceof SourceClass) {
            AbstractFile af = ((SourceClass)xClass).getFile();
            return new File(af.getPath());
        }
        return null;
    }

    protected boolean hasAttributes(XClass xClass) {
        return this.tagHasAttributes(xClass.getDoc().getTags()) || this.elementHasAttributes(xClass.getFields()) || this.elementHasAttributes(xClass.getMethods()) || this.elementHasAttributes(xClass.getConstructors());
    }

    protected boolean isAttribute(XTag tag) {
        return tag.getName().length() > 0 && tag.getName().charAt(0) == '@';
    }

    protected void start() throws BuildException {
        this.destDir.mkdirs();
        this.numGenerated = 0;
        XJavaDoc doc = this.getXJavaDoc();
        Iterator iter = doc.getSourceClasses().iterator();
        try {
            while (iter.hasNext()) {
                XClass xClass = (XClass)iter.next();
                this.generateClass(xClass);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e);
        }
        this.log("Generated attribute information for " + this.numGenerated + " classes. Ignored " + this.numIgnored + " classes.");
    }

    protected boolean tagHasAttributes(Collection tags) {
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            XTag tag = (XTag)iter.next();
            if (!this.isAttribute(tag)) continue;
            return true;
        }
        return false;
    }
}

