/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.provisioning.api.rules.AccountRule;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.provisioning.api.rules.RuleEnforcer;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DefaultRuleEnforcer
implements RuleEnforcer {
    protected static final Logger LOG = LoggerFactory.getLogger(RuleEnforcer.class);
    protected final RealmDAO realmDAO;
    protected final Map<String, AccountRule> perContextAccountRules = new ConcurrentHashMap<String, AccountRule>();
    protected final Map<String, PasswordRule> perContextPasswordRules = new ConcurrentHashMap<String, PasswordRule>();

    public DefaultRuleEnforcer(RealmDAO realmDAO) {
        this.realmDAO = realmDAO;
    }

    @Transactional(readOnly=true)
    public List<AccountPolicy> getAccountPolicies(Realm realm, Collection<ExternalResource> resources) {
        ArrayList<AccountPolicy> policies = new ArrayList<AccountPolicy>();
        resources.forEach(resource -> Optional.ofNullable(resource.getAccountPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        if (realm != null) {
            this.realmDAO.findAncestors(realm).forEach(r -> Optional.ofNullable(r.getAccountPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        }
        return policies;
    }

    @Transactional(readOnly=true)
    public List<AccountRule> getAccountRules(AccountPolicy policy) {
        ArrayList<AccountRule> result = new ArrayList<AccountRule>();
        for (Implementation impl : policy.getRules()) {
            try {
                ImplementationManager.buildAccountRule(impl, () -> this.perContextAccountRules.get(impl.getKey()), instance -> this.perContextAccountRules.put(impl.getKey(), (AccountRule)instance)).ifPresent(result::add);
            }
            catch (Exception e) {
                LOG.warn("While building {}", (Object)impl, (Object)e);
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<PasswordPolicy> getPasswordPolicies(Realm realm, Collection<ExternalResource> resources) {
        ArrayList<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
        resources.forEach(resource -> Optional.ofNullable(resource.getPasswordPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        if (realm != null) {
            this.realmDAO.findAncestors(realm).forEach(r -> Optional.ofNullable(r.getPasswordPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        }
        return policies;
    }

    @Transactional(readOnly=true)
    public List<PasswordRule> getPasswordRules(PasswordPolicy policy) {
        ArrayList<PasswordRule> result = new ArrayList<PasswordRule>();
        for (Implementation impl : policy.getRules()) {
            try {
                ImplementationManager.buildPasswordRule(impl, () -> this.perContextPasswordRules.get(impl.getKey()), instance -> this.perContextPasswordRules.put(impl.getKey(), (PasswordRule)instance)).ifPresent(result::add);
            }
            catch (Exception e) {
                LOG.warn("While building {}", (Object)impl, (Object)e);
            }
        }
        return result;
    }
}

