/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.table;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import net.tirasa.connid.bundles.db.commons.DatabaseConnection;
import net.tirasa.connid.bundles.db.commons.DatabaseQueryBuilder;
import net.tirasa.connid.bundles.db.commons.FilterWhereBuilder;
import net.tirasa.connid.bundles.db.commons.InsertIntoBuilder;
import net.tirasa.connid.bundles.db.commons.OperationBuilder;
import net.tirasa.connid.bundles.db.commons.SQLParam;
import net.tirasa.connid.bundles.db.commons.SQLUtil;
import net.tirasa.connid.bundles.db.commons.UpdateSetBuilder;
import net.tirasa.connid.bundles.db.table.DatabaseTableConfiguration;
import net.tirasa.connid.bundles.db.table.DatabaseTableConnection;
import net.tirasa.connid.bundles.db.table.DatabaseTableFilterTranslator;
import net.tirasa.connid.bundles.db.table.security.EncodeAlgorithm;
import net.tirasa.connid.bundles.db.table.security.PasswordDecodingException;
import net.tirasa.connid.bundles.db.table.security.PasswordEncodingException;
import net.tirasa.connid.bundles.db.table.security.SupportedAlgorithm;
import net.tirasa.connid.bundles.db.table.security.UnsupportedPasswordCharsetException;
import net.tirasa.connid.bundles.db.table.util.DatabaseTableSQLUtil;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="DBTABLE_CONNECTOR", configurationClass=DatabaseTableConfiguration.class)
public class DatabaseTableConnector
implements PoolableConnector,
CreateOp,
SearchOp<FilterWhereBuilder>,
DeleteOp,
UpdateOp,
SchemaOp,
TestOp,
AuthenticateOp,
SyncOp,
ResolveUsernameOp {
    private static final Log LOG = Log.getLog(DatabaseTableConnector.class);
    private static final String HASHED_PASSWORD_ATTRIBUTE = AttributeUtil.createSpecialName((String)"HASHED_PASSWORD");
    private DatabaseTableConnection conn;
    private DatabaseTableConfiguration config;
    private Schema schema;
    private Set<String> defaultAttributesToGet;
    private Map<String, Integer> columnSQLTypes;
    private Set<String> stringColumnRequired;

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        LOG.info("init DatabaseTable connector", new Object[0]);
        this.config = (DatabaseTableConfiguration)cfg;
        this.schema = null;
        this.defaultAttributesToGet = null;
        this.columnSQLTypes = null;
        LOG.ok("init DatabaseTable connector ok, connection is valid", new Object[0]);
    }

    public void checkAlive() {
        LOG.info("checkAlive DatabaseTable connector", new Object[0]);
        try {
            if (StringUtil.isNotBlank((String)this.config.getDatasource())) {
                this.openConnection();
            } else {
                this.getConn().test();
                this.commit();
            }
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "error in checkAlive", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        LOG.ok("checkAlive DatabaseTable connector ok", new Object[0]);
    }

    protected DatabaseTableConnection getConn() {
        if (this.conn == null) {
            this.config.validate();
            this.conn = DatabaseTableConnection.createDBTableConnection(this.config);
        }
        return this.conn;
    }

    public void dispose() {
        LOG.info("dispose DatabaseTable connector", new Object[0]);
        if (this.conn != null) {
            this.conn.dispose();
            this.conn = null;
        }
        this.defaultAttributesToGet = null;
        this.schema = null;
        this.columnSQLTypes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        Attribute enabled;
        LOG.info("create account, check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("Object class ok", new Object[0]);
        if (attrs == null || attrs.isEmpty()) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
        }
        LOG.ok("Attribute set is not empty", new Object[0]);
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name == null) {
            throw new IllegalArgumentException(this.config.getMessage("name.blank"));
        }
        String accountName = name.getNameValue();
        LOG.ok("Required Name attribure value {0} for create", new Object[]{accountName});
        String tblname = this.config.getTable();
        InsertIntoBuilder bld = new InsertIntoBuilder();
        LOG.info("Creating account: {0}", new Object[]{accountName});
        SortedSet missingRequiredColumns = CollectionUtil.newCaseInsensitiveSet();
        if (this.config.isEnableEmptyString()) {
            Set<String> mrc = this.getStringColumnReguired();
            LOG.info("Add missing required columns {0}", new Object[]{mrc});
            missingRequiredColumns.addAll(mrc);
        }
        LOG.info("process and check the Attribute Set", new Object[0]);
        HashSet<Attribute> attrToBeProcessed = new HashSet<Attribute>(attrs);
        if (StringUtil.isNotBlank((String)this.config.getStatusColumn()) && (enabled = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, attrToBeProcessed)) == null) {
            attrToBeProcessed.add(AttributeBuilder.build((String)OperationalAttributes.ENABLE_NAME, (Object[])new Object[]{this.isEnabled(this.config.getDefaultStatusValue())}));
        }
        boolean hashedPassword = false;
        Attribute hashedPasswordAttribute = AttributeUtil.find((String)HASHED_PASSWORD_ATTRIBUTE, attrToBeProcessed);
        if (hashedPasswordAttribute != null && hashedPasswordAttribute.getValue() != null && !hashedPasswordAttribute.getValue().isEmpty() && hashedPasswordAttribute.getValue().get(0) instanceof Boolean) {
            hashedPassword = (Boolean)hashedPasswordAttribute.getValue().get(0);
            attrToBeProcessed.remove(hashedPasswordAttribute);
        }
        for (Attribute attr : attrToBeProcessed) {
            if (attr.getName().equals(this.config.getKeyColumn())) continue;
            String columnName = this.getColumnName(attr.getName());
            if (StringUtil.isNotBlank((String)columnName)) {
                this.handleAttribute(bld, attr, hashedPassword, columnName);
                missingRequiredColumns.remove(columnName);
                LOG.ok("Attribute {0} was added to insert", new Object[]{attr.getName()});
                continue;
            }
            LOG.ok("Attribute {0} ignored. Missing internal mapping", new Object[]{attr.getName()});
        }
        if (this.config.isEnableEmptyString()) {
            LOG.info("Some columns should be empty", new Object[0]);
            for (String mCol : missingRequiredColumns) {
                bld.addBind(new SQLParam(this.quoteName(mCol), (Object)"", this.getColumnType(mCol)));
                LOG.ok("Required empty value to column {0} added", new Object[]{mCol});
            }
        }
        String SQL_INSERT = "INSERT INTO {0} ( {1} ) VALUES ( {2} )";
        String sql = MessageFormat.format("INSERT INTO {0} ( {1} ) VALUES ( {2} )", tblname, bld.getInto(), bld.getValues());
        PreparedStatement pstmt = null;
        try {
            this.openConnection();
            pstmt = this.getConn().prepareStatement(sql, bld.getParams());
            pstmt.execute();
            LOG.info("Create account {0} commit", new Object[]{accountName});
            this.commit();
        }
        catch (SQLException e) {
            block14: {
                try {
                    LOG.error((Throwable)e, "Create account ''{0}'' error", new Object[]{accountName});
                    if (!this.throwIt(e.getErrorCode())) break block14;
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    throw new ConnectorException(this.config.getMessage("can.not.create", accountName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(pstmt);
                    this.closeConnection();
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((Statement)pstmt);
            this.closeConnection();
        }
        SQLUtil.closeQuietly((Statement)pstmt);
        this.closeConnection();
        LOG.ok("Account {0} created", new Object[]{accountName});
        return new Uid(accountName);
    }

    private boolean throwIt(int errorCode) {
        return this.config.isRethrowAllSQLExceptions() || errorCode != 0;
    }

    private boolean isToBeEmpty(String columnName, Object value) {
        return this.config.isEnableEmptyString() && this.getStringColumnReguired().contains(columnName) && value == null;
    }

    public void delete(ObjectClass oclass, Uid uid, OperationOptions options) {
        LOG.info("delete account, check the ObjectClass", new Object[0]);
        String SQL_DELETE = "DELETE FROM {0} WHERE {1} = ?";
        PreparedStatement stmt = null;
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        if (uid == null || uid.getUidValue() == null) {
            throw new IllegalArgumentException(this.config.getMessage("uid.blank"));
        }
        String accountUid = uid.getUidValue();
        LOG.ok("The Uid is present", new Object[0]);
        String tblname = this.config.getTable();
        String keycol = this.quoteName(this.config.getKeyColumn());
        String sql = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", tblname, keycol);
        try {
            LOG.info("delete account SQL {0}", new Object[]{sql});
            this.openConnection();
            stmt = this.getConn().getConnection().prepareStatement(sql);
            stmt.setString(1, accountUid);
            LOG.info("Deleting account Uid: {0}", new Object[]{accountUid});
            int dr = stmt.executeUpdate();
            if (dr < 1) {
                LOG.error("No account Uid: {0} found", new Object[]{accountUid});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new UnknownUidException();
            }
            if (dr > 1) {
                LOG.error("More then one account Uid: {0} found", new Object[]{accountUid});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new IllegalArgumentException(this.config.getMessage("more.users.deleted", accountUid));
            }
            LOG.info("Delete account {0} commit", new Object[]{accountUid});
            this.commit();
        }
        catch (SQLException e) {
            try {
                LOG.error((Throwable)e, "Delete account ''{0}'' SQL error", new Object[]{accountUid});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.delete", accountUid), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(stmt);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        LOG.ok("Account Uid {0} deleted", new Object[]{accountUid});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uid update(ObjectClass oclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        LOG.info("update account, check the ObjectClass", new Object[0]);
        String SQL_TEMPLATE = "UPDATE {0} SET {1} WHERE {2} = ?";
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        if (attrs == null || attrs.isEmpty()) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.attribute.set"));
        }
        LOG.ok("Attribute set is not empty", new Object[0]);
        String accountUid = uid.getUidValue();
        Assertions.nullCheck((Object)accountUid, (String)"accountUid");
        LOG.ok("Account uid {0} is present", new Object[]{accountUid});
        boolean hashedPassword = false;
        Attribute hashedPasswordAttribute = AttributeUtil.find((String)HASHED_PASSWORD_ATTRIBUTE, attrs);
        if (hashedPasswordAttribute != null && hashedPasswordAttribute.getValue() != null && !hashedPasswordAttribute.getValue().isEmpty() && hashedPasswordAttribute.getValue().get(0) instanceof Boolean) {
            hashedPassword = (Boolean)hashedPasswordAttribute.getValue().get(0);
            attrs.remove(hashedPasswordAttribute);
        }
        Uid ret = uid;
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        String accountName = accountUid;
        if (name != null && !accountUid.equals(name.getNameValue())) {
            accountName = name.getNameValue();
            Assertions.nullCheck((Object)accountName, (String)"accountName");
            LOG.info("Account name {0} is present and is not the same as uid", new Object[]{accountName});
            ret = new Uid(accountName);
            LOG.ok("Renaming account uid {0} to name {1}", new Object[]{accountUid, accountName});
        }
        LOG.info("process and check the Attribute Set", new Object[0]);
        UpdateSetBuilder updateSet = new UpdateSetBuilder();
        for (Attribute attr : attrs) {
            if (attr.is(Uid.NAME) || attr.getName().equals(this.config.getKeyColumn())) continue;
            String attributeName = attr.getName();
            String columnName = this.getColumnName(attributeName);
            if (StringUtil.isNotBlank((String)columnName)) {
                this.handleAttribute(updateSet, attr, hashedPassword, columnName);
                LOG.ok("Attribute {0} was added to update", new Object[]{attr.getName()});
                continue;
            }
            LOG.ok("Attribute {0} ignored. Missing internal mapping", new Object[]{attr.getName()});
        }
        LOG.info("Update account {1}", new Object[]{accountName});
        String tblname = this.config.getTable();
        String keycol = this.quoteName(this.config.getKeyColumn());
        updateSet.addValue(new SQLParam(keycol, (Object)accountUid, this.getColumnType(this.config.getKeyColumn())));
        String sql = MessageFormat.format("UPDATE {0} SET {1} WHERE {2} = ?", tblname, updateSet.getSQL(), keycol);
        PreparedStatement stmt = null;
        try {
            this.openConnection();
            stmt = this.getConn().prepareStatement(sql, updateSet.getParams());
            stmt.executeUpdate();
            LOG.info("Update account {0} commit", new Object[]{accountName});
            this.commit();
        }
        catch (SQLException e) {
            block10: {
                try {
                    LOG.error((Throwable)e, "Update account {0} error", new Object[]{accountName});
                    if (!this.throwIt(e.getErrorCode())) break block10;
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    throw new ConnectorException(this.config.getMessage("can.not.update", accountName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(stmt);
                    this.closeConnection();
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((Statement)stmt);
            this.closeConnection();
        }
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        LOG.ok("Account {0} updated", new Object[]{accountName});
        return ret;
    }

    public FilterTranslator<FilterWhereBuilder> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        LOG.info("check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        return new DatabaseTableFilterTranslator(this, oclass, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(ObjectClass oclass, FilterWhereBuilder where, ResultsHandler handler, OperationOptions options) {
        LOG.info("check the ObjectClass and result handler", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(this.config.getMessage("result.handler.null"));
        }
        LOG.ok("The ObjectClass and result handler is ok", new Object[0]);
        String tblname = this.config.getTable();
        Set<String> columnNamesToGet = this.resolveColumnNamesToGet(options);
        LOG.ok("Column Names {0} To Get", new Object[]{columnNamesToGet});
        DatabaseQueryBuilder query = new DatabaseQueryBuilder(tblname, columnNamesToGet);
        query.setWhere(where);
        ResultSet result = null;
        PreparedStatement statement = null;
        try {
            this.openConnection();
            statement = this.getConn().prepareStatement(query);
            result = statement.executeQuery();
            LOG.ok("executeQuery {0} on {1}", new Object[]{query.getSQL(), oclass});
            while (result.next()) {
                Map<String, SQLParam> columnValues = this.getConn().getColumnValues(result);
                LOG.ok("Column values {0} from result set ", new Object[]{columnValues});
                ConnectorObjectBuilder bld = this.buildConnectorObject(columnValues);
                if (handler.handle(bld.build())) continue;
                LOG.ok("Stop processing of the result set", new Object[0]);
                break;
            }
            LOG.info("commit executeQuery account", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            block7: {
                try {
                    LOG.error((Throwable)e, "Query {0} on {1} error", new Object[]{query.getSQL(), oclass});
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    if (!this.throwIt(e.getErrorCode())) break block7;
                    throw new ConnectorException(this.config.getMessage("can.not.read", tblname), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(result);
                    SQLUtil.closeQuietly(statement);
                    this.closeConnection();
                    throw throwable;
                }
            }
            SQLUtil.closeQuietly((ResultSet)result);
            SQLUtil.closeQuietly((Statement)statement);
            this.closeConnection();
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)statement);
        this.closeConnection();
        LOG.ok("Query Account commited", new Object[0]);
    }

    public void sync(ObjectClass oclass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        LOG.info("check the ObjectClass and result handler", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("The object class is ok", new Object[0]);
        if (handler == null) {
            throw new IllegalArgumentException(this.config.getMessage("result.handler.null"));
        }
        LOG.ok("The result handles is not null", new Object[0]);
        if (StringUtil.isBlank((String)this.config.getChangeLogColumn())) {
            throw new IllegalArgumentException(this.config.getMessage("changelog.column.blank"));
        }
        LOG.ok("The change log column is ok", new Object[0]);
        String tblname = this.config.getTable();
        String changeLogColumnName = this.quoteName(this.config.getChangeLogColumn());
        LOG.ok("Change log attribute {0} map to column name {1}", new Object[]{this.config.getChangeLogColumn(), changeLogColumnName});
        Set<String> columnNames = this.resolveColumnNamesToGet(options);
        LOG.ok("Column Names {0} To Get", new Object[]{columnNames});
        ArrayList<DatabaseQueryBuilder.OrderBy> orderBy = new ArrayList<DatabaseQueryBuilder.OrderBy>();
        columnNames.add(changeLogColumnName);
        orderBy.add(new DatabaseQueryBuilder.OrderBy(changeLogColumnName, Boolean.valueOf(true)));
        LOG.ok("OrderBy {0}", new Object[]{orderBy});
        FilterWhereBuilder where = new FilterWhereBuilder();
        if (token != null && token.getValue() != null) {
            Object tokenVal;
            LOG.info("Sync token is {0}", new Object[]{token.getValue()});
            Integer sqlType = this.getColumnType(this.config.getChangeLogColumn());
            try {
                tokenVal = SQLUtil.attribute2jdbcValue((Object)token.getValue().toString(), (int)sqlType);
            }
            catch (Exception e) {
                tokenVal = token.getValue();
            }
            where.addBind(new SQLParam(changeLogColumnName, tokenVal, sqlType.intValue()), ">", false);
        }
        DatabaseQueryBuilder query = new DatabaseQueryBuilder(tblname, columnNames);
        query.setWhere(where);
        query.setOrderBy(orderBy);
        ResultSet result = null;
        PreparedStatement statement = null;
        try {
            this.openConnection();
            statement = this.getConn().prepareStatement(query);
            result = statement.executeQuery();
            LOG.info("execute sync query {0} on {1}", new Object[]{query.getSQL(), oclass});
            while (result.next()) {
                Map<String, SQLParam> columnValues = this.getConn().getColumnValues(result);
                LOG.ok("Column values {0} from sync result set ", new Object[]{columnValues});
                SyncDeltaBuilder sdb = this.buildSyncDelta(columnValues);
                if (handler.handle(sdb.build())) continue;
                LOG.ok("Stop processing of the sync result set", new Object[0]);
                break;
            }
            LOG.info("commit sync account", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            try {
                LOG.error((Throwable)e, "sync {0} on {1} error", new Object[]{query.getSQL(), oclass});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", tblname), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(statement);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)statement);
        this.closeConnection();
        LOG.ok("Sync Account commited", new Object[0]);
    }

    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        ResultSet rset;
        PreparedStatement stmt;
        SyncToken ret;
        block11: {
            LOG.info("check the ObjectClass", new Object[0]);
            if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
                throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
            }
            LOG.ok("The object class is ok", new Object[0]);
            if (StringUtil.isBlank((String)this.config.getChangeLogColumn())) {
                throw new IllegalArgumentException(this.config.getMessage("changelog.column.blank"));
            }
            LOG.ok("The change log column is ok", new Object[0]);
            String SQL_SELECT = "SELECT MAX( {0} ) FROM {1}";
            String tblname = this.config.getTable();
            String chlogName = this.quoteName(this.config.getChangeLogColumn());
            String sql = MessageFormat.format("SELECT MAX( {0} ) FROM {1}", chlogName, tblname);
            ret = null;
            LOG.info("getLatestSyncToken on {0}", new Object[]{oclass});
            stmt = null;
            rset = null;
            try {
                this.openConnection();
                stmt = this.getConn().getConnection().prepareStatement(sql);
                rset = stmt.executeQuery();
                LOG.ok("The statement {0} executed", new Object[]{sql});
                if (!rset.next()) break block11;
                if (rset.getString(1) != null) {
                    boolean isDate;
                    String value = rset.getString(1);
                    LOG.ok("New token value {0}", new Object[]{value});
                    int sqlType = this.getColumnType(chlogName);
                    boolean bl = isDate = sqlType == 91 || sqlType == 93 || sqlType == 92;
                    if (isDate) {
                        ret = new SyncToken(SQLUtil.jdbc2AttributeValue((Object)DatabaseTableSQLUtil.tsAsLong(value)));
                    } else {
                        try {
                            ret = new SyncToken(SQLUtil.jdbc2AttributeValue((Object)Long.valueOf(value)));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.warn((Throwable)nfe, "Invalid token value {0}", new Object[]{rset.getString(1)});
                        }
                    }
                }
                LOG.ok("getLatestSyncToken", new Object[]{ret});
                LOG.info("commit getLatestSyncToken", new Object[0]);
                this.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Throwable)e, "getLatestSyncToken sql {0} on {1} error", new Object[]{sql, oclass});
                    SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                    throw new ConnectorException(this.config.getMessage("can.not.read", tblname), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtil.closeQuietly(rset);
                    SQLUtil.closeQuietly(stmt);
                    this.closeConnection();
                    throw throwable;
                }
            }
        }
        SQLUtil.closeQuietly((ResultSet)rset);
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        LOG.ok("getLatestSyncToken commited", new Object[0]);
        return ret;
    }

    public Schema schema() {
        try {
            this.openConnection();
            if (this.schema == null) {
                LOG.info("cache schema", new Object[0]);
                this.cacheSchema();
            }
            assert (this.schema != null);
            this.commit();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "error in schema", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        LOG.ok("schema", new Object[0]);
        return this.schema;
    }

    public void test() {
        LOG.info("test", new Object[0]);
        try {
            this.openConnection();
            this.getConn().test();
            this.commit();
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "error in test", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        LOG.ok("connector test ok", new Object[0]);
    }

    private void closeConnection() {
        this.getConn().closeConnection();
    }

    private void openConnection() throws SQLException {
        this.getConn().openConnection();
    }

    private void commit() throws SQLException {
        this.getConn().getConnection().commit();
    }

    public Uid authenticate(ObjectClass oclass, String username, GuardedString password, OperationOptions options) {
        GuardedString encodedPwd;
        String SQL_AUTH_QUERY = "SELECT {0} FROM {1} WHERE ( {0} = ? ) AND ( {2} = ? )";
        LOG.info("check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("The object class is ok", new Object[0]);
        if (StringUtil.isBlank((String)this.config.getPasswordColumn())) {
            throw new UnsupportedOperationException(this.config.getMessage("auth.op.not.supported"));
        }
        LOG.ok("The Password Column is ok", new Object[0]);
        if (StringUtil.isBlank((String)username)) {
            throw new IllegalArgumentException(this.config.getMessage("admin.user.blank"));
        }
        LOG.ok("The username is ok", new Object[0]);
        if (password == null) {
            throw new IllegalArgumentException(this.config.getMessage("admin.password.blank"));
        }
        LOG.ok("The password is ok", new Object[0]);
        try {
            encodedPwd = this.encodePassword(password);
        }
        catch (PasswordEncodingException e) {
            LOG.error((Throwable)e, "Error encoding provided password", new Object[0]);
            encodedPwd = password;
        }
        String keyColumnName = this.quoteName(this.config.getKeyColumn());
        String passwordColumnName = this.quoteName(this.config.getPasswordColumn());
        String sql = MessageFormat.format("SELECT {0} FROM {1} WHERE ( {0} = ? ) AND ( {2} = ? )", keyColumnName, this.config.getTable(), passwordColumnName);
        ArrayList<SQLParam> values = new ArrayList<SQLParam>();
        values.add(new SQLParam(keyColumnName, (Object)username, this.getColumnType(this.config.getKeyColumn())));
        values.add(new SQLParam(passwordColumnName, (Object)encodedPwd));
        PreparedStatement stmt = null;
        ResultSet result = null;
        Uid uid = null;
        try {
            LOG.info("authenticate Account: {0}", new Object[]{username});
            this.openConnection();
            stmt = this.getConn().prepareStatement(sql, values);
            result = stmt.executeQuery();
            LOG.ok("authenticate query for account {0} executed ", new Object[]{username});
            if (!result.next()) {
                LOG.error("authenticate query for account {0} has no result ", new Object[]{username});
                throw new InvalidCredentialException(this.config.getMessage("auth.op.failed", username));
            }
            uid = new Uid(result.getString(1));
            LOG.info("commit authenticate", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            try {
                LOG.error((Throwable)e, "Account: {0} authentication failed ", new Object[]{username});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", this.config.getTable()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(stmt);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        LOG.info("Account: {0} authenticated ", new Object[]{username});
        return uid;
    }

    public Uid resolveUsername(ObjectClass oclass, String username, OperationOptions options) {
        String SQL_AUTH_QUERY = "SELECT {0} FROM {1} WHERE ( {0} = ? )";
        LOG.info("check the ObjectClass", new Object[0]);
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException(this.config.getMessage("acount.object.class.required"));
        }
        LOG.ok("The object class is ok", new Object[0]);
        if (StringUtil.isBlank((String)this.config.getPasswordColumn())) {
            throw new UnsupportedOperationException(this.config.getMessage("auth.op.not.supported"));
        }
        LOG.ok("The Password Column is ok", new Object[0]);
        if (StringUtil.isBlank((String)username)) {
            throw new IllegalArgumentException(this.config.getMessage("admin.user.blank"));
        }
        LOG.ok("The username is ok", new Object[0]);
        String keyColumnName = this.quoteName(this.config.getKeyColumn());
        String passwordColumnName = this.quoteName(this.config.getPasswordColumn());
        String sql = MessageFormat.format("SELECT {0} FROM {1} WHERE ( {0} = ? )", keyColumnName, this.config.getTable(), passwordColumnName);
        ArrayList<SQLParam> values = new ArrayList<SQLParam>();
        values.add(new SQLParam(keyColumnName, (Object)username, this.getColumnType(this.config.getKeyColumn())));
        PreparedStatement stmt = null;
        ResultSet result = null;
        Uid uid = null;
        try {
            LOG.info("authenticate Account: {0}", new Object[]{username});
            this.openConnection();
            stmt = this.getConn().prepareStatement(sql, values);
            result = stmt.executeQuery();
            LOG.ok("authenticate query for account {0} executed ", new Object[]{username});
            if (!result.next()) {
                LOG.error("authenticate query for account {0} has no result ", new Object[]{username});
                throw new InvalidCredentialException(this.config.getMessage("auth.op.failed", username));
            }
            uid = new Uid(result.getString(1));
            LOG.info("commit authenticate", new Object[0]);
            this.commit();
        }
        catch (SQLException e) {
            try {
                LOG.error((Throwable)e, "Account: {0} authentication failed ", new Object[]{username});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", this.config.getTable()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly(stmt);
                this.closeConnection();
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)stmt);
        this.closeConnection();
        LOG.info("Account: {0} authenticated ", new Object[]{username});
        return uid;
    }

    public String quoteName(String value) {
        return DatabaseTableSQLUtil.quoteName(this.config.getQuoting(), value);
    }

    public int getColumnType(String columnName) {
        if (this.columnSQLTypes == null) {
            this.cacheSchema();
        }
        assert (this.columnSQLTypes != null);
        Integer columnType = this.columnSQLTypes.get(columnName);
        if (columnType == null) {
            columnType = 0;
        }
        return columnType;
    }

    public String getColumnName(String attributeName) {
        if (Name.NAME.equalsIgnoreCase(attributeName)) {
            LOG.ok("attribute name {0} map to key column", new Object[]{attributeName});
            return this.config.getKeyColumn();
        }
        if (Uid.NAME.equalsIgnoreCase(attributeName)) {
            LOG.ok("attribute name {0} map to key column", new Object[]{attributeName});
            return this.config.getKeyColumn();
        }
        if (!StringUtil.isBlank((String)this.config.getPasswordColumn()) && OperationalAttributes.PASSWORD_NAME.equalsIgnoreCase(attributeName)) {
            LOG.ok("attribute name {0} map to password column", new Object[]{attributeName});
            return this.config.getPasswordColumn();
        }
        if (OperationalAttributes.ENABLE_NAME.equalsIgnoreCase(attributeName)) {
            LOG.ok("attribute __ENABLE__ {0} map to key column", new Object[]{attributeName});
            return this.config.getStatusColumn();
        }
        return attributeName;
    }

    private void cacheSchema() {
        Set<AttributeInfo> attrInfoSet = this.buildSelectBasedAttributeInfos();
        LOG.info("cacheSchema on {0}", new Object[]{attrInfoSet});
        this.defaultAttributesToGet = new HashSet<String>();
        for (AttributeInfo info : attrInfoSet) {
            String name = info.getName();
            if (!info.isReturnedByDefault() && (!name.equals(OperationalAttributes.PASSWORD_NAME) || !this.config.isRetrievePassword())) continue;
            this.defaultAttributesToGet.add(name);
        }
        SchemaBuilder schemaBld = new SchemaBuilder(this.getClass());
        ObjectClassInfoBuilder ociB = new ObjectClassInfoBuilder();
        ociB.setType(ObjectClass.ACCOUNT_NAME);
        ociB.addAllAttributeInfo(attrInfoSet);
        ObjectClassInfo oci = ociB.build();
        schemaBld.defineObjectClass(oci);
        if (StringUtil.isBlank((String)this.config.getPasswordColumn())) {
            LOG.info("no password column, remove the AuthenticateOp", new Object[0]);
            schemaBld.removeSupportedObjectClass(AuthenticateOp.class, oci);
        }
        if (StringUtil.isBlank((String)this.config.getChangeLogColumn())) {
            LOG.info("no changeLog column, remove the SyncOp", new Object[0]);
            schemaBld.removeSupportedObjectClass(SyncOp.class, oci);
        }
        this.schema = schemaBld.build();
        LOG.ok("schema built", new Object[0]);
    }

    private Set<AttributeInfo> buildSelectBasedAttributeInfos() {
        Set<AttributeInfo> attrInfo;
        String SCHEMA_QUERY = "SELECT * FROM {0} WHERE {1} IS NULL";
        LOG.info("get schema from the table", new Object[0]);
        String sql = MessageFormat.format("SELECT * FROM {0} WHERE {1} IS NULL", this.config.getTable(), this.quoteName(this.config.getKeyColumn()));
        ResultSet rset = null;
        Statement stmt = null;
        try {
            stmt = this.getConn().getConnection().createStatement();
            LOG.info("executeQuery ''{0}''", new Object[]{sql});
            rset = stmt.executeQuery(sql);
            LOG.ok("query executed", new Object[0]);
            attrInfo = this.buildAttributeInfoSet(rset);
            LOG.info("commit get schema", new Object[0]);
            this.commit();
        }
        catch (SQLException ex) {
            try {
                LOG.error((Throwable)ex, "buildSelectBasedAttributeInfo in SQL: ''{0}''", new Object[]{sql});
                SQLUtil.rollbackQuietly((DatabaseConnection)this.getConn());
                throw new ConnectorException(this.config.getMessage("can.not.read", this.config.getTable()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rset);
                SQLUtil.closeQuietly((Statement)stmt);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)rset);
        SQLUtil.closeQuietly((Statement)stmt);
        LOG.ok("schema created", new Object[0]);
        return attrInfo;
    }

    private Set<AttributeInfo> buildAttributeInfoSet(ResultSet rset) throws SQLException {
        LOG.info("build AttributeInfoSet", new Object[0]);
        HashSet<AttributeInfo> attrInfo = new HashSet<AttributeInfo>();
        this.columnSQLTypes = CollectionUtil.newCaseInsensitiveMap();
        this.stringColumnRequired = CollectionUtil.newCaseInsensitiveSet();
        ResultSetMetaData meta = rset.getMetaData();
        int count = meta.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            boolean required;
            Class<String> dataType;
            String name = meta.getColumnName(i);
            AttributeInfoBuilder attrBld = new AttributeInfoBuilder();
            Integer columnType = meta.getColumnType(i);
            LOG.ok("column name {0} has type {1}", new Object[]{name, columnType});
            this.columnSQLTypes.put(name, columnType);
            if (name.equalsIgnoreCase(this.config.getPasswordColumn())) {
                attrInfo.add(OperationalAttributeInfos.PASSWORD);
                LOG.ok("password column in password attribute in the schema", new Object[0]);
                continue;
            }
            if (name.equalsIgnoreCase(this.config.getChangeLogColumn())) {
                LOG.ok("skip changelog column from the schema", new Object[0]);
                continue;
            }
            if (name.equalsIgnoreCase(this.config.getStatusColumn())) {
                dataType = this.getConn().getSms().getSQLAttributeType(columnType);
                attrBld.setType(dataType);
                attrBld.setName(OperationalAttributes.ENABLE_NAME);
                required = meta.isNullable(i) == 0;
                attrBld.setRequired(required);
                attrBld.setReturnedByDefault(true);
                attrInfo.add(attrBld.build());
                continue;
            }
            dataType = this.getConn().getSms().getSQLAttributeType(columnType);
            attrBld.setType(dataType);
            attrBld.setName(name);
            required = meta.isNullable(i) == 0;
            attrBld.setRequired(required);
            if (required && dataType.isAssignableFrom(String.class)) {
                LOG.ok("the column name {0} is string type and required", new Object[]{name});
                this.stringColumnRequired.add(name);
            }
            attrBld.setReturnedByDefault(this.isReturnedByDefault(dataType));
            attrInfo.add(attrBld.build());
            LOG.ok("the column name {0} has data type {1}", new Object[]{name, dataType});
            if (!name.equalsIgnoreCase(this.config.getKeyColumn())) continue;
            AttributeInfoBuilder attrBldName = new AttributeInfoBuilder();
            attrBldName.setName(Name.NAME);
            attrBldName.setRequired(true);
            attrInfo.add(attrBldName.build());
            LOG.ok("key column in name attribute in the schema", new Object[0]);
        }
        LOG.ok("the Attribute InfoSet is done", new Object[0]);
        return attrInfo;
    }

    private boolean isReturnedByDefault(Class<?> dataType) {
        return !byte[].class.equals(dataType);
    }

    private ConnectorObjectBuilder buildConnectorObject(Map<String, SQLParam> columnValues) {
        LOG.info("build ConnectorObject", new Object[0]);
        String uidValue = null;
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        for (Map.Entry<String, SQLParam> colValue : columnValues.entrySet()) {
            String columnName = colValue.getKey();
            SQLParam param = colValue.getValue();
            if (columnName.equalsIgnoreCase(this.config.getKeyColumn())) {
                if (param == null || param.getValue() == null) {
                    String msg = "Name cannot be null.";
                    LOG.error(msg, new Object[0]);
                    throw new IllegalArgumentException(msg);
                }
                uidValue = param.getValue().toString();
                bld.setName(uidValue);
                bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)columnName, (Object[])new Object[]{param.getValue()})});
                continue;
            }
            if (columnName.equalsIgnoreCase(this.config.getPasswordColumn())) {
                if (this.config.isRetrievePassword()) {
                    String pwd = (String)param.getValue();
                    try {
                        if (param.getValue() == null) continue;
                        bld.addAttribute(new Attribute[]{AttributeBuilder.buildPassword((char[])this.decodePassword(pwd).toCharArray())});
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e, "Error decoding password", new Object[0]);
                        bld.addAttribute(new Attribute[]{AttributeBuilder.buildPassword((char[])pwd.toCharArray())});
                    }
                    continue;
                }
                LOG.ok("No Password in the result object", new Object[0]);
                continue;
            }
            if (columnName.equalsIgnoreCase(this.config.getStatusColumn())) {
                LOG.ok("statusColumn attribute in the result", new Object[0]);
                if (param == null || param.getValue() == null) continue;
                bld.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((boolean)this.isEnabled(param.getValue().toString()))});
                continue;
            }
            if (param != null && param.getValue() != null) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)columnName, (Object[])new Object[]{param.getValue()})});
                continue;
            }
            bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)columnName)});
        }
        if (uidValue == null) {
            String msg = "The uid value is missing in query.";
            LOG.error("The uid value is missing in query.", new Object[0]);
            throw new IllegalStateException("The uid value is missing in query.");
        }
        bld.setUid(new Uid(uidValue));
        bld.setObjectClass(ObjectClass.ACCOUNT);
        LOG.ok("ConnectorObject is built", new Object[0]);
        return bld;
    }

    private SyncDeltaBuilder buildSyncDelta(Map<String, SQLParam> columnValues) {
        LOG.info("buildSyncDelta", new Object[0]);
        SyncDeltaBuilder bld = new SyncDeltaBuilder();
        SQLParam tokenParam = columnValues.get(this.config.getChangeLogColumn());
        if (tokenParam == null) {
            throw new IllegalArgumentException(this.config.getMessage("invalid.sync.token.value"));
        }
        Object token = tokenParam.getValue();
        if (token == null) {
            LOG.ok("token value is null, replacing to 0L", new Object[0]);
            token = 0L;
        }
        bld.setToken(new SyncToken(token));
        bld.setObject(this.buildConnectorObject(columnValues).build());
        bld.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
        LOG.ok("SyncDeltaBuilder is ok", new Object[0]);
        return bld;
    }

    private Set<String> resolveColumnNamesToGet(OperationOptions options) {
        Set attributesToGet = this.getDefaultAttributesToGet();
        if (options != null && options.getAttributesToGet() != null) {
            attributesToGet = CollectionUtil.newSet((Object[])options.getAttributesToGet());
            attributesToGet.add(Uid.NAME);
        }
        HashSet<String> columnNamesToGet = new HashSet<String>();
        for (String attributeName : attributesToGet) {
            String columnName = this.getColumnName(attributeName);
            if (!StringUtil.isNotBlank((String)columnName)) continue;
            columnNamesToGet.add(this.quoteName(columnName));
        }
        if (StringUtil.isNotBlank((String)this.config.getStatusColumn()) && !columnNamesToGet.contains(this.config.getStatusColumn())) {
            columnNamesToGet.add(this.config.getStatusColumn());
        }
        return columnNamesToGet;
    }

    private Set<String> getDefaultAttributesToGet() {
        if (this.defaultAttributesToGet == null) {
            this.cacheSchema();
        }
        assert (this.defaultAttributesToGet != null);
        return this.defaultAttributesToGet;
    }

    private Set<String> getStringColumnReguired() {
        if (this.stringColumnRequired == null) {
            this.cacheSchema();
        }
        assert (this.stringColumnRequired != null);
        return this.stringColumnRequired;
    }

    private boolean isEnabled(String status) {
        return StringUtil.isBlank((String)status) ? StringUtil.isNotBlank((String)this.config.getDisabledStatusValue()) : !status.equalsIgnoreCase(this.config.getDisabledStatusValue());
    }

    private String getStatusColumnValue(String enabled) {
        return "TRUE".equalsIgnoreCase(enabled) ? this.config.getEnabledStatusValue() : this.config.getDisabledStatusValue();
    }

    private <T extends OperationBuilder> void handleAttribute(T builder, Attribute attribute, boolean hashedPassword, String cname) {
        block12: {
            Object value = AttributeUtil.getSingleValue((Attribute)attribute);
            if (this.isToBeEmpty(cname, value)) {
                LOG.info("Attribute {0} should be empty", new Object[]{cname});
                value = "";
            }
            int sqlType = this.getColumnType(cname);
            LOG.info("attribute {0} fit column {1} and sql type {2}", new Object[]{attribute.getName(), cname, sqlType});
            try {
                if (sqlType == 91 || sqlType == 93 || sqlType == 92) {
                    Object tokenVal;
                    try {
                        tokenVal = SQLUtil.attribute2jdbcValue((Object)value.toString(), (int)sqlType);
                    }
                    catch (Exception e) {
                        tokenVal = new Timestamp(DatabaseTableSQLUtil.tsAsLong(value.toString()));
                    }
                    builder.addBind(new SQLParam(this.quoteName(cname), tokenVal, sqlType));
                    break block12;
                }
                if (cname.equalsIgnoreCase(this.config.getStatusColumn())) {
                    builder.addBind(new SQLParam(this.quoteName(cname), (Object)this.getStatusColumnValue(value.toString()), sqlType));
                } else if (cname.equalsIgnoreCase(this.config.getPasswordColumn())) {
                    if (hashedPassword) {
                        final String[] password = new String[]{null};
                        ((GuardedString)value).access(new GuardedString.Accessor(){

                            public void access(char[] clearChars) {
                                password[0] = new String(clearChars);
                            }
                        });
                        String encodedPassword = this.changeCaseOfEncodedPassword(password[0]);
                        builder.addBind(new SQLParam(this.quoteName(cname), (Object)new GuardedString(encodedPassword.toCharArray()), sqlType));
                    } else {
                        builder.addBind(new SQLParam(this.quoteName(cname), (Object)this.encodePassword((GuardedString)value), sqlType));
                    }
                } else {
                    builder.addBind(new SQLParam(this.quoteName(cname), value, sqlType));
                }
            }
            catch (Throwable t) {
                LOG.error(t, "Error parsing value '{0}' of attribute {1}:{2}", new Object[]{value, cname, sqlType});
            }
        }
    }

    private GuardedString encodePassword(GuardedString guarded) throws PasswordEncodingException {
        String encodedPwd;
        EncodeAlgorithm algorithm;
        String cipherAlgorithm;
        try {
            cipherAlgorithm = SupportedAlgorithm.valueOf(this.config.getCipherAlgorithm()).getAlgorithm();
        }
        catch (Exception e) {
            cipherAlgorithm = this.config.getCipherAlgorithm();
        }
        String cipherKey = this.config.getCipherKey();
        try {
            algorithm = (EncodeAlgorithm)Class.forName(cipherAlgorithm).newInstance();
            if (StringUtil.isNotBlank((String)cipherKey)) {
                algorithm.setKey(cipherKey);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error retrieving algorithm {0}", new Object[]{cipherAlgorithm});
            throw new PasswordEncodingException(e.getMessage());
        }
        final String[] password = new String[]{null};
        guarded.access(new GuardedString.Accessor(){

            public void access(char[] clearChars) {
                password[0] = new String(clearChars);
            }
        });
        try {
            encodedPwd = algorithm.encode(password[0], this.config.getPasswordCharset());
        }
        catch (UnsupportedPasswordCharsetException e) {
            LOG.error((Throwable)e, "Error encoding password charset not supported", new Object[0]);
            throw new PasswordEncodingException(e.getMessage());
        }
        GuardedString encoded = StringUtil.isNotBlank((String)encodedPwd) ? new GuardedString(this.changeCaseOfEncodedPassword(encodedPwd).toCharArray()) : guarded;
        return encoded;
    }

    private String changeCaseOfEncodedPassword(String encodedPwd) {
        if (StringUtil.isNotBlank((String)encodedPwd)) {
            return this.config.isPwdEncodeToUpperCase() ? encodedPwd.toUpperCase() : (this.config.isPwdEncodeToLowerCase() ? encodedPwd.toLowerCase() : encodedPwd);
        }
        return null;
    }

    private String decodePassword(String password) throws PasswordDecodingException {
        EncodeAlgorithm algorithm;
        String cipherAlgorithm;
        try {
            cipherAlgorithm = SupportedAlgorithm.valueOf(this.config.getCipherAlgorithm()).getAlgorithm();
        }
        catch (Exception e) {
            cipherAlgorithm = this.config.getCipherAlgorithm();
        }
        String cipherKey = this.config.getCipherKey();
        try {
            algorithm = (EncodeAlgorithm)Class.forName(cipherAlgorithm).newInstance();
            if (StringUtil.isNotBlank((String)cipherKey)) {
                algorithm.setKey(cipherKey);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error retrieving algorithm {0}", new Object[]{cipherAlgorithm});
            throw new PasswordDecodingException(e.getMessage());
        }
        String decoded = algorithm.decode(password, this.config.getPasswordCharset());
        return decoded;
    }
}

