/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTask;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Flowable")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="flowable/userWorkflowTasks")
public interface UserWorkflowTaskService
extends JAXRSService {
    @GET
    @Path(value="tasks/{userKey}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<WorkflowTask> getAvailableTasks(@NotNull @PathParam(value="userKey") String var1);

    @Parameter(name="userKey", description="user key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @POST
    @Path(value="tasks/{userKey}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public UserTO executeNextTask(@NotNull WorkflowTaskExecInput var1);
}

