/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.time.OffsetDateTime;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAReportExec;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class JPAReportExecDAO
extends AbstractDAO<ReportExec>
implements ReportExecDAO {
    public ReportExec find(String key) {
        return (ReportExec)this.entityManager().find(JPAReportExec.class, (Object)key);
    }

    public List<ReportExec> findRecent(int max) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC", ReportExec.class);
        query.setMaxResults(max);
        return query.getResultList();
    }

    protected ReportExec findLatest(Report report, String field) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.report=:report ORDER BY e." + field + " DESC", ReportExec.class);
        query.setParameter("report", (Object)report);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (ReportExec)result.iterator().next();
    }

    public ReportExec findLatestStarted(Report report) {
        return this.findLatest(report, "start");
    }

    public ReportExec findLatestEnded(Report report) {
        return this.findLatest(report, "end");
    }

    protected StringBuilder query(StringBuilder select, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder query = select.append(JPAReportExec.class.getSimpleName()).append(" e WHERE e.report=:report ");
        if (before != null) {
            query.append("AND e.start <= :before ");
        }
        if (after != null) {
            query.append("AND e.start >= :after ");
        }
        return query;
    }

    public int count(Report report, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), before, after);
        Query query = this.entityManager().createQuery(queryString.toString());
        query.setParameter("report", (Object)report);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    protected String toOrderByStatement(List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        for (OrderByClause clause : orderByClauses) {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(JPAReportExec.class, (String)field) == null) continue;
            statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
        }
        if (statement.length() == 0) {
            statement.append(" ORDER BY e.id DESC");
        } else {
            statement.insert(0, " ORDER BY ");
        }
        return statement.toString();
    }

    public List<ReportExec> findAll(Report report, OffsetDateTime before, OffsetDateTime after, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), before, after).append(this.toOrderByStatement(orderByClauses));
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), ReportExec.class);
        query.setParameter("report", (Object)report);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    @Transactional(rollbackFor={Throwable.class})
    public ReportExec save(ReportExec execution) {
        return (ReportExec)this.entityManager().merge((Object)execution);
    }

    public void delete(String key) {
        ReportExec execution = this.find(key);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    public void delete(ReportExec execution) {
        if (execution.getReport() != null) {
            execution.getReport().getExecs().remove(execution);
        }
        this.entityManager().remove((Object)execution);
    }
}

